/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.values;

import java.math.BigDecimal;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.query.execution.IQueryFieldAction;
import org.neodatis.odb.core.query.values.AbstractQueryFieldAction;
import org.neodatis.odb.impl.core.query.values.ValuesUtil;

public class MinValueAction
extends AbstractQueryFieldAction {
    private BigDecimal minValue = new BigDecimal(Long.MAX_VALUE);
    private OID oidOfMinValues = null;

    public MinValueAction(String attributeName, String alias) {
        super(attributeName, alias, false);
    }

    @Override
    public void execute(OID oid, AttributeValuesMap values) {
        Number n = (Number)values.get(this.attributeName);
        BigDecimal bd = ValuesUtil.convert(n);
        if (this.minValue.compareTo(bd) > 0) {
            this.oidOfMinValues = oid;
            this.minValue = bd;
        }
    }

    @Override
    public Object getValue() {
        return this.minValue;
    }

    @Override
    public void end() {
    }

    @Override
    public void start() {
    }

    public OID getOidOfMinValues() {
        return this.oidOfMinValues;
    }

    @Override
    public IQueryFieldAction copy() {
        return new MinValueAction(this.attributeName, this.alias);
    }
}

