/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.oid;

import org.neodatis.odb.DatabaseId;
import org.neodatis.odb.ExternalOID;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.impl.core.oid.DatabaseIdImpl;
import org.neodatis.odb.impl.core.oid.OdbClassOID;
import org.neodatis.odb.impl.core.oid.OdbObjectOID;
import org.neodatis.tool.wrappers.OdbString;

public class ExternalObjectOID
extends OdbObjectOID
implements ExternalOID {
    private DatabaseId databaseId;

    public ExternalObjectOID(OID oid, DatabaseId databaseId) {
        super(oid.getObjectId());
        this.databaseId = databaseId;
    }

    @Override
    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    @Override
    public String oidToString() {
        StringBuffer buffer = new StringBuffer("ext-object-oid").append(":");
        buffer.append(this.databaseId.toString()).append(":").append(this.oid);
        return buffer.toString();
    }

    public static ExternalObjectOID oidFromString(String oidString) {
        String[] tokens = OdbString.split(oidString, ":");
        if (tokens.length != 3 || !tokens[0].equals("ext-object-oid")) {
            throw new ODBRuntimeException(NeoDatisError.INVALID_OID_REPRESENTATION.addParameter(oidString));
        }
        long oid = Long.parseLong(tokens[2]);
        String databaseid = tokens[1];
        return new ExternalObjectOID(new OdbClassOID(oid), DatabaseIdImpl.fromString(databaseid));
    }

    @Override
    public int getType() {
        return 5;
    }
}

