/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.btree;

import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.exception.BTreeException;
import org.neodatis.btree.impl.multiplevalue.BTreeNodeMultipleValuesPerKey;
import org.neodatis.odb.OID;

public class ODBBTreeNodeMultiple
extends BTreeNodeMultipleValuesPerKey {
    protected OID oid;
    protected OID[] childrenOids;
    protected OID parentOid;
    protected transient IBTreeNode parent;

    public ODBBTreeNodeMultiple() {
    }

    public ODBBTreeNodeMultiple(IBTree btree) {
        super(btree);
    }

    @Override
    public IBTreeNode getChildAt(int index, boolean throwExceptionIfNotExist) {
        OID oid = this.childrenOids[index];
        if (oid == null) {
            if (throwExceptionIfNotExist) {
                throw new BTreeException("Trying to load null child node at index " + index);
            }
            return null;
        }
        return this.btree.getPersister().loadNodeById(oid);
    }

    @Override
    public IBTreeNode getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        this.parent = this.btree.getPersister().loadNodeById(this.parentOid);
        return this.parent;
    }

    @Override
    public void setChildAt(IBTreeNode child, int index) {
        if (child != null) {
            if (child.getId() == null) {
                this.btree.getPersister().saveNode(child);
            }
            this.childrenOids[index] = (OID)child.getId();
            child.setParent(this);
        } else {
            this.childrenOids[index] = null;
        }
    }

    @Override
    public void setParent(IBTreeNode node) {
        this.parent = node;
        if (this.parent != null) {
            if (this.parent.getId() == null) {
                this.btree.getPersister().saveNode(this.parent);
            }
            this.parentOid = (OID)this.parent.getId();
        } else {
            this.parentOid = null;
        }
    }

    @Override
    public boolean hasParent() {
        return this.parentOid != null;
    }

    @Override
    protected void init() {
        this.childrenOids = new OID[this.maxNbChildren];
        this.parentOid = null;
        this.parent = null;
    }

    @Override
    public Object getId() {
        return this.oid;
    }

    @Override
    public void setId(Object id) {
        this.oid = (OID)id;
    }

    @Override
    public void clear() {
        super.clear();
        this.parent = null;
        this.parentOid = null;
        this.childrenOids = null;
        this.oid = null;
    }

    @Override
    public void deleteChildAt(int index) {
        this.childrenOids[index] = null;
        --this.nbChildren;
    }

    @Override
    public void moveChildFromTo(int sourceIndex, int destinationIndex, boolean throwExceptionIfDoesNotExist) {
        if (throwExceptionIfDoesNotExist && this.childrenOids[sourceIndex] == null) {
            throw new BTreeException("Trying to load null child node at index " + sourceIndex);
        }
        this.childrenOids[destinationIndex] = this.childrenOids[sourceIndex];
    }

    @Override
    public void setChildAt(IBTreeNode node, int childIndex, int indexDestination, boolean throwExceptionIfDoesNotExist) {
        OID childOid;
        this.childrenOids[indexDestination] = childOid = (OID)node.getChildIdAt(childIndex, throwExceptionIfDoesNotExist);
        if (childOid != null) {
            IBTreeNode child = this.btree.getPersister().loadNodeById(childOid);
            child.setParent(this);
            this.btree.getPersister().saveNode(child);
        }
    }

    @Override
    public void setNullChildAt(int childIndex) {
        this.childrenOids[childIndex] = null;
    }

    @Override
    public Object getChildIdAt(int childIndex, boolean throwExceptionIfDoesNotExist) {
        if (throwExceptionIfDoesNotExist && this.childrenOids[childIndex] == null) {
            throw new BTreeException("Trying to load null child node at index " + childIndex);
        }
        return this.childrenOids[childIndex];
    }

    @Override
    public Object getParentId() {
        return this.parentOid;
    }

    @Override
    public Object getValueAsObjectAt(int index) {
        return this.getValueAt(index);
    }
}

