/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.objectbrowser.update;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.server.layers.layer2.meta.ClientNonNativeObjectInfo;
import org.neodatis.odb.gui.IBrowserContainer;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.component.GUITool;
import org.neodatis.odb.gui.objectbrowser.hierarchy.HierarchicObjectBrowserPanel;
import org.neodatis.odb.gui.objectbrowser.hierarchy.ModalObjectBrowserDialog;
import org.neodatis.odb.gui.objectbrowser.update.OIDBuilder;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.tool.ObjectTool;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class ObjectIntrospectorPanel
extends JPanel
implements ActionListener {
    private IStorageEngine storageEngine;
    private ClassInfo classInfo;
    private JButton btCreate;
    private JButton btCancel;
    private Map textFields;
    private Map idsTextFieldsForButton;
    private Map classNames;
    private IBrowserContainer browser;
    private NonNativeObjectInfo nnoi;
    private ILogger logger;

    public ObjectIntrospectorPanel(IStorageEngine aStorageEngine, ClassInfo ci, IBrowserContainer aBrowser, NonNativeObjectInfo nnoi, ILogger logger) {
        this.storageEngine = aStorageEngine;
        this.classInfo = ci;
        this.textFields = new OdbHashMap();
        this.idsTextFieldsForButton = new OdbHashMap();
        this.classNames = new OdbHashMap();
        this.browser = aBrowser;
        this.nnoi = nnoi;
        this.logger = logger;
        this.init();
    }

    private void init() {
        JTextField textField = null;
        ClassAttributeInfo cai = null;
        int nbAttributes = this.classInfo.getAttributes().size();
        JPanel panelLabels = new JPanel(new GridLayout(nbAttributes + 1, 1, 5, 5));
        JPanel panelFields = new JPanel(new GridLayout(nbAttributes + 1, 1, 5, 5));
        JPanel panel1 = null;
        JPanel panel2 = null;
        String text = Messages.getString("Update object of type ") + this.classInfo.getFullClassName() + Messages.getString(" with oid= ") + this.nnoi.getOid();
        JPanel headerPanel = GUITool.buildHeaderPanel(text);
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)headerPanel, "North");
        Color headerCellColor = new Color(0, 100, 15);
        JLabel label1 = new JLabel(Messages.getString("Attributes"));
        label1.setBackground(headerCellColor);
        panel1 = new JPanel();
        panel1.add(label1);
        panelLabels.add(panel1);
        JLabel label3 = new JLabel(Messages.getString("Value"));
        label3.setBackground(headerCellColor);
        panel2 = new JPanel();
        panel2.add(label3);
        panelFields.add(panel2);
        JButton btChoose = null;
        Dimension labelDimension = new Dimension(80, 20);
        JLabel label = null;
        AbstractObjectInfo aoi = null;
        for (int i = 0; i < nbAttributes; ++i) {
            cai = this.classInfo.getAttributeInfo(i);
            aoi = this.nnoi.getAttributeValueFromId(cai.getId());
            if (cai.isNative()) {
                if (cai.getAttributeType().isAtomicNative()) {
                    panel1 = new JPanel(new FlowLayout(0));
                    label = new JLabel(cai.getName(), 2);
                    label.setPreferredSize(labelDimension);
                    panel1.add(label);
                    panelLabels.add(panel1);
                    textField = new JTextField(20);
                    if (this.nnoi != null && !aoi.isNull() && aoi.isAtomicNativeObject()) {
                        textField.setText(ObjectTool.atomicNativeObjectToString((AtomicNativeObjectInfo)aoi, ObjectTool.ID_CALLER_IS_ODB_EXPLORER));
                    } else {
                        textField.setText("null object");
                    }
                    panel1.add(textField);
                } else if (cai.getAttributeType().isArrayOrCollection()) {
                    textField = new JTextField(8);
                    panel1 = new JPanel(new FlowLayout(0));
                    label = new JLabel(cai.getName(), 2);
                    label.setPreferredSize(labelDimension);
                    panel1.add(label);
                    panel1.add(textField);
                    JComboBox combo = this.buildClassesCombo();
                    panel1.add(combo);
                    btChoose = new JButton(Messages.getString("Add an object"));
                    panel1.add(btChoose);
                    btChoose.setActionCommand("browse-add." + cai.getFullClassname());
                    btChoose.addActionListener(this);
                    panelLabels.add(panel1);
                    this.idsTextFieldsForButton.put(btChoose, textField);
                    this.classNames.put(btChoose, combo);
                }
            } else {
                textField = new JTextField(4);
                NonNativeObjectInfo nn = (NonNativeObjectInfo)this.nnoi.getAttributeValueFromId(cai.getId());
                if (this.nnoi != null && nn != null && !nn.isNull()) {
                    textField.setText(String.valueOf(nn.getOid()));
                } else {
                    textField.setText("null object");
                }
                panel1 = new JPanel(new FlowLayout(0));
                label = new JLabel(cai.getName(), 2);
                label.setPreferredSize(labelDimension);
                panel1.add(label);
                panel1.add(textField);
                btChoose = new JButton(Messages.getString("Choose the object"));
                panel1.add(btChoose);
                btChoose.setActionCommand("browse-set." + cai.getFullClassname());
                btChoose.addActionListener(this);
                panelLabels.add(panel1);
                this.idsTextFieldsForButton.put(btChoose, textField);
            }
            this.textFields.put(cai, textField);
        }
        JPanel optionPanel = new JPanel();
        this.btCreate = new JButton(Messages.getString("Save Object"));
        this.btCancel = new JButton(Messages.getString("Cancel"));
        optionPanel.add(this.btCancel);
        optionPanel.add(this.btCreate);
        this.btCreate.setActionCommand("update");
        this.btCancel.setActionCommand("cancel");
        this.btCreate.addActionListener(this);
        this.btCancel.addActionListener(this);
        JPanel panelContent = new JPanel(new BorderLayout(5, 5));
        JPanel panel4 = new JPanel();
        panel4.add(panelLabels);
        panelContent.add((Component)panel4, "Center");
        JPanel panel3 = new JPanel(new BorderLayout(5, 5));
        panel3.add((Component)new JScrollPane(panelContent), "Center");
        panel3.add((Component)optionPanel, "South");
        this.add((Component)panel3, "Center");
    }

    private JComboBox buildClassesCombo() {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.storageEngine.getSession(true).getMetaModel().getAllClasses().iterator();
        ClassInfo ci = null;
        while (iterator.hasNext()) {
            ci = (ClassInfo)iterator.next();
            vector.add(ci.getFullClassName());
        }
        return new JComboBox(vector);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextField idTextField;
        OID oid;
        String className;
        String action = e.getActionCommand();
        String tokenSet = "browse-set.";
        String tokenAdd = "browse-add.";
        if (action.startsWith(tokenSet)) {
            className = OdbString.substring(action, tokenSet.length(), action.length());
            try {
                oid = this.chooseObject(className);
                if (oid != StorageEngineConstant.NULL_OBJECT_ID) {
                    idTextField = (JTextField)this.idsTextFieldsForButton.get(e.getSource());
                    idTextField.setText(String.valueOf(oid));
                }
            }
            catch (Exception e1) {
                this.logger.error("Error setting field", e1);
            }
        }
        if (action.startsWith(tokenAdd)) {
            className = ((JComboBox)this.classNames.get(e.getSource())).getSelectedItem().toString();
            try {
                oid = this.chooseObject(className);
                if (oid != StorageEngineConstant.NULL_OBJECT_ID) {
                    idTextField = (JTextField)this.idsTextFieldsForButton.get(e.getSource());
                    String ids = idTextField.getText();
                    idTextField.setText(ids + (ids.length() > 0 ? "," : "") + String.valueOf(oid));
                }
            }
            catch (Exception e1) {
                this.logger.error("Error setting field", e1);
            }
        }
        if ("update".equals(action)) {
            try {
                this.updateObject();
            }
            catch (Exception e1) {
                this.logger.error("Error setting updating", e1);
                JOptionPane.showMessageDialog(this, "Error while updating object : " + e1.getMessage());
            }
        }
        if ("cancel".equals(action)) {
            this.btCancel.setEnabled(false);
            this.btCreate.setEnabled(false);
        }
    }

    private void updateObject() throws Exception {
        Iterator iterator = this.textFields.keySet().iterator();
        ClassAttributeInfo cai = null;
        NonNativeObjectInfo newNnoi = null;
        newNnoi = this.storageEngine.isLocal() ? new NonNativeObjectInfo(this.classInfo) : new ClientNonNativeObjectInfo(this.classInfo);
        newNnoi.setOid(this.nnoi.getOid());
        newNnoi.setPosition(this.nnoi.getPosition());
        while (iterator.hasNext()) {
            cai = (ClassAttributeInfo)iterator.next();
            String value = null;
            JTextField tfValue = (JTextField)this.textFields.get(cai);
            value = tfValue.getText();
            if (cai.isNative()) {
                if (value.equals("null object")) {
                    newNnoi.setAttributeValue(cai.getId(), new NullNativeObjectInfo(cai.getAttributeType()));
                    continue;
                }
                if (cai.getAttributeType().isAtomicNative()) {
                    newNnoi.setAttributeValue(cai.getId(), ObjectTool.stringToObjectInfo(cai.getAttributeType().getId(), value, ObjectTool.ID_CALLER_IS_ODB_EXPLORER, null));
                    continue;
                }
                if (cai.getAttributeType().isCollection()) {
                    ArrayList<AbstractObjectInfo> c = new ArrayList<AbstractObjectInfo>();
                    StringTokenizer tokenizer = new StringTokenizer(value, ",");
                    while (tokenizer.hasMoreElements()) {
                        c.add(new ObjectReference(OIDBuilder.buildObjectOID(tokenizer.nextElement().toString())));
                    }
                    CollectionObjectInfo coi = new CollectionObjectInfo(c);
                    newNnoi.setAttributeValue(cai.getId(), coi);
                }
                if (!cai.getAttributeType().isArray()) continue;
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                Object[] objects = new Object[tokenizer.countTokens()];
                int i = 0;
                while (tokenizer.hasMoreElements()) {
                    objects[i++] = new ObjectReference(OIDBuilder.buildObjectOID(tokenizer.nextElement().toString()));
                }
                ArrayObjectInfo aoi = new ArrayObjectInfo(objects);
                newNnoi.setAttributeValue(cai.getId(), aoi);
                continue;
            }
            if (value != null && value.length() > 0) {
                newNnoi.setAttributeValue(cai.getId(), new ObjectReference(OIDBuilder.buildObjectOID(value)));
                continue;
            }
            newNnoi.setAttributeValue(cai.getId(), new NonNativeNullObjectInfo(cai.getClassInfo()));
        }
        DLogger.info("Updating object:" + newNnoi);
        OID id = this.storageEngine.updateObject(newNnoi, false);
        this.btCancel.setEnabled(false);
        this.btCreate.setEnabled(false);
        this.btCreate.setText(Messages.getString("Object updated : id = " + id));
    }

    private OID chooseObject(String className) throws Exception {
        Objects l = this.storageEngine.getObjectInfos(new CriteriaQuery(className), true, -1, -1, false);
        ArrayList list = new ArrayList(l.size());
        list.addAll(l);
        ClassInfo classInfoToBrowse = this.storageEngine.getSession(true).getMetaModel().getClassInfo(className, true);
        HierarchicObjectBrowserPanel panel = new HierarchicObjectBrowserPanel(this.browser, this.storageEngine, classInfoToBrowse, list, false, this.logger);
        ModalObjectBrowserDialog modalBrowser = new ModalObjectBrowserDialog(panel);
        modalBrowser.pack();
        modalBrowser.setVisible(true);
        if (modalBrowser.objectHasBeenChoosen()) {
            return panel.getSelectedOid();
        }
        return StorageEngineConstant.NULL_OBJECT_ID;
    }
}

