/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server.connection;

import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.server.connection.ClientServerConnection;
import org.neodatis.odb.core.server.layers.layer3.IODBServerExt;
import org.neodatis.odb.core.server.layers.layer3.engine.Message;
import org.neodatis.odb.core.server.message.ConnectMessage;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.impl.core.server.transaction.ServerSession;

public class SameVmConnection
extends ClientServerConnection {
    private static final String LOG_ID = "SameVmConnectionThread";
    private ISession originalSession;

    public SameVmConnection(String baseIdentifier, IODBServerExt server, boolean automaticallyCreateDatabase) {
        super(server, automaticallyCreateDatabase);
    }

    @Override
    public String getName() {
        return "Same vm client ";
    }

    @Override
    public ServerSession getSession(String baseIdentifier) {
        return (ServerSession)this.sessionManager.getSession(baseIdentifier, true);
    }

    @Override
    public Message manageMessage(Message message) {
        ISession session;
        boolean isConnectMessage = message instanceof ConnectMessage;
        if (!isConnectMessage && (session = this.sessionManager.getSession(message.getBaseIdentifier(), false)) == null && OdbConfiguration.shareSameVmConnectionMultiThread()) {
            this.sessionManager.addSession(this.originalSession);
        }
        Message response = super.manageMessage(message);
        if (isConnectMessage) {
            this.originalSession = this.sessionManager.getSession(message.getBaseIdentifier(), true);
        }
        return response;
    }

    @Override
    public void clearMessageStreamerCache() {
    }
}

