/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.reader;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxImageCanvas;
import com.mxgraph.reader.mxGraphViewReader;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class mxGraphViewImageReader
extends mxGraphViewReader {
    protected Color background;
    protected boolean antiAlias;
    protected int border;
    protected boolean cropping;
    protected mxRectangle clip;

    public mxGraphViewImageReader() {
        this(null);
    }

    public mxGraphViewImageReader(Color background) {
        this(background, 0);
    }

    public mxGraphViewImageReader(Color background, int border) {
        this(background, border, true);
    }

    public mxGraphViewImageReader(Color background, int border, boolean antiAlias) {
        this(background, border, antiAlias, true);
    }

    public mxGraphViewImageReader(Color background, int border, boolean antiAlias, boolean cropping) {
        this.setBackground(background);
        this.setBorder(border);
        this.setAntiAlias(antiAlias);
        this.setCropping(cropping);
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean antiAlias) {
        this.antiAlias = antiAlias;
    }

    public boolean isCropping() {
        return this.cropping;
    }

    public void setCropping(boolean value) {
        this.cropping = value;
    }

    public mxRectangle getClip() {
        return this.clip;
    }

    public void setClip(mxRectangle value) {
        this.clip = value;
    }

    @Override
    public mxICanvas createCanvas(Map<String, Object> attrs) {
        int width = 0;
        int height = 0;
        int dx = 0;
        int dy = 0;
        mxRectangle tmp = this.getClip();
        if (tmp != null) {
            dx -= (int)tmp.getX();
            dy -= (int)tmp.getY();
            width = (int)tmp.getWidth();
            height = (int)tmp.getHeight();
        } else {
            int x = (int)Math.round(mxUtils.getDouble(attrs, "x"));
            int y = (int)Math.round(mxUtils.getDouble(attrs, "y"));
            width = (int)Math.round(mxUtils.getDouble(attrs, "width")) + this.border + 3;
            height = (int)Math.round(mxUtils.getDouble(attrs, "height")) + this.border + 3;
            if (this.isCropping()) {
                dx = -x + 3;
                dy = -y + 3;
            } else {
                width += x;
                height += y;
            }
        }
        mxImageCanvas canvas = new mxImageCanvas(this.createGraphicsCanvas(), width, height, this.getBackground(), this.isAntiAlias());
        canvas.setTranslate(dx, dy);
        return canvas;
    }

    protected mxGraphics2DCanvas createGraphicsCanvas() {
        return new mxGraphics2DCanvas();
    }

    public static BufferedImage convert(String filename, mxGraphViewImageReader viewReader) throws ParserConfigurationException, SAXException, IOException {
        return mxGraphViewImageReader.convert(new InputSource(new FileInputStream(filename)), viewReader);
    }

    public static BufferedImage convert(InputSource inputSource, mxGraphViewImageReader viewReader) throws ParserConfigurationException, SAXException, IOException {
        BufferedImage result = null;
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setContentHandler(viewReader);
        reader.parse(inputSource);
        if (viewReader.getCanvas() instanceof mxImageCanvas) {
            result = ((mxImageCanvas)viewReader.getCanvas()).destroy();
        }
        return result;
    }
}

