/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing.editor;

import com.mxgraph.examples.swing.editor.BasicGraphEditor;
import com.mxgraph.examples.swing.editor.EditorActions;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;

public class EditorToolBar
extends JToolBar {
    private static final long serialVersionUID = -8015443128436394471L;
    private boolean ignoreZoomChange = false;

    public EditorToolBar(final BasicGraphEditor editor, int orientation) {
        super(orientation);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), this.getBorder()));
        this.setFloatable(false);
        this.add(editor.bind("New", new EditorActions.NewAction(), "/com/mxgraph/examples/swing/images/new.gif"));
        this.add(editor.bind("Open", new EditorActions.OpenAction(), "/com/mxgraph/examples/swing/images/open.gif"));
        this.add(editor.bind("Save", new EditorActions.SaveAction(false), "/com/mxgraph/examples/swing/images/save.gif"));
        this.addSeparator();
        this.add(editor.bind("Print", new EditorActions.PrintAction(), "/com/mxgraph/examples/swing/images/print.gif"));
        this.addSeparator();
        this.add(editor.bind("Cut", TransferHandler.getCutAction(), "/com/mxgraph/examples/swing/images/cut.gif"));
        this.add(editor.bind("Copy", TransferHandler.getCopyAction(), "/com/mxgraph/examples/swing/images/copy.gif"));
        this.add(editor.bind("Paste", TransferHandler.getPasteAction(), "/com/mxgraph/examples/swing/images/paste.gif"));
        this.addSeparator();
        this.add(editor.bind("Delete", mxGraphActions.getDeleteAction(), "/com/mxgraph/examples/swing/images/delete.gif"));
        this.addSeparator();
        this.add(editor.bind("Undo", new EditorActions.HistoryAction(true), "/com/mxgraph/examples/swing/images/undo.gif"));
        this.add(editor.bind("Redo", new EditorActions.HistoryAction(false), "/com/mxgraph/examples/swing/images/redo.gif"));
        this.addSeparator();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ArrayList<String> fonts = new ArrayList<String>();
        fonts.addAll(Arrays.asList("Helvetica", "Verdana", "Times New Roman", "Garamond", "Courier New", "-"));
        fonts.addAll(Arrays.asList(env.getAvailableFontFamilyNames()));
        final JComboBox<Object> fontCombo = new JComboBox<Object>(fonts.toArray());
        fontCombo.setEditable(true);
        fontCombo.setMinimumSize(new Dimension(120, 0));
        fontCombo.setPreferredSize(new Dimension(120, 0));
        fontCombo.setMaximumSize(new Dimension(120, 100));
        this.add(fontCombo);
        fontCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String font = fontCombo.getSelectedItem().toString();
                if (font != null && !font.equals("-")) {
                    mxGraph graph = editor.getGraphComponent().getGraph();
                    graph.setCellStyles(mxConstants.STYLE_FONTFAMILY, font);
                }
            }
        });
        final JComboBox<Object> sizeCombo = new JComboBox<Object>(new Object[]{"6pt", "8pt", "9pt", "10pt", "12pt", "14pt", "18pt", "24pt", "30pt", "36pt", "48pt", "60pt"});
        sizeCombo.setEditable(true);
        sizeCombo.setMinimumSize(new Dimension(65, 0));
        sizeCombo.setPreferredSize(new Dimension(65, 0));
        sizeCombo.setMaximumSize(new Dimension(65, 100));
        this.add(sizeCombo);
        sizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mxGraph graph = editor.getGraphComponent().getGraph();
                graph.setCellStyles(mxConstants.STYLE_FONTSIZE, sizeCombo.getSelectedItem().toString().replace("pt", ""));
            }
        });
        this.addSeparator();
        this.add(editor.bind("Bold", new EditorActions.FontStyleAction(true), "/com/mxgraph/examples/swing/images/bold.gif"));
        this.add(editor.bind("Italic", new EditorActions.FontStyleAction(false), "/com/mxgraph/examples/swing/images/italic.gif"));
        this.addSeparator();
        this.add(editor.bind("Left", new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, "left"), "/com/mxgraph/examples/swing/images/left.gif"));
        this.add(editor.bind("Center", new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, "center"), "/com/mxgraph/examples/swing/images/center.gif"));
        this.add(editor.bind("Right", new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, "right"), "/com/mxgraph/examples/swing/images/right.gif"));
        this.addSeparator();
        this.add(editor.bind("Font", new EditorActions.ColorAction("Font", mxConstants.STYLE_FONTCOLOR), "/com/mxgraph/examples/swing/images/fontcolor.gif"));
        this.add(editor.bind("Stroke", new EditorActions.ColorAction("Stroke", mxConstants.STYLE_STROKECOLOR), "/com/mxgraph/examples/swing/images/linecolor.gif"));
        this.add(editor.bind("Fill", new EditorActions.ColorAction("Fill", mxConstants.STYLE_FILLCOLOR), "/com/mxgraph/examples/swing/images/fillcolor.gif"));
        this.addSeparator();
        final mxGraphView view = editor.getGraphComponent().getGraph().getView();
        final JComboBox<Object> zoomCombo = new JComboBox<Object>(new Object[]{"400%", "200%", "150%", "100%", "75%", "50%", mxResources.get("page"), mxResources.get("width"), mxResources.get("actualSize")});
        zoomCombo.setEditable(true);
        zoomCombo.setMinimumSize(new Dimension(75, 0));
        zoomCombo.setPreferredSize(new Dimension(75, 0));
        zoomCombo.setMaximumSize(new Dimension(75, 100));
        zoomCombo.setMaximumRowCount(9);
        this.add(zoomCombo);
        mxEventSource.mxIEventListener scaleTracker = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object sender, mxEventObject evt) {
                EditorToolBar.this.ignoreZoomChange = true;
                try {
                    zoomCombo.setSelectedItem((int)Math.round(100.0 * view.getScale()) + "%");
                }
                finally {
                    EditorToolBar.this.ignoreZoomChange = false;
                }
            }
        };
        view.getGraph().getView().addListener("scale", scaleTracker);
        view.getGraph().getView().addListener("scaleAndTranslate", scaleTracker);
        scaleTracker.invoke(null, null);
        zoomCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mxGraphComponent graphComponent = editor.getGraphComponent();
                if (!EditorToolBar.this.ignoreZoomChange) {
                    String zoom = zoomCombo.getSelectedItem().toString();
                    if (zoom.equals(mxResources.get("page"))) {
                        graphComponent.setPageVisible(true);
                        graphComponent.setZoomPolicy(1);
                    } else if (zoom.equals(mxResources.get("width"))) {
                        graphComponent.setPageVisible(true);
                        graphComponent.setZoomPolicy(2);
                    } else if (zoom.equals(mxResources.get("actualSize"))) {
                        graphComponent.zoomActual();
                    } else {
                        try {
                            zoom = zoom.replace("%", "");
                            double scale = Math.min(16.0, Math.max(0.01, Double.parseDouble(zoom) / 100.0));
                            graphComponent.zoomTo(scale, graphComponent.isCenterZoom());
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(editor, ex.getMessage());
                        }
                    }
                }
            }
        });
    }
}

