/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing.editor;

import com.mxgraph.analysis.mxDistanceCostFunction;
import com.mxgraph.analysis.mxGraphAnalysis;
import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.examples.swing.editor.BasicGraphEditor;
import com.mxgraph.examples.swing.editor.DefaultFileFilter;
import com.mxgraph.examples.swing.editor.EditorPalette;
import com.mxgraph.examples.swing.editor.EditorRuler;
import com.mxgraph.io.mxCodec;
import com.mxgraph.io.mxGdCodec;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.shape.mxStencilShape;
import com.mxgraph.swing.handler.mxConnectionHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.mxGraphOutline;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.swing.view.mxCellEditor;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.util.png.mxPngEncodeParam;
import com.mxgraph.util.png.mxPngImageEncoder;
import com.mxgraph.util.png.mxPngTextDecoder;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.w3c.dom.Document;

public class EditorActions {
    public static final BasicGraphEditor getEditor(ActionEvent e) {
        if (e.getSource() instanceof Component) {
            Component component;
            for (component = (Component)e.getSource(); component != null && !(component instanceof BasicGraphEditor); component = component.getParent()) {
            }
            return (BasicGraphEditor)component;
        }
        return null;
    }

    public static class StyleAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                mxGraph graph = graphComponent.getGraph();
                String initial = graph.getModel().getStyle(graph.getSelectionCell());
                String value = (String)JOptionPane.showInputDialog(graphComponent, mxResources.get("style"), mxResources.get("style"), -1, null, null, initial);
                if (value != null) {
                    graph.setCellStyle(value);
                }
            }
        }
    }

    public static class PageBackgroundAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                Color newColor = JColorChooser.showDialog(graphComponent, mxResources.get("pageBackground"), null);
                if (newColor != null) {
                    graphComponent.setPageBackgroundColor(newColor);
                }
                graphComponent.repaint();
            }
        }
    }

    public static class BackgroundAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                Color newColor = JColorChooser.showDialog(graphComponent, mxResources.get("background"), null);
                if (newColor != null) {
                    graphComponent.getViewport().setOpaque(true);
                    graphComponent.getViewport().setBackground(newColor);
                }
                graphComponent.getGraph().repaint();
            }
        }
    }

    public static class BackgroundImageAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraphComponent graphComponent;
            String value;
            if (e.getSource() instanceof mxGraphComponent && (value = (String)JOptionPane.showInputDialog(graphComponent = (mxGraphComponent)e.getSource(), mxResources.get("backgroundImage"), "URL", -1, null, null, "http://www.callatecs.com/images/background2.JPG")) != null) {
                if (value.length() == 0) {
                    graphComponent.setBackgroundImage(null);
                } else {
                    BufferedImage background = mxUtils.loadImage(value);
                    if (background != null) {
                        graphComponent.setBackgroundImage(new ImageIcon(background));
                    }
                }
                graphComponent.getGraph().repaint();
            }
        }
    }

    public static class ColorAction
    extends AbstractAction {
        protected String name;
        protected String key;

        public ColorAction(String name, String key) {
            this.name = name;
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color newColor;
            mxGraphComponent graphComponent;
            mxGraph graph;
            if (e.getSource() instanceof mxGraphComponent && !(graph = (graphComponent = (mxGraphComponent)e.getSource()).getGraph()).isSelectionEmpty() && (newColor = JColorChooser.showDialog(graphComponent, this.name, null)) != null) {
                graph.setCellStyles(this.key, mxUtils.hexString(newColor));
            }
        }
    }

    public static class AutosizeAction
    extends AbstractAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph(e);
            if (graph != null && !graph.isSelectionEmpty()) {
                Object[] cells = graph.getSelectionCells();
                mxIGraphModel model = graph.getModel();
                model.beginUpdate();
                try {
                    for (int i = 0; i < cells.length; ++i) {
                        graph.updateCellSize(cells[i]);
                    }
                }
                finally {
                    model.endUpdate();
                }
            }
        }
    }

    public static class AlignCellsAction
    extends AbstractAction {
        protected String align;

        public AlignCellsAction(String align) {
            this.align = align;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph(e);
            if (graph != null && !graph.isSelectionEmpty()) {
                graph.alignCells(this.align);
            }
        }
    }

    public static class PromptValueAction
    extends AbstractAction {
        protected String key;
        protected String message;

        public PromptValueAction(String key, String message) {
            this.key = key;
            this.message = message;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value;
            mxGraph graph;
            if (e.getSource() instanceof Component && (graph = mxGraphActions.getGraph(e)) != null && !graph.isSelectionEmpty() && (value = (String)JOptionPane.showInputDialog((Component)e.getSource(), mxResources.get("value"), this.message, -1, null, null, "")) != null) {
                if (value.equals(mxConstants.NONE)) {
                    value = null;
                }
                graph.setCellStyles(this.key, value);
            }
        }
    }

    public static class KeyValueAction
    extends AbstractAction {
        protected String key;
        protected String value;

        public KeyValueAction(String key) {
            this(key, (String)null);
        }

        public KeyValueAction(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph(e);
            if (graph != null && !graph.isSelectionEmpty()) {
                graph.setCellStyles(this.key, this.value);
            }
        }
    }

    public static class SetStyleAction
    extends AbstractAction {
        protected String value;

        public SetStyleAction(String value) {
            this.value = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph(e);
            if (graph != null && !graph.isSelectionEmpty()) {
                graph.setCellStyle(this.value);
            }
        }
    }

    public static class SetLabelPositionAction
    extends AbstractAction {
        protected String labelPosition;
        protected String alignment;

        public SetLabelPositionAction(String labelPosition, String alignment) {
            this.labelPosition = labelPosition;
            this.alignment = alignment;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph(e);
            if (graph != null && !graph.isSelectionEmpty()) {
                graph.getModel().beginUpdate();
                try {
                    if (this.labelPosition.equals("left") || this.labelPosition.equals("center") || this.labelPosition.equals("right")) {
                        graph.setCellStyles(mxConstants.STYLE_LABEL_POSITION, this.labelPosition);
                        graph.setCellStyles(mxConstants.STYLE_ALIGN, this.alignment);
                    } else {
                        graph.setCellStyles(mxConstants.STYLE_VERTICAL_LABEL_POSITION, this.labelPosition);
                        graph.setCellStyles(mxConstants.STYLE_VERTICAL_ALIGN, this.alignment);
                    }
                }
                finally {
                    graph.getModel().endUpdate();
                }
            }
        }
    }

    public static class ToggleAction
    extends AbstractAction {
        protected String key;
        protected boolean defaultValue;

        public ToggleAction(String key) {
            this(key, false);
        }

        public ToggleAction(String key, boolean defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph(e);
            if (graph != null) {
                graph.toggleCellStyles(this.key, this.defaultValue);
            }
        }
    }

    public static class OpenAction
    extends AbstractAction {
        protected String lastDir;

        protected void resetEditor(BasicGraphEditor editor) {
            editor.setModified(false);
            editor.getUndoManager().clear();
            editor.getGraphComponent().zoomAndCenter();
        }

        protected void openXmlPng(BasicGraphEditor editor, File file) throws IOException {
            String value;
            Map<String, String> text = mxPngTextDecoder.decodeCompressedText(new FileInputStream(file));
            if (text != null && (value = text.get("mxGraphModel")) != null) {
                Document document = mxXmlUtils.parseXml(URLDecoder.decode(value, "UTF-8"));
                mxCodec codec = new mxCodec(document);
                codec.decode(document.getDocumentElement(), editor.getGraphComponent().getGraph().getModel());
                editor.setCurrentFile(file);
                this.resetEditor(editor);
                return;
            }
            JOptionPane.showMessageDialog(editor, mxResources.get("imageContainsNoDiagramData"));
        }

        protected void openGD(BasicGraphEditor editor, File file, String gdText) {
            mxGraph graph = editor.getGraphComponent().getGraph();
            String filename = file.getName();
            if (new File(filename = filename.substring(0, filename.length() - 4) + ".mxe").exists() && JOptionPane.showConfirmDialog(editor, mxResources.get("overwriteExistingFile")) != 0) {
                return;
            }
            ((mxGraphModel)graph.getModel()).clear();
            mxGdCodec.decode(gdText, graph);
            editor.getGraphComponent().zoomAndCenter();
            editor.setCurrentFile(new File(this.lastDir + "/" + filename));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph;
            BasicGraphEditor editor = EditorActions.getEditor(e);
            if (!(editor == null || editor.isModified() && JOptionPane.showConfirmDialog(editor, mxResources.get("loseChanges")) != 0 || (graph = editor.getGraphComponent().getGraph()) == null)) {
                String wd = this.lastDir != null ? this.lastDir : System.getProperty("user.dir");
                JFileChooser fc = new JFileChooser(wd);
                DefaultFileFilter defaultFilter = new DefaultFileFilter(".mxe", mxResources.get("allSupportedFormats") + " (.mxe, .png, .vdx)"){

                    @Override
                    public boolean accept(File file) {
                        String lcase = file.getName().toLowerCase();
                        return super.accept(file) || lcase.endsWith(".png") || lcase.endsWith(".vdx");
                    }
                };
                fc.addChoosableFileFilter(defaultFilter);
                fc.addChoosableFileFilter(new DefaultFileFilter(".mxe", "mxGraph Editor " + mxResources.get("file") + " (.mxe)"));
                fc.addChoosableFileFilter(new DefaultFileFilter(".png", "PNG+XML  " + mxResources.get("file") + " (.png)"));
                fc.addChoosableFileFilter(new DefaultFileFilter(".vdx", "XML Drawing  " + mxResources.get("file") + " (.vdx)"));
                fc.addChoosableFileFilter(new DefaultFileFilter(".txt", "Graph Drawing  " + mxResources.get("file") + " (.txt)"));
                fc.setFileFilter(defaultFilter);
                int rc = fc.showDialog(null, mxResources.get("openFile"));
                if (rc == 0) {
                    this.lastDir = fc.getSelectedFile().getParent();
                    try {
                        if (fc.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".png")) {
                            this.openXmlPng(editor, fc.getSelectedFile());
                        } else if (fc.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".txt")) {
                            this.openGD(editor, fc.getSelectedFile(), mxUtils.readFile(fc.getSelectedFile().getAbsolutePath()));
                        } else {
                            Document document = mxXmlUtils.parseXml(mxUtils.readFile(fc.getSelectedFile().getAbsolutePath()));
                            mxCodec codec = new mxCodec(document);
                            codec.decode(document.getDocumentElement(), graph.getModel());
                            editor.setCurrentFile(fc.getSelectedFile());
                            this.resetEditor(editor);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(editor.getGraphComponent(), ex.toString(), mxResources.get("error"), 0);
                    }
                }
            }
        }
    }

    public static class ImportAction
    extends AbstractAction {
        protected String lastDir;

        public static String addStencilShape(EditorPalette palette, String nodeXml, String path) {
            int lessthanIndex = nodeXml.indexOf("<");
            nodeXml = nodeXml.substring(lessthanIndex);
            mxStencilShape newShape = new mxStencilShape(nodeXml);
            String name = newShape.getName();
            ImageIcon icon = null;
            if (path != null) {
                String iconPath = path + newShape.getIconPath();
                icon = new ImageIcon(iconPath);
            }
            mxGraphics2DCanvas.putShape(name, newShape);
            if (palette != null && icon != null) {
                palette.addTemplate(name, icon, "shape=" + name, 80, 80, "");
            }
            return name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicGraphEditor editor = EditorActions.getEditor(e);
            if (editor != null) {
                String wd = this.lastDir != null ? this.lastDir : System.getProperty("user.dir");
                JFileChooser fc = new JFileChooser(wd);
                fc.setFileSelectionMode(2);
                fc.addChoosableFileFilter(new DefaultFileFilter(".shape", "Dia Shape " + mxResources.get("file") + " (.shape)"));
                int rc = fc.showDialog(null, mxResources.get("importStencil"));
                if (rc == 0) {
                    this.lastDir = fc.getSelectedFile().getParent();
                    try {
                        if (fc.getSelectedFile().isDirectory()) {
                            EditorPalette palette = editor.insertPalette(fc.getSelectedFile().getName());
                            for (File f : fc.getSelectedFile().listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File dir, String name) {
                                    return name.toLowerCase().endsWith(".shape");
                                }
                            })) {
                                String nodeXml = mxUtils.readFile(f.getAbsolutePath());
                                ImportAction.addStencilShape(palette, nodeXml, f.getParent() + File.separator);
                            }
                            JComponent scrollPane = (JComponent)palette.getParent().getParent();
                            editor.getLibraryPane().setSelectedComponent(scrollPane);
                        } else {
                            String nodeXml = mxUtils.readFile(fc.getSelectedFile().getAbsolutePath());
                            String name = ImportAction.addStencilShape(null, nodeXml, null);
                            JOptionPane.showMessageDialog(editor, mxResources.get("stencilImported", new String[]{name}));
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    public static class NewAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            BasicGraphEditor editor = EditorActions.getEditor(e);
            if (!(editor == null || editor.isModified() && JOptionPane.showConfirmDialog(editor, mxResources.get("loseChanges")) != 0)) {
                mxGraph graph = editor.getGraphComponent().getGraph();
                mxCell root = new mxCell();
                root.insert(new mxCell());
                graph.getModel().setRoot(root);
                editor.setModified(false);
                editor.setCurrentFile(null);
                editor.getGraphComponent().zoomAndCenter();
            }
        }
    }

    public static class WarningAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                Object[] cells = graphComponent.getGraph().getSelectionCells();
                if (cells != null && cells.length > 0) {
                    String warning = JOptionPane.showInputDialog(mxResources.get("enterWarningMessage"));
                    for (int i = 0; i < cells.length; ++i) {
                        graphComponent.setCellWarning(cells[i], warning);
                    }
                } else {
                    JOptionPane.showMessageDialog(graphComponent, mxResources.get("noCellSelected"));
                }
            }
        }
    }

    public static class FontStyleAction
    extends AbstractAction {
        protected boolean bold;

        public FontStyleAction(boolean bold) {
            this.bold = bold;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                Component editorComponent = null;
                if (graphComponent.getCellEditor() instanceof mxCellEditor) {
                    editorComponent = ((mxCellEditor)graphComponent.getCellEditor()).getEditor();
                }
                if (editorComponent instanceof JEditorPane) {
                    JEditorPane editorPane = (JEditorPane)editorComponent;
                    int start = editorPane.getSelectionStart();
                    int ende = editorPane.getSelectionEnd();
                    String text = editorPane.getSelectedText();
                    if (text == null) {
                        text = "";
                    }
                    try {
                        HTMLEditorKit editorKit = new HTMLEditorKit();
                        HTMLDocument document = (HTMLDocument)editorPane.getDocument();
                        document.remove(start, ende - start);
                        editorKit.insertHTML(document, start, (this.bold ? "<b>" : "<i>") + text + (this.bold ? "</b>" : "</i>"), 0, 0, this.bold ? HTML.Tag.B : HTML.Tag.I);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    editorPane.requestFocus();
                    editorPane.select(start, ende);
                } else {
                    mxIGraphModel model = graphComponent.getGraph().getModel();
                    model.beginUpdate();
                    try {
                        graphComponent.stopEditing(false);
                        graphComponent.getGraph().toggleCellStyleFlags(mxConstants.STYLE_FONTSTYLE, this.bold ? 1 : 2);
                    }
                    finally {
                        model.endUpdate();
                    }
                }
            }
        }
    }

    public static class HistoryAction
    extends AbstractAction {
        protected boolean undo;

        public HistoryAction(boolean undo) {
            this.undo = undo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicGraphEditor editor = EditorActions.getEditor(e);
            if (editor != null) {
                if (this.undo) {
                    editor.getUndoManager().undo();
                } else {
                    editor.getUndoManager().redo();
                }
            }
        }
    }

    public static class TogglePropertyItem
    extends JCheckBoxMenuItem {
        public TogglePropertyItem(Object target, String name, String fieldname) {
            this(target, name, fieldname, false);
        }

        public TogglePropertyItem(Object target, String name, String fieldname, boolean refresh) {
            this(target, name, fieldname, refresh, null);
        }

        public TogglePropertyItem(final Object target, String name, final String fieldname, final boolean refresh, ActionListener listener) {
            super(name);
            if (listener != null) {
                this.addActionListener(listener);
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.execute(target, fieldname, refresh);
                }
            });
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equalsIgnoreCase(fieldname)) {
                        this.update(target, fieldname);
                    }
                }
            };
            if (target instanceof mxGraphComponent) {
                ((mxGraphComponent)target).addPropertyChangeListener(propertyChangeListener);
            } else if (target instanceof mxGraph) {
                ((mxGraph)target).addPropertyChangeListener(propertyChangeListener);
            }
            this.update(target, fieldname);
        }

        public void update(Object target, String fieldname) {
            if (target != null && fieldname != null) {
                try {
                    Object current;
                    Method getter = target.getClass().getMethod("is" + fieldname, new Class[0]);
                    if (getter != null && (current = getter.invoke(target, new Object[0])) instanceof Boolean) {
                        this.setSelected((Boolean)current);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void execute(Object target, String fieldname, boolean refresh) {
            if (target != null && fieldname != null) {
                try {
                    Method getter = target.getClass().getMethod("is" + fieldname, new Class[0]);
                    Method setter = target.getClass().getMethod("set" + fieldname, Boolean.TYPE);
                    Object current = getter.invoke(target, new Object[0]);
                    if (current instanceof Boolean) {
                        boolean value = (Boolean)current == false;
                        setter.invoke(target, value);
                        this.setSelected(value);
                    }
                    if (refresh) {
                        mxGraph graph = null;
                        if (target instanceof mxGraph) {
                            graph = (mxGraph)target;
                        } else if (target instanceof mxGraphComponent) {
                            graph = ((mxGraphComponent)target).getGraph();
                        }
                        graph.refresh();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class PromptPropertyAction
    extends AbstractAction {
        protected Object target;
        protected String fieldname;
        protected String message;

        public PromptPropertyAction(Object target, String message) {
            this(target, message, message);
        }

        public PromptPropertyAction(Object target, String message, String fieldname) {
            this.target = target;
            this.message = message;
            this.fieldname = fieldname;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof Component) {
                try {
                    Method getter = this.target.getClass().getMethod("get" + this.fieldname, new Class[0]);
                    Object current = getter.invoke(this.target, new Object[0]);
                    if (current instanceof Integer) {
                        Method setter = this.target.getClass().getMethod("set" + this.fieldname, Integer.TYPE);
                        String value = (String)JOptionPane.showInputDialog((Component)e.getSource(), "Value", this.message, -1, null, null, current);
                        if (value != null) {
                            setter.invoke(this.target, Integer.parseInt(value));
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                graphComponent.repaint();
            }
        }
    }

    public static class ToggleCreateTargetItem
    extends JCheckBoxMenuItem {
        public ToggleCreateTargetItem(final BasicGraphEditor editor, String name) {
            super(name);
            this.setSelected(true);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mxGraphComponent graphComponent = editor.getGraphComponent();
                    if (graphComponent != null) {
                        mxConnectionHandler handler;
                        handler.setCreateTarget(!(handler = graphComponent.getConnectionHandler()).isCreateTarget());
                        this.setSelected(handler.isCreateTarget());
                    }
                }
            });
        }
    }

    public static class ToggleConnectModeAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxConnectionHandler handler;
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                handler.setHandleEnabled(!(handler = graphComponent.getConnectionHandler()).isHandleEnabled());
            }
        }
    }

    public static class ToggleDirtyAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                graphComponent.showDirtyRectangle = !graphComponent.showDirtyRectangle;
            }
        }
    }

    public static class SelectSpanningTreeAction
    extends AbstractAction {
        protected boolean directed;

        public SelectSpanningTreeAction(boolean directed) {
            this.directed = directed;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                mxGraph graph = graphComponent.getGraph();
                mxIGraphModel model = graph.getModel();
                Object parent = graph.getDefaultParent();
                Object[] cells = graph.getSelectionCells();
                for (int i = 0; i < cells.length; ++i) {
                    if (model.getChildCount(cells[i]) <= 0) continue;
                    parent = cells[i];
                    break;
                }
                Object[] v = graph.getChildVertices(parent);
                Object[] mst = mxGraphAnalysis.getInstance().getMinimumSpanningTree(graph, v, new mxDistanceCostFunction(), this.directed);
                graph.setSelectionCells(mst);
            }
        }
    }

    public static class SelectShortestPathAction
    extends AbstractAction {
        protected boolean directed;

        public SelectShortestPathAction(boolean directed) {
            this.directed = directed;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                mxGraph graph = graphComponent.getGraph();
                mxIGraphModel model = graph.getModel();
                Object source = null;
                Object target = null;
                Object[] cells = graph.getSelectionCells();
                for (int i = 0; i < cells.length; ++i) {
                    if (model.isVertex(cells[i])) {
                        if (source == null) {
                            source = cells[i];
                        } else if (target == null) {
                            target = cells[i];
                        }
                    }
                    if (source != null && target != null) break;
                }
                if (source != null && target != null) {
                    int steps = graph.getChildEdges(graph.getDefaultParent()).length;
                    Object[] path = mxGraphAnalysis.getInstance().getShortestPath(graph, source, target, new mxDistanceCostFunction(), steps, this.directed);
                    graph.setSelectionCells(path);
                } else {
                    JOptionPane.showMessageDialog(graphComponent, mxResources.get("noSourceAndTargetSelected"));
                }
            }
        }
    }

    public static class SaveAction
    extends AbstractAction {
        protected boolean showDialog;
        protected String lastDir = null;

        public SaveAction(boolean showDialog) {
            this.showDialog = showDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveXmlPng(BasicGraphEditor editor, String filename, Color bg) throws IOException {
            mxGraphComponent graphComponent = editor.getGraphComponent();
            mxGraph graph = graphComponent.getGraph();
            BufferedImage image = mxCellRenderer.createBufferedImage(graph, null, 1.0, bg, graphComponent.isAntiAlias(), null, graphComponent.getCanvas());
            mxCodec codec = new mxCodec();
            String xml = URLEncoder.encode(mxXmlUtils.getXml(codec.encode(graph.getModel())), "UTF-8");
            mxPngEncodeParam param = mxPngEncodeParam.getDefaultEncodeParam(image);
            param.setCompressedText(new String[]{"mxGraphModel", xml});
            try (FileOutputStream outputStream = new FileOutputStream(new File(filename));){
                mxPngImageEncoder encoder = new mxPngImageEncoder(outputStream, param);
                if (image != null) {
                    encoder.encode(image);
                    editor.setModified(false);
                    editor.setCurrentFile(new File(filename));
                } else {
                    JOptionPane.showMessageDialog(graphComponent, mxResources.get("noImageData"));
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicGraphEditor editor = EditorActions.getEditor(e);
            if (editor != null) {
                mxGraphComponent graphComponent = editor.getGraphComponent();
                mxGraph graph = graphComponent.getGraph();
                FileFilter selectedFilter = null;
                DefaultFileFilter xmlPngFilter = new DefaultFileFilter(".png", "PNG+XML " + mxResources.get("file") + " (.png)");
                DefaultFileFilter vmlFileFilter = new DefaultFileFilter(".html", "VML " + mxResources.get("file") + " (.html)");
                String filename = null;
                boolean dialogShown = false;
                if (this.showDialog || editor.getCurrentFile() == null) {
                    String ext;
                    int i;
                    String wd = this.lastDir != null ? this.lastDir : (editor.getCurrentFile() != null ? editor.getCurrentFile().getParent() : System.getProperty("user.dir"));
                    JFileChooser fc = new JFileChooser(wd);
                    DefaultFileFilter defaultFilter = xmlPngFilter;
                    fc.addChoosableFileFilter(defaultFilter);
                    fc.addChoosableFileFilter(new DefaultFileFilter(".mxe", "mxGraph Editor " + mxResources.get("file") + " (.mxe)"));
                    fc.addChoosableFileFilter(new DefaultFileFilter(".txt", "Graph Drawing " + mxResources.get("file") + " (.txt)"));
                    fc.addChoosableFileFilter(new DefaultFileFilter(".svg", "SVG " + mxResources.get("file") + " (.svg)"));
                    fc.addChoosableFileFilter(vmlFileFilter);
                    fc.addChoosableFileFilter(new DefaultFileFilter(".html", "HTML " + mxResources.get("file") + " (.html)"));
                    Object[] imageFormats = ImageIO.getReaderFormatNames();
                    HashSet<String> formats = new HashSet<String>();
                    for (i = 0; i < imageFormats.length; ++i) {
                        ext = imageFormats[i].toString().toLowerCase();
                        formats.add(ext);
                    }
                    imageFormats = formats.toArray();
                    for (i = 0; i < imageFormats.length; ++i) {
                        ext = imageFormats[i].toString();
                        fc.addChoosableFileFilter(new DefaultFileFilter("." + ext, ext.toUpperCase() + " " + mxResources.get("file") + " (." + ext + ")"));
                    }
                    fc.addChoosableFileFilter(new DefaultFileFilter.ImageFileFilter(mxResources.get("allImages")));
                    fc.setFileFilter(defaultFilter);
                    int rc = fc.showDialog(null, mxResources.get("save"));
                    dialogShown = true;
                    if (rc != 0) {
                        return;
                    }
                    this.lastDir = fc.getSelectedFile().getParent();
                    filename = fc.getSelectedFile().getAbsolutePath();
                    selectedFilter = fc.getFileFilter();
                    if (selectedFilter instanceof DefaultFileFilter) {
                        ext = ((DefaultFileFilter)selectedFilter).getExtension();
                        if (!filename.toLowerCase().endsWith(ext)) {
                            filename = filename + ext;
                        }
                    }
                    if (new File(filename).exists() && JOptionPane.showConfirmDialog(graphComponent, mxResources.get("overwriteExistingFile")) != 0) {
                        return;
                    }
                } else {
                    filename = editor.getCurrentFile().getAbsolutePath();
                }
                try {
                    String ext = filename.substring(filename.lastIndexOf(46) + 1);
                    if (ext.equalsIgnoreCase("svg")) {
                        mxSvgCanvas canvas = (mxSvgCanvas)mxCellRenderer.drawCells(graph, null, 1.0, null, new mxCellRenderer.CanvasFactory(){

                            @Override
                            public mxICanvas createCanvas(int width, int height) {
                                mxSvgCanvas canvas = new mxSvgCanvas(mxDomUtils.createSvgDocument(width, height));
                                canvas.setEmbedded(true);
                                return canvas;
                            }
                        });
                        mxUtils.writeFile(mxXmlUtils.getXml(canvas.getDocument()), filename);
                    } else if (selectedFilter == vmlFileFilter) {
                        mxUtils.writeFile(mxXmlUtils.getXml(mxCellRenderer.createVmlDocument(graph, null, 1.0, null, null).getDocumentElement()), filename);
                    } else if (ext.equalsIgnoreCase("html")) {
                        mxUtils.writeFile(mxXmlUtils.getXml(mxCellRenderer.createHtmlDocument(graph, null, 1.0, null, null).getDocumentElement()), filename);
                    } else if (ext.equalsIgnoreCase("mxe") || ext.equalsIgnoreCase("xml")) {
                        mxCodec codec = new mxCodec();
                        String xml = mxXmlUtils.getXml(codec.encode(graph.getModel()));
                        mxUtils.writeFile(xml, filename);
                        editor.setModified(false);
                        editor.setCurrentFile(new File(filename));
                    } else if (ext.equalsIgnoreCase("txt")) {
                        String content = mxGdCodec.encode(graph);
                        mxUtils.writeFile(content, filename);
                    } else {
                        Color bg = null;
                        if (!ext.equalsIgnoreCase("gif") && !ext.equalsIgnoreCase("png") || JOptionPane.showConfirmDialog(graphComponent, mxResources.get("transparentBackground")) != 0) {
                            bg = graphComponent.getBackground();
                        }
                        if (selectedFilter == xmlPngFilter || editor.getCurrentFile() != null && ext.equalsIgnoreCase("png") && !dialogShown) {
                            this.saveXmlPng(editor, filename, bg);
                        } else {
                            BufferedImage image = mxCellRenderer.createBufferedImage(graph, null, 1.0, bg, graphComponent.isAntiAlias(), null, graphComponent.getCanvas());
                            if (image != null) {
                                ImageIO.write((RenderedImage)image, ext, new File(filename));
                            } else {
                                JOptionPane.showMessageDialog(graphComponent, mxResources.get("noImageData"));
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(graphComponent, ex.toString(), mxResources.get("error"), 0);
                }
            }
        }
    }

    public static class PrintAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                PrinterJob pj = PrinterJob.getPrinterJob();
                if (pj.printDialog()) {
                    PageFormat pf = graphComponent.getPageFormat();
                    Paper paper = new Paper();
                    double margin = 36.0;
                    paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
                    pf.setPaper(paper);
                    pj.setPrintable(graphComponent, pf);
                    try {
                        pj.print();
                    }
                    catch (PrinterException e2) {
                        System.out.println(e2);
                    }
                }
            }
        }
    }

    public static class PageSetupAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                PrinterJob pj = PrinterJob.getPrinterJob();
                PageFormat format = pj.pageDialog(graphComponent.getPageFormat());
                if (format != null) {
                    graphComponent.setPageFormat(format);
                    graphComponent.zoomAndCenter();
                }
            }
        }
    }

    public static class ScaleAction
    extends AbstractAction {
        protected double scale;

        public ScaleAction(double scale) {
            this.scale = scale;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                String value;
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                double scale = this.scale;
                if (scale == 0.0 && (value = (String)JOptionPane.showInputDialog(graphComponent, mxResources.get("value"), mxResources.get("scale") + " (%)", -1, null, null, "")) != null) {
                    scale = Double.parseDouble(value.replace("%", "")) / 100.0;
                }
                if (scale > 0.0) {
                    graphComponent.zoomTo(scale, graphComponent.isCenterZoom());
                }
            }
        }
    }

    public static class GridColorAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraphComponent graphComponent;
            Color newColor;
            if (e.getSource() instanceof mxGraphComponent && (newColor = JColorChooser.showDialog(graphComponent = (mxGraphComponent)e.getSource(), mxResources.get("gridColor"), graphComponent.getGridColor())) != null) {
                graphComponent.setGridColor(newColor);
                graphComponent.repaint();
            }
        }
    }

    public static class GridStyleAction
    extends AbstractAction {
        protected int style;

        public GridStyleAction(int style) {
            this.style = style;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                graphComponent.setGridStyle(this.style);
                graphComponent.repaint();
            }
        }
    }

    public static class ZoomPolicyAction
    extends AbstractAction {
        protected int zoomPolicy;

        public ZoomPolicyAction(int zoomPolicy) {
            this.zoomPolicy = zoomPolicy;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                graphComponent.setPageVisible(true);
                graphComponent.setZoomPolicy(this.zoomPolicy);
            }
        }
    }

    public static class StylesheetAction
    extends AbstractAction {
        protected String stylesheet;

        public StylesheetAction(String stylesheet) {
            this.stylesheet = stylesheet;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                mxGraph graph = graphComponent.getGraph();
                mxCodec codec = new mxCodec();
                Document doc = mxUtils.loadDocument(EditorActions.class.getResource(this.stylesheet).toString());
                if (doc != null) {
                    codec.decode(doc.getDocumentElement(), graph.getStylesheet());
                    graph.refresh();
                }
            }
        }
    }

    public static class ExitAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            BasicGraphEditor editor = EditorActions.getEditor(e);
            if (editor != null) {
                editor.exit();
            }
        }
    }

    public static class ToggleOutlineItem
    extends JCheckBoxMenuItem {
        public ToggleOutlineItem(final BasicGraphEditor editor, String name) {
            super(name);
            this.setSelected(true);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mxGraphOutline outline;
                    outline.setVisible(!(outline = editor.getGraphOutline()).isVisible());
                    outline.revalidate();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (outline.getParent() instanceof JSplitPane) {
                                if (outline.isVisible()) {
                                    ((JSplitPane)outline.getParent()).setDividerLocation(editor.getHeight() - 300);
                                    ((JSplitPane)outline.getParent()).setDividerSize(6);
                                } else {
                                    ((JSplitPane)outline.getParent()).setDividerSize(0);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    public static class ToggleGridItem
    extends JCheckBoxMenuItem {
        public ToggleGridItem(final BasicGraphEditor editor, String name) {
            super(name);
            this.setSelected(true);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mxGraphComponent graphComponent = editor.getGraphComponent();
                    mxGraph graph = graphComponent.getGraph();
                    boolean enabled = !graph.isGridEnabled();
                    graph.setGridEnabled(enabled);
                    graphComponent.setGridVisible(enabled);
                    graphComponent.repaint();
                    this.setSelected(enabled);
                }
            });
        }
    }

    public static class ToggleRulersItem
    extends JCheckBoxMenuItem {
        public ToggleRulersItem(final BasicGraphEditor editor, String name) {
            super(name);
            this.setSelected(editor.getGraphComponent().getColumnHeader() != null);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mxGraphComponent graphComponent = editor.getGraphComponent();
                    if (graphComponent.getColumnHeader() != null) {
                        graphComponent.setColumnHeader(null);
                        graphComponent.setRowHeader(null);
                    } else {
                        graphComponent.setColumnHeaderView(new EditorRuler(graphComponent, EditorRuler.ORIENTATION_HORIZONTAL));
                        graphComponent.setRowHeaderView(new EditorRuler(graphComponent, EditorRuler.ORIENTATION_VERTICAL));
                    }
                }
            });
        }
    }
}

