/*
 * Decompiled with CFR 0.152.
 */
package visad.sounder;

import java.rmi.RemoteException;
import visad.Set;
import visad.VisADError;
import visad.VisADException;
import visad.sounder.SounderInstrument;
import visad.sounder.Sounding;
import visad.sounder.Spectrum;

public class NastiInstrument
extends SounderInstrument {
    static double[][] pressures = new double[][]{{50.0, 60.0, 70.0, 75.0, 80.0, 85.0, 90.0, 100.0, 125.0, 150.0, 175.0, 200.0, 250.0, 300.0, 350.0, 400.0, 450.0, 500.0, 550.0, 600.0, 620.0, 640.0, 660.0, 680.0, 700.0, 720.0, 740.0, 760.0, 780.0, 800.0, 820.0, 840.0, 860.0, 880.0, 900.0, 920.0, 940.0, 960.0, 980.0, 1000.0}};
    static float[] wavelengths = new float[9127];
    static String[] scalar_names;
    static String[] default_units;
    static double[] default_model_parms;

    public NastiInstrument() throws VisADException, RemoteException {
        super(scalar_names, default_units, default_model_parms);
    }

    public NastiInstrument(double[] model_parms) throws VisADException, RemoteException {
        super(scalar_names, default_units, model_parms);
    }

    @Override
    float[][] computeRetrieval(float[][] radiances, double[][] model_parms) {
        return null;
    }

    @Override
    float[][] computeFoward(float[][] rtvl, double[][] model_parms) {
        return null;
    }

    @Override
    Sounding makeSounding() throws VisADException, RemoteException {
        return new Sounding(Set.doubleToFloat(pressures)[0], null, null);
    }

    @Override
    Sounding makeSounding(Sounding sounding) {
        try {
            return (Sounding)sounding.resample(this.makeSounding().getDomainSet());
        }
        catch (VisADException e) {
            throw new VisADError(e.getMessage());
        }
        catch (RemoteException e) {
            throw new VisADError(e.getMessage());
        }
    }

    @Override
    Spectrum makeSpectrum() throws VisADException, RemoteException {
        return new Spectrum(wavelengths, null, null, null);
    }

    public void setGamma_t(double gamma_t) {
        this.model_parms[0][0] = gamma_t;
    }

    public void setGamma_w(double gamma_w) {
        this.model_parms[0][1] = gamma_w;
    }

    public void setEmissivity(double emiss) {
        this.model_parms[0][2] = emiss;
    }

    private native void nastirte_c(float var1, float var2, int var3, float var4, float[] var5, float[] var6, float[] var7, float[] var8, int[] var9, double[] var10, double[] var11, double[] var12);

    private native void nasti_retrvl_c(int var1, int var2, int var3, float var4, float var5, float var6, float var7, float[] var8, float[] var9, float[] var10);

    static {
        for (int i = 0; i < wavelengths.length; ++i) {
            NastiInstrument.wavelengths[i] = i;
        }
        scalar_names = new String[]{"gamma_t", "gamma_w", "emissivity"};
        default_units = new String[3];
        default_model_parms = new double[3];
    }
}

