/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import visad.Control;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayRealType;
import visad.Field;
import visad.FlowControl;
import visad.FlowInfo;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.MathType;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.ShadowFunctionOrSetType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowSetType;
import visad.ShadowType;
import visad.TrajectoryManager;
import visad.TrajectoryParams;
import visad.UnimplementedException;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADQuadArray;
import visad.java3d.AVControlJ3D;
import visad.java3d.AnimationControlJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.FixGeomSizeAppearanceJ3D;
import visad.java3d.ProjectionControlJ3D;
import visad.java3d.ShadowFunctionTypeJ3D;
import visad.java3d.ShadowRealTupleTypeJ3D;
import visad.java3d.ShadowTextTypeJ3D;
import visad.java3d.ShadowTupleTypeJ3D;
import visad.java3d.ShadowTypeJ3D;
import visad.java3d.TrajectoryAVHandlerJ3D;
import visad.java3d.VisADImageTile;
import visad.util.ThreadManager;

public class ShadowFunctionOrSetTypeJ3D
extends ShadowTypeJ3D {
    ShadowRealTupleTypeJ3D Domain;
    ShadowTypeJ3D Range;
    private Vector AccumulationVector = new Vector();
    boolean post = false;
    boolean doTrajectory = false;
    boolean isAnimation1d = false;
    int domainLength = 0;
    Set anim1DdomainSet;
    Set domainSet;
    double trajVisibilityTimeWindow;
    FlowControl flowCntrl = null;
    ScalarMap flowMap = null;
    TrajectoryParams trajParams;
    ScalarMap altitudeToDisplayZ;
    List<BranchGroup> branches = null;
    Switch swit = null;
    Switch switB = null;
    TrajectoryAVHandlerJ3D avHandler = null;
    private static float EPS = 0.0f;

    public ShadowFunctionOrSetTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
        if (this instanceof ShadowFunctionTypeJ3D) {
            this.Domain = (ShadowRealTupleTypeJ3D)((FunctionType)this.Type).getDomain().buildShadowType(link, this);
            this.Range = (ShadowTypeJ3D)((FunctionType)this.Type).getRange().buildShadowType(link, this);
            this.adaptedShadowType = new ShadowFunctionType(t, link, ShadowFunctionOrSetTypeJ3D.getAdaptedParent(parent), (ShadowRealTupleType)this.Domain.getAdaptedShadowType(), this.Range.getAdaptedShadowType());
        } else {
            this.Domain = (ShadowRealTupleTypeJ3D)((SetType)this.Type).getDomain().buildShadowType(this.Link, this);
            this.Range = null;
            this.adaptedShadowType = new ShadowSetType(t, link, ShadowFunctionOrSetTypeJ3D.getAdaptedParent(parent), (ShadowRealTupleType)this.Domain.getAdaptedShadowType());
        }
    }

    public ShadowRealTupleTypeJ3D getDomain() {
        return this.Domain;
    }

    public ShadowTypeJ3D getRange() {
        return this.Range;
    }

    @Override
    public void preProcess() throws VisADException {
        this.AccumulationVector.removeAllElements();
        if (this instanceof ShadowFunctionTypeJ3D) {
            this.Range.preProcess();
        }
    }

    @Override
    public boolean doTransform(Object group, Data data, final float[] value_array, final float[] default_values, final DataRenderer renderer) throws VisADException, RemoteException {
        boolean isTerminal = this.adaptedShadowType.getIsTerminal();
        ScalarMap timeMap = null;
        DataDisplayLink[] link_s = renderer.getLinks();
        DataDisplayLink link = link_s[0];
        Vector scalarMaps = link.getSelectedMapVector();
        if (!isTerminal && !scalarMaps.isEmpty()) {
            MathType mtype = data.getType();
            if (mtype instanceof FunctionType) {
                int ani_map_idx = 0;
                FunctionType function = (FunctionType)mtype;
                RealTupleType functionD = function.getDomain();
                for (int kk = 0; kk < scalarMaps.size(); ++kk) {
                    ScalarMap scalarMap = (ScalarMap)scalarMaps.elementAt(kk);
                    String scalar_name = scalarMap.getScalarName();
                    if (!scalar_name.equals(((RealType)functionD.getComponent(0)).getName()) || !scalarMap.getDisplayScalar().equals(Display.Animation) || functionD.getDimension() != 1) continue;
                    this.isAnimation1d = true;
                    ani_map_idx = kk;
                }
                timeMap = (ScalarMap)scalarMaps.elementAt(ani_map_idx);
            }
            for (int kk = 0; kk < scalarMaps.size(); ++kk) {
                DisplayRealType dspType;
                ScalarMap scalarMap = (ScalarMap)scalarMaps.elementAt(kk);
                if (scalarMap.getScalarName().equals(RealType.Altitude.getName())) {
                    dspType = scalarMap.getDisplayScalar();
                    RealType[] rtypes = dspType.getTuple().getCoordinateSystem().getReference().getRealComponents();
                    for (int t = 0; t < rtypes.length; ++t) {
                        if (!rtypes[t].equals(Display.ZAxis)) continue;
                        this.altitudeToDisplayZ = scalarMap;
                    }
                }
                dspType = scalarMap.getDisplayScalar();
                boolean isFlow = false;
                if (dspType.equals(Display.Flow1X) || dspType.equals(Display.Flow1Y) || dspType.equals(Display.Flow1Z)) {
                    isFlow = true;
                } else if (dspType.equals(Display.Flow2X) || dspType.equals(Display.Flow2Y) || dspType.equals(Display.Flow2Z)) {
                    isFlow = true;
                }
                if (!isFlow) continue;
                this.flowCntrl = (FlowControl)scalarMap.getControl();
                this.flowMap = scalarMap;
                if (this.flowCntrl.trajectoryEnabled()) {
                    this.doTrajectory = true;
                    this.trajParams = this.flowCntrl.getTrajectoryParams();
                    this.trajVisibilityTimeWindow = this.trajParams.getTrajVisibilityTimeWindow();
                    break;
                }
                this.doTrajectory = false;
            }
        }
        if (this.isAnimation1d) {
            this.anim1DdomainSet = this.domainSet = ((Field)data).getDomainSet();
            this.domainLength = this.domainSet.getLength();
            this.swit = (Switch)this.makeSwitch(this.domainLength);
            AnimationControlJ3D control = (AnimationControlJ3D)timeMap.getControl();
            if (!this.doTrajectory) {
                this.addSwitch(group, this.swit, control, this.domainSet, renderer);
            } else {
                double[] times = TrajectoryManager.getTimes((Gridded1DSet)this.anim1DdomainSet);
                Arrays.sort(times);
                int len = times.length;
                double avgTimeStep = (times[len - 1] - times[0]) / (double)(len - 1);
                int numNodes = (int)(this.trajVisibilityTimeWindow / avgTimeStep);
                int[] whichVisible = new int[numNodes];
                for (int i = 0; i < numNodes; ++i) {
                    whichVisible[i] = -(numNodes - 1 - i);
                }
                this.avHandler = new TrajectoryAVHandlerJ3D(this.swit, this.domainLength, whichVisible, this.trajParams.getDirection());
                control.addPair(this.swit, this.domainSet, renderer, this.avHandler);
                ((AVControlJ3D)control).init();
                BranchGroup branch = new BranchGroup();
                branch.setCapability(17);
                branch.setCapability(12);
                branch.addChild(this.swit);
                ((Group)group).addChild(branch);
                this.switB = (Switch)this.makeSwitch(this.domainLength);
                this.addSwitch(group, this.switB, control, this.domainSet, renderer);
            }
            this.branches = new ArrayList<BranchGroup>();
            for (int i = 0; i < this.domainLength; ++i) {
                BranchGroup branch = (BranchGroup)this.makeBranch();
                this.branches.add(branch);
            }
            ThreadManager threadManager = new ThreadManager("animation rendering");
            for (int i = 0; i < this.domainLength; ++i) {
                final BranchGroup branch = this.branches.get(i);
                final Data sample = ((Field)data).getSample(i);
                final BranchGroup node = (BranchGroup)this.swit.getChild(i);
                threadManager.addRunnable(new ThreadManager.MyRunnable(){

                    @Override
                    public void run() throws Exception {
                        ShadowFunctionOrSetTypeJ3D.this.recurseRange(branch, sample, value_array, default_values, renderer);
                        if (!ShadowFunctionOrSetTypeJ3D.this.doTrajectory) {
                            node.addChild(branch);
                        }
                    }
                });
            }
            if (this.doTrajectory) {
                this.post = true;
                threadManager.runSequentially();
            } else {
                this.post = false;
                threadManager.runInParallel();
            }
        } else {
            ShadowFunctionOrSetType shadow = (ShadowFunctionOrSetType)this.adaptedShadowType;
            this.post = shadow.doTransform(group, data, value_array, default_values, renderer, this);
        }
        this.ensureNotEmpty(group);
        return this.post;
    }

    @Override
    public int textureWidth(int data_width) {
        int texture_width;
        if (DisplayImplJ3D.TEXTURE_NPOT) {
            return data_width;
        }
        for (texture_width = 1; texture_width < data_width; texture_width *= 2) {
        }
        return texture_width;
    }

    @Override
    public int textureHeight(int data_height) {
        int texture_height;
        if (DisplayImplJ3D.TEXTURE_NPOT) {
            return data_height;
        }
        for (texture_height = 1; texture_height < data_height; texture_height *= 2) {
        }
        return texture_height;
    }

    @Override
    public int textureDepth(int data_depth) {
        int texture_depth;
        if (DisplayImplJ3D.TEXTURE_NPOT) {
            return data_depth;
        }
        for (texture_depth = 1; texture_depth < data_depth; texture_depth *= 2) {
        }
        return texture_depth;
    }

    @Override
    public void adjustZ(float[] coordinates) {
        if (this.display.getDisplayRenderer().getMode2D()) {
            for (int i = 2; i < coordinates.length; i += 3) {
                coordinates[i] = -0.01f;
            }
        }
    }

    public int getImageComponentType(int buffImgType) {
        if (buffImgType == 6) {
            return 2;
        }
        if (buffImgType == 5) {
            return 1;
        }
        if (buffImgType == 10) {
            return 10;
        }
        return 2;
    }

    public int getTextureType(int buffImgType) {
        if (buffImgType == 6) {
            return 6;
        }
        if (buffImgType == 5) {
            return 5;
        }
        if (buffImgType == 10) {
            return 2;
        }
        return 6;
    }

    @Override
    public void setTexCoords(float[] texCoords, float ratiow, float ratioh) {
        this.setTexCoords(texCoords, ratiow, ratioh, false);
    }

    public void setTexCoords(float[] texCoords, float ratiow, float ratioh, boolean yUp) {
        if (!yUp) {
            texCoords[0] = 0.0f;
            texCoords[1] = 1.0f;
            texCoords[2] = ratiow;
            texCoords[3] = 1.0f;
            texCoords[4] = ratiow;
            texCoords[5] = 1.0f - ratioh;
            texCoords[6] = 0.0f;
            texCoords[7] = 1.0f - ratioh;
        } else {
            texCoords[0] = 0.0f;
            texCoords[1] = 0.0f;
            texCoords[2] = 0.0f;
            texCoords[3] = ratioh;
            texCoords[4] = ratiow;
            texCoords[5] = ratioh;
            texCoords[6] = ratiow;
            texCoords[7] = 0.0f;
        }
    }

    @Override
    public float[] setTex3DCoords(int length, int axis, float ratiow, float ratioh, float ratiod) {
        float[] texCoords;
        block4: {
            block5: {
                block3: {
                    texCoords = new float[12 * length];
                    if (axis != 2) break block3;
                    for (int i = 0; i < length; ++i) {
                        int i12 = i * 12;
                        float depth = 0.0f + (ratiod - 0.0f) * (float)i / ((float)length - 1.0f);
                        texCoords[i12] = 0.0f;
                        texCoords[i12 + 1] = 1.0f;
                        texCoords[i12 + 2] = depth;
                        texCoords[i12 + 3] = ratiow;
                        texCoords[i12 + 4] = 1.0f;
                        texCoords[i12 + 5] = depth;
                        texCoords[i12 + 6] = ratiow;
                        texCoords[i12 + 7] = 1.0f - ratioh;
                        texCoords[i12 + 8] = depth;
                        texCoords[i12 + 9] = 0.0f;
                        texCoords[i12 + 10] = 1.0f - ratioh;
                        texCoords[i12 + 11] = depth;
                    }
                    break block4;
                }
                if (axis != 1) break block5;
                for (int i = 0; i < length; ++i) {
                    int i12 = i * 12;
                    float height = 1.0f - ratioh * (float)i / ((float)length - 1.0f);
                    texCoords[i12] = 0.0f;
                    texCoords[i12 + 1] = height;
                    texCoords[i12 + 2] = 0.0f;
                    texCoords[i12 + 3] = ratiow;
                    texCoords[i12 + 4] = height;
                    texCoords[i12 + 5] = 0.0f;
                    texCoords[i12 + 6] = ratiow;
                    texCoords[i12 + 7] = height;
                    texCoords[i12 + 8] = ratiod;
                    texCoords[i12 + 9] = 0.0f;
                    texCoords[i12 + 10] = height;
                    texCoords[i12 + 11] = ratiod;
                }
                break block4;
            }
            if (axis != 0) break block4;
            for (int i = 0; i < length; ++i) {
                float width;
                int i12 = i * 12;
                texCoords[i12] = width = 0.0f + (ratiow - 0.0f) * (float)i / ((float)length - 1.0f);
                texCoords[i12 + 1] = 1.0f;
                texCoords[i12 + 2] = 0.0f;
                texCoords[i12 + 3] = width;
                texCoords[i12 + 4] = 1.0f - ratioh;
                texCoords[i12 + 5] = 0.0f;
                texCoords[i12 + 6] = width;
                texCoords[i12 + 7] = 1.0f - ratioh;
                texCoords[i12 + 8] = ratiod;
                texCoords[i12 + 9] = width;
                texCoords[i12 + 10] = 1.0f;
                texCoords[i12 + 11] = ratiod;
            }
        }
        return texCoords;
    }

    @Override
    public float[] setTexStackCoords(int length, int axis, float ratiow, float ratioh, float ratiod) {
        float[] texCoords;
        block4: {
            block5: {
                block3: {
                    texCoords = new float[8 * length];
                    if (axis != 2) break block3;
                    for (int i = 0; i < length; ++i) {
                        int i8 = i * 8;
                        texCoords[i8] = 0.0f + EPS;
                        texCoords[i8 + 1] = 1.0f - EPS;
                        texCoords[i8 + 2] = ratiow - EPS;
                        texCoords[i8 + 3] = 1.0f - EPS;
                        texCoords[i8 + 4] = ratiow - EPS;
                        texCoords[i8 + 5] = 1.0f - ratioh + EPS;
                        texCoords[i8 + 6] = 0.0f + EPS;
                        texCoords[i8 + 7] = 1.0f - ratioh + EPS;
                    }
                    break block4;
                }
                if (axis != 1) break block5;
                for (int i = 0; i < length; ++i) {
                    int i8 = i * 8;
                    texCoords[i8] = 0.0f + EPS;
                    texCoords[i8 + 1] = 1.0f - EPS;
                    texCoords[i8 + 2] = ratiow - EPS;
                    texCoords[i8 + 3] = 1.0f - EPS;
                    texCoords[i8 + 4] = ratiow - EPS;
                    texCoords[i8 + 5] = 1.0f - ratiod + EPS;
                    texCoords[i8 + 6] = 0.0f + EPS;
                    texCoords[i8 + 7] = 1.0f - ratiod + EPS;
                }
                break block4;
            }
            if (axis != 0) break block4;
            for (int i = 0; i < length; ++i) {
                int i8 = i * 8;
                texCoords[i8] = 0.0f + EPS;
                texCoords[i8 + 1] = 1.0f - EPS;
                texCoords[i8 + 2] = ratioh - EPS;
                texCoords[i8 + 3] = 1.0f - EPS;
                texCoords[i8 + 4] = ratioh - EPS;
                texCoords[i8 + 5] = 1.0f - ratiod + EPS;
                texCoords[i8 + 6] = 0.0f + EPS;
                texCoords[i8 + 7] = 1.0f - ratiod + EPS;
            }
        }
        return texCoords;
    }

    @Override
    public Vector getTextMaps(int i, int[] textIndices) {
        if (i < 0) {
            return ((ShadowTextTypeJ3D)this.Range).getSelectedMapVector();
        }
        ShadowTextTypeJ3D text = (ShadowTextTypeJ3D)((ShadowTupleTypeJ3D)this.Range).getComponent(textIndices[i]);
        return text.getSelectedMapVector();
    }

    public void textureToGroup(Object group, VisADGeometryArray array, BufferedImage image, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, boolean byReference, boolean yUp, VisADImageTile tile) throws VisADException {
        this.textureToGroup(group, array, image, mode, constant_alpha, constant_color, texture_width, texture_height, byReference, yUp, tile, false);
    }

    @Override
    public void textureToGroup(Object group, VisADGeometryArray array, BufferedImage image, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height) throws VisADException {
        this.textureToGroup(group, array, image, mode, constant_alpha, constant_color, texture_width, texture_height, false, false, null, false);
    }

    public void textureToGroup(Object group, VisADGeometryArray array, BufferedImage image, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, boolean byReference, boolean yUp, VisADImageTile tile, boolean smoothen) throws VisADException {
        GeometryArray geometry = this.display.makeGeometry(array);
        TransparencyAttributes c_alpha = null;
        if (constant_alpha == 1.0f) {
            c_alpha = null;
        } else if (constant_alpha == constant_alpha) {
            int image_type = image.getType();
            boolean inversed_alpha = image_type == 5 || image_type == 10;
            c_alpha = new TransparencyAttributes(2, inversed_alpha ? 1.0f - constant_alpha : constant_alpha);
            c_alpha.setCapability(3);
        } else {
            c_alpha = new TransparencyAttributes();
            c_alpha.setTransparencyMode(2);
            c_alpha.setCapability(3);
        }
        ColoringAttributes c_color = null;
        if (constant_color != null && constant_color.length == 3) {
            c_color = new ColoringAttributes();
            c_color.setColor(constant_color[0], constant_color[1], constant_color[2]);
        }
        Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometry, false);
        appearance.setCapability(11);
        TextureAttributes texture_attributes = new TextureAttributes();
        if (smoothen) {
            texture_attributes.setTextureMode(2);
        } else {
            texture_attributes.setTextureMode(5);
        }
        texture_attributes.setPerspectiveCorrectionMode(1);
        appearance.setTextureAttributes(texture_attributes);
        Texture2D texture = new Texture2D(1, this.getTextureType(image.getType()), texture_width, texture_height);
        texture.setCapability(4);
        ImageComponent2D image2d = new ImageComponent2D(this.getImageComponentType(image.getType()), image, byReference, yUp);
        image2d.setCapability(2);
        if (byReference) {
            image2d.setCapability(3);
        }
        texture.setImage(0, image2d);
        if (smoothen) {
            texture.setMinFilter(3);
            texture.setMagFilter(3);
        } else {
            texture.setMinFilter(2);
            texture.setMagFilter(2);
        }
        texture.setEnable(true);
        Shape3D shape = new Shape3D(geometry, appearance);
        shape.setCapability(12);
        shape.setCapability(13);
        shape.setCapability(14);
        appearance.setTexture(texture);
        appearance.setCapability(2);
        appearance.setCapability(3);
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.addChild(shape);
        if (((Group)group).numChildren() > 0) {
            ((Group)group).setChild(branch, 0);
        } else {
            ((Group)group).addChild(branch);
        }
        if (tile != null) {
            tile.setImageComponent(image2d);
        }
    }

    @Override
    public void texture3DToGroup(Object group, VisADGeometryArray arrayX, VisADGeometryArray arrayY, VisADGeometryArray arrayZ, VisADGeometryArray arrayXrev, VisADGeometryArray arrayYrev, VisADGeometryArray arrayZrev, BufferedImage[] images, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, int texture_depth, DataRenderer renderer) throws VisADException {
        GeometryArray geometryX = this.display.makeGeometry(arrayX);
        GeometryArray geometryY = this.display.makeGeometry(arrayY);
        GeometryArray geometryZ = this.display.makeGeometry(arrayZ);
        GeometryArray geometryXrev = this.display.makeGeometry(arrayXrev);
        GeometryArray geometryYrev = this.display.makeGeometry(arrayYrev);
        GeometryArray geometryZrev = this.display.makeGeometry(arrayZrev);
        TransparencyAttributes c_alpha = null;
        if (constant_alpha == 1.0f) {
            c_alpha = null;
        } else if (constant_alpha == constant_alpha) {
            c_alpha = new TransparencyAttributes(2, constant_alpha);
        } else {
            c_alpha = new TransparencyAttributes();
            c_alpha.setTransparencyMode(2);
        }
        ColoringAttributes c_color = null;
        if (constant_color != null && constant_color.length == 3) {
            c_color = new ColoringAttributes();
            c_color.setColor(constant_color[0], constant_color[1], constant_color[2]);
        }
        Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryX, true);
        TextureAttributes texture_attributes = new TextureAttributes();
        texture_attributes.setTextureMode(2);
        texture_attributes.setPerspectiveCorrectionMode(1);
        appearance.setTextureAttributes(texture_attributes);
        Texture3D texture = new Texture3D(1, 6, texture_width, texture_height, texture_depth);
        texture.setCapability(4);
        ImageComponent3D image3d = new ImageComponent3D(2, texture_width, texture_height, texture_depth);
        image3d.setCapability(2);
        for (int i = 0; i < texture_depth; ++i) {
            image3d.set(i, images[i]);
            images[i] = null;
        }
        texture.setImage(0, image3d);
        texture.setMinFilter(3);
        texture.setMagFilter(3);
        texture.setEnable(true);
        Shape3D shapeX = new Shape3D(geometryX, appearance);
        shapeX.setCapability(14);
        Shape3D shapeY = new Shape3D(geometryY, appearance);
        shapeY.setCapability(14);
        Shape3D shapeZ = new Shape3D(geometryZ, appearance);
        shapeZ.setCapability(14);
        Shape3D shapeXrev = new Shape3D(geometryXrev, appearance);
        Shape3D shapeYrev = new Shape3D(geometryYrev, appearance);
        Shape3D shapeZrev = new Shape3D(geometryZrev, appearance);
        appearance.setTexture(texture);
        appearance.setCapability(2);
        shapeX.setCapability(12);
        shapeX.setCapability(14);
        shapeY.setCapability(12);
        shapeY.setCapability(14);
        shapeZ.setCapability(12);
        shapeZ.setCapability(14);
        shapeXrev.setCapability(12);
        shapeXrev.setCapability(14);
        shapeYrev.setCapability(12);
        shapeYrev.setCapability(14);
        shapeZrev.setCapability(12);
        shapeZrev.setCapability(14);
        Switch swit = (Switch)this.makeSwitch();
        swit.addChild(shapeX);
        swit.addChild(shapeY);
        swit.addChild(shapeZ);
        swit.addChild(shapeXrev);
        swit.addChild(shapeYrev);
        swit.addChild(shapeZrev);
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.addChild(swit);
        if (((Group)group).numChildren() > 0) {
            ((Group)group).setChild(branch, 0);
        } else {
            ((Group)group).addChild(branch);
        }
        ProjectionControlJ3D control = (ProjectionControlJ3D)this.display.getProjectionControl();
        control.addPair(swit, renderer);
    }

    @Override
    public void textureStackToGroup(Object group, VisADGeometryArray arrayX, VisADGeometryArray arrayY, VisADGeometryArray arrayZ, VisADGeometryArray arrayXrev, VisADGeometryArray arrayYrev, VisADGeometryArray arrayZrev, BufferedImage[] imagesX, BufferedImage[] imagesY, BufferedImage[] imagesZ, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, int texture_depth, DataRenderer renderer) throws VisADException {
        GeometryArray[] geometryX = this.makeGeometrys(arrayX);
        GeometryArray[] geometryY = this.makeGeometrys(arrayY);
        GeometryArray[] geometryZ = this.makeGeometrys(arrayZ);
        int nx = arrayX.coordinates.length;
        boolean flipX = arrayX.coordinates[0] > arrayX.coordinates[nx - 3];
        int ny = arrayY.coordinates.length;
        boolean flipY = arrayY.coordinates[1] > arrayY.coordinates[ny - 2];
        int nz = arrayZ.coordinates.length;
        boolean flipZ = arrayZ.coordinates[2] > arrayZ.coordinates[nz - 1];
        TransparencyAttributes c_alpha = null;
        if (constant_alpha == 1.0f) {
            c_alpha = null;
        } else if (constant_alpha == constant_alpha) {
            c_alpha = new TransparencyAttributes(2, constant_alpha);
        } else {
            c_alpha = new TransparencyAttributes();
            c_alpha.setTransparencyMode(2);
        }
        ColoringAttributes c_color = null;
        if (constant_color != null && constant_color.length == 3) {
            c_color = new ColoringAttributes();
            c_color.setColor(constant_color[0], constant_color[1], constant_color[2]);
        }
        TextureAttributes texture_attributes = new TextureAttributes();
        texture_attributes.setTextureMode(5);
        texture_attributes.setPerspectiveCorrectionMode(1);
        int transparencyMode = mode.getTransparencyMode();
        OrderedGroup branchX = new OrderedGroup();
        branchX.setCapability(12);
        int data_depth = geometryX.length;
        Shape3D[] shapeX = new Shape3D[data_depth];
        for (int ii = 0; ii < data_depth; ++ii) {
            int i = flipX ? data_depth - 1 - ii : ii;
            int width = imagesX[i].getWidth();
            int height = imagesX[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesX[i]);
            image2d.setCapability(2);
            texture.setImage(0, image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryX[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture(texture);
            appearance.setCapability(2);
            shapeX[i] = new Shape3D(geometryX[i], appearance);
            shapeX[i].setCapability(12);
            shapeX[i].setCapability(14);
            branchX.addChild(shapeX[i]);
        }
        OrderedGroup branchXrev = new OrderedGroup();
        branchXrev.setCapability(12);
        for (int ii = data_depth - 1; ii >= 0; --ii) {
            int i = flipX ? data_depth - 1 - ii : ii;
            int width = imagesX[i].getWidth();
            int height = imagesX[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesX[i]);
            image2d.setCapability(2);
            texture.setImage(0, image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryX[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture(texture);
            appearance.setCapability(2);
            shapeX[i] = new Shape3D(geometryX[i], appearance);
            shapeX[i].setCapability(12);
            shapeX[i].setCapability(14);
            branchXrev.addChild(shapeX[i]);
        }
        shapeX = null;
        OrderedGroup branchY = new OrderedGroup();
        branchY.setCapability(12);
        int data_height = geometryY.length;
        Shape3D[] shapeY = new Shape3D[data_height];
        for (int ii = 0; ii < data_height; ++ii) {
            int i = flipY ? data_height - 1 - ii : ii;
            int width = imagesY[i].getWidth();
            int height = imagesY[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesY[i]);
            image2d.setCapability(2);
            texture.setImage(0, image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryY[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture(texture);
            appearance.setCapability(2);
            shapeY[i] = new Shape3D(geometryY[i], appearance);
            shapeY[i].setCapability(12);
            shapeY[i].setCapability(14);
            branchY.addChild(shapeY[i]);
        }
        OrderedGroup branchYrev = new OrderedGroup();
        branchYrev.setCapability(12);
        for (int ii = data_height - 1; ii >= 0; --ii) {
            int i = flipY ? data_height - 1 - ii : ii;
            int width = imagesY[i].getWidth();
            int height = imagesY[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesY[i]);
            image2d.setCapability(2);
            texture.setImage(0, image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryY[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture(texture);
            appearance.setCapability(2);
            shapeY[i] = new Shape3D(geometryY[i], appearance);
            shapeY[i].setCapability(12);
            shapeY[i].setCapability(14);
            branchYrev.addChild(shapeY[i]);
        }
        shapeY = null;
        OrderedGroup branchZ = new OrderedGroup();
        branchZ.setCapability(12);
        int data_width = geometryZ.length;
        Shape3D[] shapeZ = new Shape3D[data_width];
        for (int ii = 0; ii < data_width; ++ii) {
            int i = flipZ ? data_width - 1 - ii : ii;
            int width = imagesZ[i].getWidth();
            int height = imagesZ[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesZ[i]);
            image2d.setCapability(2);
            texture.setImage(0, image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryZ[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture(texture);
            appearance.setCapability(2);
            shapeZ[i] = new Shape3D(geometryZ[i], appearance);
            shapeZ[i].setCapability(12);
            shapeZ[i].setCapability(14);
            branchZ.addChild(shapeZ[i]);
        }
        OrderedGroup branchZrev = new OrderedGroup();
        branchZrev.setCapability(12);
        for (int ii = data_width - 1; ii >= 0; --ii) {
            int i = flipZ ? data_width - 1 - ii : ii;
            int width = imagesZ[i].getWidth();
            int height = imagesZ[i].getHeight();
            Texture2D texture = new Texture2D(1, 6, width, height);
            texture.setCapability(4);
            ImageComponent2D image2d = new ImageComponent2D(2, imagesZ[i]);
            image2d.setCapability(2);
            texture.setImage(0, image2d);
            Appearance appearance = this.makeAppearance(mode, c_alpha, null, geometryZ[i], true);
            appearance.setTextureAttributes(texture_attributes);
            if (transparencyMode == 0) {
                texture.setMinFilter(2);
                texture.setMagFilter(2);
            } else {
                texture.setBoundaryModeS(2);
                texture.setBoundaryModeT(2);
                texture.setMinFilter(3);
                texture.setMagFilter(3);
            }
            texture.setEnable(true);
            appearance.setTexture(texture);
            appearance.setCapability(2);
            shapeZ[i] = new Shape3D(geometryZ[i], appearance);
            shapeZ[i].setCapability(12);
            shapeZ[i].setCapability(14);
            branchZrev.addChild(shapeZ[i]);
        }
        shapeZ = null;
        Switch swit = (Switch)this.makeSwitch();
        swit.addChild(branchX);
        swit.addChild(branchY);
        swit.addChild(branchZ);
        swit.addChild(branchXrev);
        swit.addChild(branchYrev);
        swit.addChild(branchZrev);
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.addChild(swit);
        if (((Group)group).numChildren() > 0) {
            ((Group)group).setChild(branch, 0);
        } else {
            ((Group)group).addChild(branch);
        }
        ProjectionControlJ3D control = (ProjectionControlJ3D)this.display.getProjectionControl();
        control.addPair(swit, renderer);
    }

    public GeometryArray[] makeGeometrys(VisADGeometryArray array) throws VisADException {
        int count = array.vertexCount;
        int depth = count / 4;
        VisADGeometryArray[] qarrays = this.makeVisADGeometrys(array);
        GeometryArray[] geometrys = new GeometryArray[depth];
        for (int d = 0; d < depth; ++d) {
            geometrys[d] = this.display.makeGeometry(qarrays[d]);
        }
        return geometrys;
    }

    public VisADGeometryArray[] makeVisADGeometrys(VisADGeometryArray array) throws VisADException {
        int count = array.vertexCount;
        int depth = count / 4;
        int color_length = array.colors.length / count;
        int tex_length = array.texCoords.length / count;
        VisADGeometryArray[] geometrys = new VisADGeometryArray[depth];
        for (int d = 0; d < depth; ++d) {
            int i;
            int i12 = d * 4 * 3;
            int i4c = d * 4 * color_length;
            int i4t = d * 4 * tex_length;
            VisADQuadArray qarray = new VisADQuadArray();
            qarray.vertexCount = 4;
            qarray.coordinates = new float[12];
            qarray.texCoords = new float[tex_length * 4];
            qarray.colors = new byte[color_length * 4];
            qarray.normals = new float[12];
            for (i = 0; i < 12; ++i) {
                qarray.coordinates[i] = array.coordinates[i12 + i];
                qarray.normals[i] = array.normals[i12 + i];
            }
            for (i = 0; i < 4 * color_length; ++i) {
                qarray.colors[i] = array.colors[i4c + i];
            }
            for (i = 0; i < 4 * tex_length; ++i) {
                qarray.texCoords[i] = array.texCoords[i4t + i];
            }
            geometrys[d] = qarray;
        }
        return geometrys;
    }

    @Override
    public Object makeSwitch() {
        Switch swit = new Switch(-3);
        swit.setCapability(17);
        swit.setCapability(18);
        swit.setCapability(17);
        swit.setCapability(12);
        swit.setCapability(13);
        return swit;
    }

    public Object makeSwitch(int length) throws VisADException {
        Switch swit = (Switch)this.makeSwitch();
        swit.setCapability(14);
        for (int i = 0; i < length; ++i) {
            BranchGroup node = new BranchGroup();
            node.setCapability(17);
            node.setCapability(14);
            node.setCapability(12);
            node.setCapability(13);
            this.ensureNotEmpty(node);
            this.addToSwitch(swit, node);
        }
        return swit;
    }

    @Override
    public Object makeBranch() {
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        return branch;
    }

    @Override
    public void addToGroup(Object group, Object branch) throws VisADException {
        this.ensureNotEmpty((BranchGroup)branch);
        ((BranchGroup)group).addChild((BranchGroup)branch);
    }

    @Override
    public void addToSwitch(Object swit, Object branch) throws VisADException {
        this.ensureNotEmpty((BranchGroup)branch);
        ((Switch)swit).addChild((BranchGroup)branch);
    }

    @Override
    public void addSwitch(Object group, Object swit, Control control, Set domain_set, DataRenderer renderer) throws VisADException {
        ((AVControlJ3D)control).addPair((Switch)swit, domain_set, renderer);
        ((AVControlJ3D)control).init();
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.addChild((Switch)swit);
        ((Group)group).addChild(branch);
    }

    @Override
    public boolean recurseRange(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        return this.Range.doTransform(group, data, value_array, default_values, renderer);
    }

    @Override
    public boolean wantIndexed() {
        return false;
    }

    public void postProcessTraj() throws VisADException {
        try {
            this.doTrajectory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void postProcess(Object group) throws VisADException {
        if (this.doTrajectory) {
            this.postProcessTraj();
            return;
        }
        if (((ShadowFunctionOrSetType)this.adaptedShadowType).getFlat()) {
            int LevelOfDifficulty = this.getLevelOfDifficulty();
            if (LevelOfDifficulty == 1) {
                throw new UnimplementedException("terminal LEGAL unimplemented: ShadowFunctionOrSetTypeJ3D.postProcess");
            }
        } else if (this instanceof ShadowFunctionTypeJ3D) {
            this.Range.postProcess(group);
        }
        this.AccumulationVector.removeAllElements();
    }

    private void doTrajectory() throws VisADException, RemoteException {
        ArrayList<FlowInfo> flowInfoList = this.Range.getAdaptedShadowType().getFlowInfo();
        int dataDomainLength = this.anim1DdomainSet.getLength();
        boolean trcrEnabled = this.trajParams.getMarkerEnabled();
        int trajForm = this.trajParams.getTrajectoryForm();
        boolean autoSizeTrcr = true;
        float trcrSize = this.trajParams.getMarkerSize();
        double trajRefreshInterval = this.trajParams.getTrajRefreshInterval();
        int direction = this.trajParams.getDirection();
        DataRenderer renderer = this.getLink().getRenderer();
        ProjectionControl pCntrl = renderer.getDisplay().getProjectionControl();
        MouseBehavior mouseBehav = renderer.getDisplay().getMouseBehavior();
        FixGeomSizeAppearanceJ3D listener = null;
        double[] times = TrajectoryManager.getTimes((Gridded1DSet)this.anim1DdomainSet);
        double[] timeSteps = TrajectoryManager.getTimeSteps((Gridded1DSet)this.anim1DdomainSet);
        TrajectoryManager trajMan = new TrajectoryManager(renderer, this.trajParams, flowInfoList, dataDomainLength, times[0], this.altitudeToDisplayZ);
        boolean bl = trcrEnabled = trcrEnabled && trajForm == 0 && trajForm != 4;
        if (autoSizeTrcr && trcrEnabled) {
            listener = new FixGeomSizeAppearanceJ3D(pCntrl, this, mouseBehav);
            trajMan.setListener(pCntrl, listener, this.flowCntrl);
            listener.lock();
        }
        double[] dspScale = TrajectoryManager.getScale(mouseBehav, pCntrl);
        double scale = dspScale[0];
        trajMan.initCleanUp(this.flowMap, this.flowCntrl, pCntrl, this.display);
        double trcrSizeRatio = 1.0;
        double timeAccum = 0.0;
        VisADGeometryArray array = null;
        VisADGeometryArray trcrArray = null;
        VisADGeometryArray[] auxArray = new VisADGeometryArray[1];
        ArrayList<float[]> achrArrays = null;
        for (int k = 0; k < dataDomainLength; ++k) {
            int i = direction < 0 ? dataDomainLength - 1 - k : k;
            FlowInfo info = flowInfoList.get(i);
            array = trajMan.computeTrajectories(k, timeAccum, times, timeSteps, auxArray);
            if (trajMan.getNumberOfTrajectories() > 0) {
                achrArrays = new ArrayList<float[]>();
                trcrArray = trajMan.makeTracerGeometry(achrArrays, direction, trcrSize, dspScale, true);
                trcrArray = TrajectoryManager.scaleGeometry(trcrArray, achrArrays, (float)(1.0 / scale));
            }
            GraphicsModeControl mode = (GraphicsModeControl)info.mode.clone();
            if (k == 0 || timeAccum >= trajRefreshInterval) {
                this.avHandler.setNoneVisibleIndex(i);
                timeAccum = 0.0;
            }
            timeAccum += timeSteps[i];
            if (trcrEnabled) {
                Node group = this.switB.getChild(i);
                BranchGroup trcrBG = this.addToDetachableGroup(group, trcrArray, mode, info.constant_alpha, info.constant_color);
                if (listener != null && trcrArray != null) {
                    listener.add(trcrBG, trcrArray, achrArrays, mode, info.constant_alpha, info.constant_color);
                }
            }
            BranchGroup branch = this.branches.get(i);
            this.addToGroup(branch, array, mode, info.constant_alpha, info.constant_color);
            BranchGroup node = (BranchGroup)this.swit.getChild(i);
            node.addChild(branch);
            if (auxArray[0] == null) continue;
            BranchGroup auxBrnch = (BranchGroup)this.makeBranch();
            this.addToGroup(auxBrnch, auxArray[0], mode, info.constant_alpha, info.constant_color);
            ((BranchGroup)this.switB.getChild(i)).addChild(auxBrnch);
        }
        if (listener != null && listener.isLocked()) {
            listener.update();
            listener.unlock();
        }
    }
}

