/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.awt.geom.AffineTransform;
import java.rmi.RemoteException;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.ProjectionControl;
import visad.VisADException;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.VisADCanvasJ2D;

public class ProjectionControlJ2D
extends ProjectionControl {
    private transient AffineTransform Matrix = this.init();
    private transient VisADCanvasJ2D canvas;

    public ProjectionControlJ2D(DisplayImpl d) throws VisADException {
        super(d);
        this.matrix = new double[6];
        this.Matrix.getMatrix(this.matrix);
        ((DisplayRendererJ2D)this.getDisplayRenderer()).setTransform2D(this.Matrix);
        this.canvas = null;
        this.saveProjection();
    }

    @Override
    public void setMatrix(double[] m) throws VisADException, RemoteException {
        super.setMatrix(m);
        this.Matrix = new AffineTransform(this.matrix);
        DisplayRendererJ2D dr = (DisplayRendererJ2D)this.getDisplayRenderer();
        dr.setTransform2D(this.Matrix);
        if (this.canvas == null) {
            this.canvas = dr.getCanvas();
        }
        this.canvas.scratchImages();
        this.changeControl(false);
    }

    @Override
    public void setAspect(double[] aspect) throws VisADException, RemoteException {
        if (aspect == null || aspect.length != 2) {
            throw new DisplayException("aspect array must be length = 2");
        }
        AffineTransform transform = new AffineTransform();
        transform.setToScale(aspect[0], aspect[1]);
        double[] mult = new double[6];
        transform.getMatrix(mult);
        AffineTransform mat = this.init();
        double[] m = new double[6];
        mat.getMatrix(m);
        this.setMatrix(this.getDisplay().multiply_matrix(mult, m));
        this.saveProjection();
    }

    private AffineTransform init() {
        AffineTransform mat = new AffineTransform();
        AffineTransform t1 = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        mat.concatenate(t1);
        return mat;
    }
}

