/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.IOException;
import visad.RealType;
import visad.ScalarType;
import visad.TextType;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealType;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinaryTextType;

public class BinaryScalarType
implements BinaryObject {
    public static final int computeBytes(ScalarType st) {
        if (st instanceof RealType) {
            return BinaryRealType.computeBytes((RealType)st);
        }
        if (st instanceof TextType) {
            return BinaryTextType.computeBytes((TextType)st);
        }
        return BinarySerializedObject.computeBytes(st);
    }

    public static final int write(BinaryWriter writer, ScalarType st, Object token) throws IOException {
        if (st instanceof RealType) {
            return BinaryRealType.write(writer, (RealType)st, token);
        }
        if (st instanceof TextType) {
            return BinaryTextType.write(writer, (TextType)st, token);
        }
        BinaryObjectCache cache = writer.getTypeCache();
        int index = cache.getIndex(st);
        if (index < 0) {
            index = cache.add(st);
            if (index < 0) {
                throw new IOException("Couldn't cache ScalarType " + st);
            }
            BinarySerializedObject.write(writer, (byte)6, st, token);
        }
        return index;
    }
}

