/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.DataImpl;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.TupleType;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.DataFactory;
import visad.data.netcdf.in.VirtualData;

public class VirtualTuple
extends VirtualData {
    private DataFactory dataFactory = DataFactory.instance();
    private final Vector components;
    private MathType mathType = null;
    private boolean isDirty = true;

    public VirtualTuple() {
        this(0);
    }

    private VirtualTuple(int n) {
        this.components = new Vector(n);
    }

    public VirtualTuple(VirtualData data) {
        this(1);
        this.add(data);
    }

    public VirtualTuple(VirtualData[] datas) {
        this(datas.length);
        for (int i = 0; i < datas.length; ++i) {
            this.add(datas[i]);
        }
    }

    public int size() {
        return this.components.size();
    }

    public synchronized void add(VirtualData data) {
        this.components.add(data);
        this.isDirty = true;
    }

    @Override
    public MathType getType() throws VisADException {
        if (this.isDirty) {
            int componentCount = this.size();
            if (componentCount == 0) {
                this.mathType = null;
            } else if (componentCount == 1) {
                this.mathType = ((VirtualData)this.components.get(0)).getType();
            } else {
                MathType[] types = new MathType[componentCount];
                boolean allRealTypes = true;
                for (int i = 0; i < componentCount; ++i) {
                    types[i] = ((VirtualData)this.components.get(i)).getType();
                    if (types[i] instanceof RealType) continue;
                    allRealTypes = false;
                }
                if (!allRealTypes) {
                    this.mathType = new TupleType(types);
                } else {
                    RealType[] realTypes = new RealType[componentCount];
                    for (int i = 0; i < componentCount; ++i) {
                        realTypes[i] = (RealType)types[i];
                    }
                    this.mathType = new RealTupleType(realTypes);
                }
            }
            this.isDirty = false;
        }
        return this.mathType;
    }

    public VirtualData get(int index) throws ArrayIndexOutOfBoundsException {
        return (VirtualData)this.components.get(index);
    }

    public synchronized void replace(int index, VirtualData data) throws ArrayIndexOutOfBoundsException {
        this.components.set(index, data);
        this.isDirty = true;
    }

    @Override
    public DataImpl getData(Context context) throws VisADException, RemoteException, IOException {
        return this.getDataFactory().newData(context, this);
    }

    public synchronized void clear() {
        this.components.clear();
        this.mathType = null;
        this.isDirty = true;
    }

    @Override
    public synchronized Object clone() {
        int n = this.size();
        VirtualTuple clone = new VirtualTuple(n);
        for (int i = 0; i < n; ++i) {
            clone.add((VirtualData)this.get(i).clone());
        }
        return clone;
    }

    @Override
    public void setDataFactory(DataFactory factory) {
        this.dataFactory = factory;
    }

    @Override
    public DataFactory getDataFactory() {
        return this.dataFactory;
    }
}

