/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hrit;

import edu.wisc.ssec.mcidas.CalibratorException;
import edu.wisc.ssec.mcidas.CalibratorMsg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.FlatField;
import visad.FunctionType;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.hrit.HRITCoordinateSystem;
import visad.util.Util;

public class HRITAdapter {
    private FlatField field = null;
    private static final int HEADER_TYPE_PRIMARY_HEADER = 0;
    private static final int HEADER_TYPE_IMAGE_STRUCTURE = 1;
    private static final int HEADER_TYPE_IMAGE_NAVIGATION = 2;
    private static final int PRIMARY_HEADER_LENGTH = 16;
    private static final int SAT_STAT_LEN = 60134;
    private static final int IMG_ACQ_LEN = 700;
    private static final int CEL_EVENTS_LEN = 326058;
    private static final int IMG_DESC_LEN = 101;
    private static final int CAL_OFFS = 72;
    private static final int SPACECRAFT_ID_MSG2 = 322;
    private static final int SPACECRAFT_ID_MSG3 = 323;

    public HRITAdapter(String[] filenames, int magFactor) throws IOException, VisADException {
        this(filenames, magFactor, 5, 1);
    }

    public HRITAdapter(String[] filenames, int magFactor, int calType, int bandNum) throws IOException, VisADException {
        if (magFactor != 1 && magFactor != 2 && magFactor != 4 && magFactor != 8 && magFactor != 16) {
            throw new VisADException("Invalid magnification factor for HRIT: " + magFactor);
        }
        if (filenames == null) {
            throw new IOException("No filenames specified");
        }
        for (int i = 0; i < filenames.length; ++i) {
            if (filenames[i] == null) {
                throw new IOException("File name in array position " + (i + 1) + " is null");
            }
            File f = new File(filenames[i]);
            if (f.exists()) continue;
            throw new IOException("File in array position " + (i + 1) + " does not exist");
        }
        int[] imageSegmentLines = new int[filenames.length];
        int[] imageSegmentElements = new int[filenames.length];
        int[] imageBitsPerPixel = new int[filenames.length];
        int[] lengthAllHeaders = new int[filenames.length];
        int[] lineOffset = new int[filenames.length];
        int minLineOffset = Integer.MAX_VALUE;
        int columnOffset = -1;
        int lineScalingFactor = -1;
        int columnScalingFactor = -1;
        byte[] tenBitInputArray = null;
        short[] tenBitOutputArray = null;
        for (int i = 0; i < filenames.length; ++i) {
            File f = new File(filenames[i]);
            FileInputStream fis = new FileInputStream(f);
            byte[] primaryHeader = new byte[16];
            int bytesRead = fis.read(primaryHeader);
            if (bytesRead < 0 || bytesRead != 16) {
                fis.close();
                throw new IOException("File " + filenames[i] + " is not an HRIT file");
            }
            int headerSize = HRITAdapter.bytesToShort(primaryHeader, 1);
            if (headerSize != 16) {
                fis.close();
                throw new IOException("File " + filenames[i] + " is not a valid HRIT file");
            }
            lengthAllHeaders[i] = HRITAdapter.bytesToInt(primaryHeader, 4);
            if (f.length() < (long)lengthAllHeaders[i]) {
                fis.close();
                throw new IOException("File " + filenames[i] + " is not a valid HRIT file");
            }
            int headerBytesConsumed = 16;
            byte[] headerType = new byte[1];
            byte[] headerLength = new byte[2];
            while (headerBytesConsumed < lengthAllHeaders[i]) {
                bytesRead = fis.read(headerType);
                headerBytesConsumed += bytesRead;
                bytesRead = fis.read(headerLength);
                headerBytesConsumed += bytesRead;
                headerSize = HRITAdapter.bytesToShort(headerLength, 0);
                byte[] header = new byte[headerSize - 3];
                bytesRead = fis.read(header);
                headerBytesConsumed += bytesRead;
                if (Util.unsignedByteToInt(headerType[0]) == 1) {
                    imageSegmentLines[i] = HRITAdapter.bytesToShort(header, 3);
                    imageSegmentElements[i] = HRITAdapter.bytesToShort(header, 1);
                    imageBitsPerPixel[i] = Util.unsignedByteToInt(header[0]);
                }
                if (Util.unsignedByteToInt(headerType[0]) != 2) continue;
                String projectionName = new String(header, 0, 32);
                projectionName = projectionName.trim();
                columnScalingFactor = HRITAdapter.bytesToInt(header, 32);
                if (columnScalingFactor < 0) {
                    columnScalingFactor = -columnScalingFactor;
                }
                if ((lineScalingFactor = HRITAdapter.bytesToInt(header, 36)) < 0) {
                    lineScalingFactor = -lineScalingFactor;
                }
                columnOffset = HRITAdapter.bytesToInt(header, 40);
                lineOffset[i] = HRITAdapter.bytesToInt(header, 44);
                if (minLineOffset <= lineOffset[i]) continue;
                minLineOffset = lineOffset[i];
            }
            fis.close();
        }
        RealType line = RealType.getRealType("ImageLine", null, null);
        RealType element = RealType.getRealType("ImageElement", null, null);
        RealType[] domainComponents = new RealType[]{element, line};
        int resMultiplier = 3;
        if (filenames[0].contains("HRV")) {
            resMultiplier = 1;
        }
        int[] iparms = new int[]{1195724627, columnOffset * resMultiplier * 10, columnOffset * resMultiplier * 10, lineScalingFactor * resMultiplier * 10, columnScalingFactor * resMultiplier * 10, 0};
        int[] dir = new int[64];
        dir[5] = resMultiplier * (minLineOffset - 464) + 5568 + 1;
        dir[6] = filenames[0].contains("HRV") ? columnOffset + 1 : 1;
        dir[8] = imageSegmentLines[0] * filenames.length;
        dir[9] = imageSegmentElements[0];
        dir[11] = resMultiplier;
        dir[12] = resMultiplier;
        HRITCoordinateSystem cs = new HRITCoordinateSystem(iparms, dir, false);
        RealTupleType imageDomain = new RealTupleType(domainComponents, (CoordinateSystem)cs, null);
        double[][] calBlock = this.makeMSGCal(filenames[0]);
        CalibratorMsg cmsg = null;
        try {
            cmsg = new CalibratorMsg(calBlock);
        }
        catch (CalibratorException ce) {
            ce.printStackTrace();
        }
        Linear2DSet domainSet = new Linear2DSet((MathType)imageDomain, 0.0, (double)(imageSegmentElements[0] - 1), imageSegmentElements[0] / magFactor, imageSegmentLines[0] * filenames.length - 1, 0.0, imageSegmentLines[0] * filenames.length / magFactor);
        int numBands = 1;
        RealType[] bands = new RealType[numBands];
        bands[0] = RealType.getRealType("Band" + bandNum);
        RealTupleType rtt = new RealTupleType(bands);
        FunctionType imageType = new FunctionType(imageDomain, rtt);
        Unit[] rangeUnits = null;
        this.field = new FlatField(imageType, (Set)domainSet, (CoordinateSystem)null, null, rangeUnits);
        for (int i = 0; i < filenames.length; ++i) {
            File f = new File(filenames[i]);
            FileInputStream fis = new FileInputStream(f);
            fis.skip(lengthAllHeaders[i]);
            tenBitInputArray = new byte[(int)f.length() - lengthAllHeaders[i] + 2];
            tenBitOutputArray = new short[imageSegmentLines[i] * imageSegmentElements[i]];
            double[][] samples = new double[numBands][imageSegmentElements[i] / magFactor * imageSegmentLines[i] / magFactor];
            byte[] sampleTwoByte = new byte[2];
            byte[] sampleOneByte = new byte[1];
            if (imageBitsPerPixel[i] != 10) {
                for (int b = 0; b < numBands; ++b) {
                    for (int l = 0; l < imageSegmentLines[i]; ++l) {
                        for (int j = 0; j < imageSegmentElements[i]; ++j) {
                            if (imageBitsPerPixel[i] == 16) {
                                fis.read(sampleTwoByte);
                                samples[b][j + imageSegmentElements[i] * l] = HRITAdapter.bytesToShort(sampleTwoByte, 0);
                                continue;
                            }
                            fis.read(sampleOneByte);
                            samples[b][j + imageSegmentElements[i] * l] = Util.unsignedByteToInt(sampleOneByte[0]);
                        }
                    }
                }
            } else {
                int convert;
                int numRead = fis.read(tenBitInputArray, 0, tenBitInputArray.length - 2);
                if (numRead == tenBitInputArray.length - 2 && (convert = Util.tenBitToTwoByte(tenBitInputArray, tenBitOutputArray)) == 0) {
                    int idx = 0;
                    for (int b = 0; b < numBands; ++b) {
                        for (int l = imageSegmentLines[i] / magFactor - 1; l >= 0; --l) {
                            for (int j = imageSegmentElements[i] / magFactor - 1; j >= 0; --j) {
                                samples[b][j + imageSegmentElements[i] / magFactor * l] = cmsg.calibrateFromRaw(tenBitOutputArray[idx], bandNum, calType);
                                idx += magFactor;
                            }
                            idx += imageSegmentElements[i] * (magFactor - 1);
                        }
                    }
                }
            }
            this.field.setSamples(samples[0].length * (filenames.length - (i + 1)), samples);
            fis.close();
        }
    }

    private double[][] makeMSGCal(String s) {
        double[][] msgCal = new double[12][6];
        double[] waveNumMSG1 = new double[12];
        double[] waveNumMSG2 = new double[12];
        double[] waveNumMSG3 = new double[12];
        double[] alphaMSG1 = new double[12];
        double[] alphaMSG2 = new double[12];
        double[] alphaMSG3 = new double[12];
        double[] betaMSG1 = new double[12];
        double[] betaMSG2 = new double[12];
        double[] betaMSG3 = new double[12];
        double[] gain = new double[12];
        double[] offset = new double[12];
        waveNumMSG1[0] = 0.0;
        waveNumMSG1[1] = 0.0;
        waveNumMSG1[2] = 0.0;
        waveNumMSG1[3] = 2567.33;
        waveNumMSG1[4] = 1598.103;
        waveNumMSG1[5] = 1362.081;
        waveNumMSG1[6] = 1149.069;
        waveNumMSG1[7] = 1034.343;
        waveNumMSG1[8] = 930.647;
        waveNumMSG1[9] = 839.66;
        waveNumMSG1[10] = 752.387;
        waveNumMSG1[11] = 0.0;
        waveNumMSG2[0] = 0.0;
        waveNumMSG2[1] = 0.0;
        waveNumMSG2[2] = 0.0;
        waveNumMSG2[3] = 2568.832;
        waveNumMSG2[4] = 1600.548;
        waveNumMSG2[5] = 1360.33;
        waveNumMSG2[6] = 1148.62;
        waveNumMSG2[7] = 1035.289;
        waveNumMSG2[8] = 931.7;
        waveNumMSG2[9] = 836.445;
        waveNumMSG2[10] = 751.792;
        waveNumMSG2[11] = 0.0;
        waveNumMSG3[0] = 0.0;
        waveNumMSG3[1] = 0.0;
        waveNumMSG3[2] = 0.0;
        waveNumMSG3[3] = 2547.771;
        waveNumMSG3[4] = 1595.621;
        waveNumMSG3[5] = 1360.377;
        waveNumMSG3[6] = 1148.13;
        waveNumMSG3[7] = 1034.715;
        waveNumMSG3[8] = 929.842;
        waveNumMSG3[9] = 838.659;
        waveNumMSG3[10] = 751.792;
        waveNumMSG3[11] = 0.0;
        alphaMSG1[0] = 0.0;
        alphaMSG1[1] = 0.0;
        alphaMSG1[2] = 0.0;
        alphaMSG1[3] = 0.9956;
        alphaMSG1[4] = 0.9962;
        alphaMSG1[5] = 0.9991;
        alphaMSG1[6] = 0.9996;
        alphaMSG1[7] = 0.9999;
        alphaMSG1[8] = 0.9983;
        alphaMSG1[9] = 0.9988;
        alphaMSG1[10] = 0.9981;
        alphaMSG1[11] = 0.0;
        alphaMSG2[0] = 0.0;
        alphaMSG2[1] = 0.0;
        alphaMSG2[2] = 0.0;
        alphaMSG2[3] = 0.9954;
        alphaMSG2[4] = 0.9963;
        alphaMSG2[5] = 0.9991;
        alphaMSG2[6] = 0.9996;
        alphaMSG2[7] = 0.9999;
        alphaMSG2[8] = 0.9983;
        alphaMSG2[9] = 0.9988;
        alphaMSG2[10] = 0.9981;
        alphaMSG2[11] = 0.0;
        alphaMSG3[0] = 0.0;
        alphaMSG3[1] = 0.0;
        alphaMSG3[2] = 0.0;
        alphaMSG3[3] = 0.9915;
        alphaMSG3[4] = 0.996;
        alphaMSG3[5] = 0.9991;
        alphaMSG3[6] = 0.9996;
        alphaMSG3[7] = 0.9999;
        alphaMSG3[8] = 0.9983;
        alphaMSG3[9] = 0.9988;
        alphaMSG3[10] = 0.9982;
        alphaMSG3[11] = 0.0;
        betaMSG1[0] = 0.0;
        betaMSG1[1] = 0.0;
        betaMSG1[2] = 0.0;
        betaMSG1[3] = 3.41;
        betaMSG1[4] = 2.218;
        betaMSG1[5] = 0.478;
        betaMSG1[6] = 0.179;
        betaMSG1[7] = 0.06;
        betaMSG1[8] = 0.625;
        betaMSG1[9] = 0.397;
        betaMSG1[10] = 0.578;
        betaMSG1[11] = 0.0;
        betaMSG2[0] = 0.0;
        betaMSG2[1] = 0.0;
        betaMSG2[2] = 0.0;
        betaMSG2[3] = 3.438;
        betaMSG2[4] = 2.185;
        betaMSG2[5] = 0.47;
        betaMSG2[6] = 0.179;
        betaMSG2[7] = 0.056;
        betaMSG2[8] = 0.64;
        betaMSG2[9] = 0.408;
        betaMSG2[10] = 0.561;
        betaMSG2[11] = 0.0;
        betaMSG3[0] = 0.0;
        betaMSG3[1] = 0.0;
        betaMSG3[2] = 0.0;
        betaMSG3[3] = 2.9002;
        betaMSG3[4] = 2.0337;
        betaMSG3[5] = 0.434;
        betaMSG3[6] = 0.1714;
        betaMSG3[7] = 0.0527;
        betaMSG3[8] = 0.6084;
        betaMSG3[9] = 0.3882;
        betaMSG3[10] = 0.539;
        betaMSG3[11] = 0.0;
        gain[0] = 0.0233101;
        gain[1] = 0.0254043;
        gain[2] = 0.0218785;
        gain[3] = 0.003742751227;
        gain[4] = 0.04641033727;
        gain[5] = 0.08197182308;
        gain[6] = 0.1256206112;
        gain[7] = 0.152327637;
        gain[8] = 0.1959369086;
        gain[9] = 0.2145945762;
        gain[10] = 0.2091678681;
        gain[11] = 0.028003;
        offset[0] = -1.18881;
        offset[1] = -1.29562;
        offset[2] = -1.1158;
        offset[3] = -0.1908803126;
        offset[4] = -2.366927201;
        offset[5] = -4.180562977;
        offset[6] = -6.40665117;
        offset[7] = -7.768709489;
        offset[8] = -9.99278234;
        offset[9] = -10.94432338;
        offset[10] = -10.66756128;
        offset[11] = -1.42815;
        int scId = 322;
        boolean accurateCal = false;
        String plFileName = s.replaceFirst("......___-0000\\d\\d___", "_________-PRO______");
        File f = new File(plFileName);
        try {
            FileInputStream fis = new FileInputStream(f);
            byte[] primaryHeader = new byte[16];
            int bytesRead = fis.read(primaryHeader);
            if (bytesRead < 0 || bytesRead != 16) {
                fis.close();
                throw new IOException("File " + s + " is not an HRIT file");
            }
            int headerSize = HRITAdapter.bytesToShort(primaryHeader, 1);
            if (headerSize != 16) {
                fis.close();
                throw new IOException("File " + s + " is not a valid HRIT file");
            }
            int lengthAllHeaders = -1;
            lengthAllHeaders = HRITAdapter.bytesToInt(primaryHeader, 4);
            if (f.length() < (long)lengthAllHeaders) {
                fis.close();
                throw new IOException("File " + s + " is not a valid HRIT file");
            }
            byte[] headerType = new byte[1];
            byte[] headerLength = new byte[2];
            for (int headerBytesConsumed = 16; headerBytesConsumed < lengthAllHeaders; headerBytesConsumed += bytesRead) {
                bytesRead = fis.read(headerType);
                headerBytesConsumed += bytesRead;
                bytesRead = fis.read(headerLength);
                headerBytesConsumed += bytesRead;
                headerSize = HRITAdapter.bytesToShort(headerLength, 0);
                byte[] header = new byte[headerSize - 3];
                bytesRead = fis.read(header);
            }
            byte[] b2 = new byte[2];
            fis.read(b2);
            scId = HRITAdapter.bytesToShort(b2, 0);
            long n = fis.skip(387063L);
            if (n != 387063L) {
                fis.close();
                throw new IOException("Failed to read calibration coefficients, corrupt file?");
            }
            for (int i = 0; i < 12; ++i) {
                byte[] d1 = new byte[8];
                byte[] d2 = new byte[8];
                int count = fis.read(d1);
                if (count != 8) {
                    fis.close();
                    throw new IOException("Failed to read calibration coefficients, corrupt file?");
                }
                count = fis.read(d2);
                if (count != 8) {
                    fis.close();
                    throw new IOException("Failed to read calibration coefficients, corrupt file?");
                }
                long l1 = HRITAdapter.bytesToLong(d1, 0);
                long l2 = HRITAdapter.bytesToLong(d2, 0);
                gain[i] = Double.longBitsToDouble(l1);
                offset[i] = Double.longBitsToDouble(l2);
            }
            accurateCal = true;
            fis.close();
        }
        catch (FileNotFoundException fis) {
        }
        catch (IOException fis) {
            // empty catch block
        }
        if (!accurateCal) {
            System.err.println("WARNING: Data will be displayed, but calibration is approximate.");
        }
        double w = 0.0;
        double c1w3 = 0.0;
        double c2w = 0.0;
        double PLANCK = 6.626176E-34;
        double LIGHT = 2.99792458E8;
        double BOLTZMAN = 1.380662E-23;
        double c1 = 200000.0 * PLANCK * (LIGHT * LIGHT);
        double c2 = PLANCK * LIGHT / BOLTZMAN;
        for (int band = 0; band < 12; ++band) {
            if (scId == 322) {
                w = 100.0 * waveNumMSG2[band];
                msgCal[band][2] = alphaMSG2[band];
                msgCal[band][3] = betaMSG2[band];
            } else if (scId == 323) {
                w = 100.0 * waveNumMSG3[band];
                msgCal[band][2] = alphaMSG3[band];
                msgCal[band][3] = betaMSG3[band];
            } else {
                w = 100.0 * waveNumMSG1[band];
                msgCal[band][2] = alphaMSG1[band];
                msgCal[band][3] = betaMSG1[band];
            }
            c1w3 = c1 * w * w * w;
            c2w = c2 * w;
            msgCal[band][0] = c1w3;
            msgCal[band][1] = c2w;
            msgCal[band][4] = gain[band];
            msgCal[band][5] = offset[band];
        }
        return msgCal;
    }

    private void dumpHeader(byte[] header) {
        if (header != null && header.length >= 3) {
            System.out.println("Header type: " + header[0]);
            System.out.println("Length of this header: " + HRITAdapter.bytesToShort(header, 1));
        }
        switch (header[0]) {
            case 0: {
                System.out.println("Length of all headers: " + HRITAdapter.bytesToInt(header, 4));
                break;
            }
        }
    }

    public FlatField getData() {
        return this.field;
    }

    public static long bytesToLong(byte[] data, int offset) {
        long l = 0L;
        l += Util.unsignedByteToLong(data[offset + 0]) << 56;
        l += Util.unsignedByteToLong(data[offset + 1]) << 48;
        l += Util.unsignedByteToLong(data[offset + 2]) << 40;
        l += Util.unsignedByteToLong(data[offset + 3]) << 32;
        l += Util.unsignedByteToLong(data[offset + 4]) << 24;
        l += Util.unsignedByteToLong(data[offset + 5]) << 16;
        l += Util.unsignedByteToLong(data[offset + 6]) << 8;
        return l += Util.unsignedByteToLong(data[offset + 7]);
    }

    public static int bytesToInt(byte[] data, int offset) {
        int i = 0;
        i += Util.unsignedByteToInt(data[offset]) << 24;
        i += Util.unsignedByteToInt(data[offset + 1]) << 16;
        i += Util.unsignedByteToInt(data[offset + 2]) << 8;
        return i += Util.unsignedByteToInt(data[offset + 3]);
    }

    public static int bytesToShort(byte[] data, int offset) {
        int i = 0;
        i += Util.unsignedByteToInt(data[offset]) << 8;
        return i += Util.unsignedByteToInt(data[offset + 1]);
    }
}

