/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.GctpFunction;

public class LambertAzimuthalEqualArea
extends CoordinateSystem {
    double R;
    double lon_center;
    double lat_center;
    double false_easting;
    double false_northing;
    double sin_lat_o;
    double cos_lat_o;
    Unit[] reference_units;
    private static Unit[] coordinate_system_units = new Unit[]{null, null};
    private static Unit[] default_reference_units = new Unit[]{CommonUnit.radian, CommonUnit.radian};

    public LambertAzimuthalEqualArea(RealTupleType reference, double lon_center, double lat_center) throws VisADException {
        this(reference, 6367470.0, lon_center, lat_center, 0.0, 0.0);
    }

    public LambertAzimuthalEqualArea(RealTupleType reference, double R, double lon_center, double lat_center, double false_easting, double false_northing) throws VisADException {
        super(reference, coordinate_system_units);
        this.reference_units = reference.getDefaultUnits();
        if (this.reference_units != null) {
            if (!Unit.canConvertArray(default_reference_units, this.reference_units)) {
                throw new VisADException("not compatible with reference units");
            }
        } else {
            this.reference_units = default_reference_units;
        }
        this.R = R;
        this.lon_center = lon_center;
        this.lat_center = lat_center;
        this.false_easting = false_easting;
        this.false_northing = false_northing;
        this.sin_lat_o = Math.sin(lat_center);
        this.cos_lat_o = Math.cos(lat_center);
    }

    @Override
    public double[][] toReference(double[][] tuples) throws VisADException {
        double[] dum_1 = new double[1];
        double[] dum_2 = new double[1];
        double[] dum = new double[1];
        int n_tuples = tuples[0].length;
        int tuple_dim = tuples.length;
        if (tuple_dim != 2) {
            throw new VisADException("LambertAzimuthalEqualArea: tuple dim != 2");
        }
        double[][] t_tuples = new double[2][n_tuples];
        for (int ii = 0; ii < n_tuples; ++ii) {
            double lat;
            double z;
            double x = tuples[0][ii] - this.false_easting;
            double y = tuples[1][ii] - this.false_northing;
            double Rh = Math.sqrt(x * x + y * y);
            double temp = Rh / (2.0 * this.R);
            if (temp > 1.0) {
                // empty if block
            }
            dum[0] = z = 2.0 * GctpFunction.asinz(temp);
            GctpFunction.sincos(dum, dum_1, dum_2);
            double sin_z = dum_1[0];
            double cos_z = dum_2[0];
            double lon = this.lon_center;
            if (Math.abs(Rh) > 1.0E-10) {
                lat = GctpFunction.asinz(this.sin_lat_o * cos_z + this.cos_lat_o * sin_z * y / Rh);
                temp = Math.abs(this.lat_center) - 1.5707963267948966;
                if (Math.abs(temp) > 1.0E-10) {
                    temp = cos_z - this.sin_lat_o * Math.sin(lat);
                    if (temp != 0.0) {
                        lon = GctpFunction.adjust_lon(this.lon_center + Math.atan2(x * sin_z * this.cos_lat_o, temp * Rh));
                    }
                } else {
                    lon = this.lat_center < 0.0 ? GctpFunction.adjust_lon(this.lon_center - Math.atan2(-x, y)) : GctpFunction.adjust_lon(this.lon_center + Math.atan2(x, -y));
                }
            } else {
                lat = this.lat_center;
            }
            t_tuples[0][ii] = lon;
            t_tuples[1][ii] = lat;
        }
        return Unit.convertTuple(t_tuples, default_reference_units, this.reference_units);
    }

    @Override
    public double[][] fromReference(double[][] tuples) throws VisADException {
        int ii;
        int n_tuples = tuples[0].length;
        int tuple_dim = tuples.length;
        if (tuple_dim != 2) {
            throw new VisADException("LambertAzimuthalEqualArea: tuple dim != 2");
        }
        tuples = Unit.convertTuple(tuples, this.reference_units, default_reference_units);
        double[][] t_tuples = new double[2][n_tuples];
        double[] delta_lon = new double[n_tuples];
        double[] sin_lat = new double[n_tuples];
        double[] cos_lat = new double[n_tuples];
        double[] sin_delta_lon = new double[n_tuples];
        double[] cos_delta_lon = new double[n_tuples];
        for (ii = 0; ii < n_tuples; ++ii) {
            delta_lon[ii] = tuples[0][ii] - this.lon_center;
        }
        GctpFunction.adjust_lon(delta_lon);
        GctpFunction.sincos(tuples[1], sin_lat, cos_lat);
        GctpFunction.sincos(delta_lon, sin_delta_lon, cos_delta_lon);
        for (ii = 0; ii < n_tuples; ++ii) {
            double g = this.sin_lat_o * sin_lat[ii] + this.cos_lat_o * cos_lat[ii] * cos_delta_lon[ii];
            if (g == -1.0) {
                t_tuples[0][ii] = Double.NaN;
                t_tuples[1][ii] = Double.NaN;
            }
            double ksp = this.R * Math.sqrt(2.0 / (1.0 + g));
            t_tuples[0][ii] = ksp * cos_lat[ii] * sin_delta_lon[ii] + this.false_easting;
            t_tuples[1][ii] = ksp * (this.cos_lat_o * sin_lat[ii] - this.sin_lat_o * cos_lat[ii] * cos_delta_lon[ii]) + this.false_northing;
        }
        delta_lon = null;
        sin_lat = null;
        cos_lat = null;
        sin_delta_lon = null;
        cos_delta_lon = null;
        return t_tuples;
    }

    @Override
    public boolean equals(Object cs) {
        if (cs instanceof LambertAzimuthalEqualArea) {
            LambertAzimuthalEqualArea that = (LambertAzimuthalEqualArea)cs;
            if (this.R == that.R && this.lon_center == that.lon_center && this.lat_center == that.lat_center && this.false_easting == that.false_easting && this.false_northing == that.false_northing) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) throws VisADException {
        double[][] values_in = new double[][]{{-1.5707963267948966, -1.4835298641951802, -1.3962634015954636, -1.3089969389957472}, {0.7330382858376184, 0.7330382858376184, 0.7330382858376184, 0.7330382858376184}};
        double earth_rad = 6367470.0;
        double lon_center = -1.5707963267948966;
        double lat_center = 0.7330382858376184;
        double false_easting = 0.0;
        double false_northing = 0.0;
        RealType[] reals = new RealType[]{RealType.Longitude, RealType.Latitude};
        RealTupleType Reference2 = new RealTupleType(reals);
        LambertAzimuthalEqualArea lamaz_cs = new LambertAzimuthalEqualArea(Reference2, earth_rad, lon_center, lat_center, false_easting, false_northing);
        for (int i = 0; i < values_in[0].length; ++i) {
            System.out.println(values_in[0][i] + ",  " + values_in[1][i]);
        }
        System.out.println("");
        double[][] values_out = ((CoordinateSystem)lamaz_cs).fromReference(values_in);
        for (int i = 0; i < values_out[0].length; ++i) {
            System.out.println(values_out[0][i] + ",  " + values_out[1][i]);
        }
        double[][] values_inR = ((CoordinateSystem)lamaz_cs).toReference(values_out);
        System.out.println("");
        for (int i = 0; i < values_inR[0].length; ++i) {
            System.out.println(values_inR[0][i] + ",  " + values_inR[1][i]);
        }
    }
}

