/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import java.util.StringTokenizer;
import java.util.Vector;
import visad.data.hdfeos.DimensionSet;
import visad.data.hdfeos.EosStruct;
import visad.data.hdfeos.GctpMap;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.NamedDimension;
import visad.data.hdfeos.ShapeSet;
import visad.data.hdfeos.Variable;
import visad.data.hdfeos.VariableSet;
import visad.data.hdfeos.hdfeosc.HdfeosLib;

public class EosGrid
extends EosStruct {
    int grid_id;
    int file_id;
    int sd_id;
    private String grid_name;
    DimensionSet D_Set = null;
    VariableSet DV_Set;
    ShapeSet DV_shapeSet;
    GctpMap gridMap;

    EosGrid(int file_id, int sd_id, String name) throws HdfeosException {
        this.file_id = file_id;
        this.sd_id = sd_id;
        this.grid_name = name;
        this.struct_id = this.grid_id = HdfeosLib.GDattach(file_id, name);
        if (this.grid_id < 0) {
            throw new HdfeosException("EosGrid cannot attatch Grid: " + name);
        }
        int[] stringSize = new int[]{0};
        DimensionSet D_Set = new DimensionSet();
        int n_dims = HdfeosLib.GDnentries(this.grid_id, 0, stringSize);
        if (n_dims > 0) {
            String[] dimensionList = new String[]{"empty"};
            int[] lengths = new int[n_dims];
            if ((n_dims = HdfeosLib.GDinqdims(this.grid_id, stringSize[0], dimensionList, lengths)) <= 0) {
                throw new HdfeosException("GDinqdims status: " + n_dims);
            }
            StringTokenizer listElements = new StringTokenizer(dimensionList[0], ",", false);
            int cnt = 0;
            while (listElements.hasMoreElements()) {
                name = (String)listElements.nextElement();
                int len = lengths[cnt];
                NamedDimension obj = new NamedDimension(this.grid_id, name, len, null);
                D_Set.add(obj);
                ++cnt;
            }
        }
        this.D_Set = D_Set;
        int n_flds = HdfeosLib.GDnentries(this.grid_id, 4, stringSize);
        if (n_flds <= 0) {
            throw new HdfeosException(" no data fields  ");
        }
        String[] D_List = new String[]{"empty"};
        int[] dumA = new int[n_flds];
        int[] dumB = new int[n_flds];
        if ((n_flds = HdfeosLib.GDinqfields(this.grid_id, stringSize[0], D_List, dumA, dumB)) < 0) {
            throw new HdfeosException("no data fields in grid struct: " + this.grid_id);
        }
        this.makeVariables(D_List[0]);
        this.DV_shapeSet = new ShapeSet(this.DV_Set);
        int[] projcode = new int[1];
        int[] zonecode = new int[1];
        int[] sphrcode = new int[1];
        double[] projparm = new double[16];
        int stat = HdfeosLib.GDprojinfo(this.grid_id, projcode, zonecode, sphrcode, projparm);
        if (stat < 0) {
            throw new HdfeosException(" GDprojinfo, status: " + stat);
        }
        int[] xdimsize = new int[1];
        int[] ydimsize = new int[1];
        double[] uprLeft = new double[2];
        double[] lwrRight = new double[2];
        stat = HdfeosLib.GDgridinfo(this.grid_id, xdimsize, ydimsize, uprLeft, lwrRight);
        if (stat < 0) {
            throw new HdfeosException(" GDgridinfo, status: " + stat);
        }
        this.gridMap = new GctpMap(projcode[0], zonecode[0], sphrcode[0], xdimsize[0], ydimsize[0], projparm, uprLeft, lwrRight);
    }

    @Override
    public int getStructId() {
        return this.grid_id;
    }

    public GctpMap getMap() {
        return this.gridMap;
    }

    public ShapeSet getShapeSet() {
        return this.DV_shapeSet;
    }

    private void makeVariables(String fieldList) throws HdfeosException {
        int[] rank = new int[1];
        int[] type = new int[1];
        int[] lengths = new int[10];
        StringTokenizer listElements = new StringTokenizer(fieldList, ",", false);
        VariableSet varSet = new VariableSet();
        while (listElements.hasMoreElements()) {
            String field = (String)listElements.nextElement();
            String[] dim_list = new String[]{"empty"};
            int stat = HdfeosLib.GDfieldinfo(this.grid_id, field, dim_list, rank, lengths, type);
            if (stat < 0) {
                throw new HdfeosException(" GDfieldinfo, stat < 1 for: " + field);
            }
            StringTokenizer dimListElements = new StringTokenizer(dim_list[0], ",", false);
            Vector dims = new Vector();
            DimensionSet newSet = new DimensionSet();
            int cnt = 0;
            while (dimListElements.hasMoreElements()) {
                String dimName = (String)dimListElements.nextElement();
                NamedDimension n_dim = this.D_Set.getByName(dimName);
                if (n_dim == null) {
                    n_dim = new NamedDimension(this.grid_id, dimName, lengths[cnt], null);
                    this.D_Set.add(n_dim);
                }
                if (n_dim.isUnlimited()) {
                    n_dim.setLength(lengths[cnt]);
                }
                newSet.add(n_dim);
                ++cnt;
            }
            newSet.setToFinished();
            Variable obj = new Variable(field, newSet, rank[0], type[0], null);
            varSet.add(obj);
        }
        varSet.setToFinished();
        this.DV_Set = varSet;
    }
}

