/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DelaunayCustom;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DDoubleSet;
import visad.Irregular2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.UnionSet;
import visad.VisADException;
import visad.bom.ScreenLockedRendererJ3D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;

public final class ScreenLockedDemo {
    private DisplayImplJ3D display = new DisplayImplJ3D("display");
    private ScalarMap xMap;
    private ScalarMap yMap;

    public ScreenLockedDemo() throws VisADException, RemoteException {
        GraphicsModeControl gmc = this.display.getGraphicsModeControl();
        gmc.setScaleEnable(false);
        gmc.setProjectionPolicy(0);
        this.display.getDisplayRenderer().setBoxOn(false);
        RealType x = RealType.getRealType("x");
        RealType y = RealType.getRealType("y");
        this.xMap = new ScalarMap(x, Display.XAxis);
        this.yMap = new ScalarMap(y, Display.YAxis);
        this.display.addMap(this.xMap);
        this.display.addMap(this.yMap);
        ScreenLockedDemo.addScreenLockedSquare(this.display);
        ScreenLockedDemo.addCross(this.display);
        JFrame frame = new JFrame("Screen Locked Demo");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.display.getComponent(), "Center");
        JPanel buttonsPanel = new JPanel();
        ButtonListener buttonListener = new ButtonListener();
        JButton button = new JButton("Add Triangle");
        button.addActionListener(buttonListener);
        buttonsPanel.add(button);
        button = new JButton("Add Field");
        button.addActionListener(buttonListener);
        buttonsPanel.add(button);
        button = new JButton("Set Range");
        button.addActionListener(buttonListener);
        buttonsPanel.add(button);
        panel.add((Component)buttonsPanel, "South");
        frame.getContentPane().add(panel);
        frame.setSize(640, 480);
        frame.setVisible(true);
    }

    private static void addScreenLockedSquare(DisplayImpl display) throws VisADException, RemoteException {
        int numSamples = 4;
        double[][] samples = new double[2][4];
        samples[0][0] = -10.0;
        samples[1][0] = 10.0;
        samples[0][1] = 10.0;
        samples[1][1] = 10.0;
        samples[0][2] = 10.0;
        samples[1][2] = -10.0;
        samples[0][3] = -10.0;
        samples[1][3] = -10.0;
        RealTupleType domainType = new RealTupleType(RealType.getRealType("a"), RealType.getRealType("b"));
        Gridded2DDoubleSet set = new Gridded2DDoubleSet((MathType)domainType, samples, 4);
        Irregular2DSet filledSet = DelaunayCustom.fill(set);
        DataReferenceImpl dataRef = new DataReferenceImpl("square_data_ref");
        dataRef.setData(filledSet);
        ScalarMap yMap = new ScalarMap(RealType.getRealType("a"), Display.YAxis);
        ScalarMap xMap = new ScalarMap(RealType.getRealType("b"), Display.XAxis);
        display.addMap(yMap);
        display.addMap(xMap);
        yMap.setRange(-10.0, 10.0);
        xMap.setRange(-10.0, 10.0);
        ScreenLockedRendererJ3D renderer = new ScreenLockedRendererJ3D();
        ConstantMap[] maps = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(-0.03, Display.ZAxis)};
        display.addReferences((DataRenderer)renderer, dataRef, maps);
    }

    private static void addTriangle(DisplayImpl display) throws VisADException, RemoteException {
        int numSamples = 3;
        double[][] samples = new double[2][3];
        samples[0][0] = 12.0;
        samples[1][0] = -15.0;
        samples[0][1] = 17.0;
        samples[1][1] = -10.0;
        samples[0][2] = 22.0;
        samples[1][2] = -15.0;
        RealTupleType type = new RealTupleType(RealType.getRealType("x"), RealType.getRealType("y"));
        Gridded2DDoubleSet set = new Gridded2DDoubleSet((MathType)type, samples, 3);
        Irregular2DSet filledSet = DelaunayCustom.fill(set);
        DataReferenceImpl dataRef = new DataReferenceImpl("triangle_data_ref");
        dataRef.setData(filledSet);
        DefaultRendererJ3D renderer = new DefaultRendererJ3D();
        ConstantMap[] maps = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(1.0, Display.Blue), new ConstantMap(-0.02, Display.ZAxis)};
        display.addReferences((DataRenderer)renderer, dataRef, maps);
    }

    private static void addCross(DisplayImpl display) throws VisADException, RemoteException {
        int numSamples = 2;
        double[][] samples = new double[2][2];
        samples[0][0] = -12.0;
        samples[1][0] = 0.0;
        samples[0][1] = 12.0;
        samples[1][1] = 0.0;
        RealTupleType type = new RealTupleType(RealType.getRealType("x"), RealType.getRealType("y"));
        Gridded2DDoubleSet horizontalSet = new Gridded2DDoubleSet((MathType)type, samples, 2);
        samples[0][0] = 0.0;
        samples[1][0] = 12.0;
        samples[0][1] = 0.0;
        samples[1][1] = -12.0;
        Gridded2DDoubleSet verticalSet = new Gridded2DDoubleSet((MathType)type, samples, 2);
        UnionSet set = new UnionSet(new Gridded2DDoubleSet[]{horizontalSet, verticalSet});
        DataReferenceImpl dataRef = new DataReferenceImpl("lines_data_ref");
        dataRef.setData(set);
        ConstantMap[] maps = new ConstantMap[]{new ConstantMap(2.0, Display.LineWidth), new ConstantMap(-0.01, Display.ZAxis)};
        display.addReference(dataRef, maps);
    }

    private static void addField(DisplayImpl display) throws VisADException, RemoteException {
        RealTupleType domainType = new RealTupleType(RealType.getRealType("x"), RealType.getRealType("y"));
        RealType rangeType = RealType.getRealType("height");
        FunctionType functionType = new FunctionType(domainType, rangeType);
        FlatField field = FlatField.makeField1(functionType, 11.0, 18.0, 10, 11.0, 18.0, 10);
        DataReferenceImpl dataRef = new DataReferenceImpl("field_data_ref");
        dataRef.setData(field);
        display.addMap(new ScalarMap(rangeType, Display.RGB));
        display.addReference(dataRef);
    }

    public static final void main(String[] args) throws VisADException, RemoteException {
        new ScreenLockedDemo();
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                String command = event.getActionCommand();
                if (command.equals("Add Triangle")) {
                    ScreenLockedDemo.addTriangle(ScreenLockedDemo.this.display);
                } else if (command.equals("Add Field")) {
                    ScreenLockedDemo.addField(ScreenLockedDemo.this.display);
                } else {
                    ScreenLockedDemo.this.xMap.setRange(-10.0, 10.0);
                    ScreenLockedDemo.this.yMap.setRange(-10.0, 10.0);
                }
            }
            catch (VisADException ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
            catch (RemoteException ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }
}

