/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.util.ArrayList;
import java.util.Iterator;
import visad.bom.Tile;

class Mosaic {
    Tile[][] tiles;
    ArrayList<Tile> tileList = new ArrayList();
    int n_x_sub = 1;
    int n_y_sub = 1;

    Mosaic(int lenY, int limitY, int lenX, int limitX) {
        int[][] y_start_stop = null;
        this.n_y_sub = lenY / limitY;
        if (this.n_y_sub == 0 || lenY % limitY == 0) {
            this.n_y_sub = 1;
            y_start_stop = new int[this.n_y_sub][2];
            y_start_stop[0][0] = 0;
            y_start_stop[0][1] = lenY - 1;
        } else {
            int k;
            ++this.n_y_sub;
            int tLenY = limitY;
            int rem = lenY % limitY;
            if (rem < limitY / 4) {
                tLenY = lenY / this.n_y_sub;
            }
            y_start_stop = new int[this.n_y_sub][2];
            for (k = 0; k < this.n_y_sub - 1; ++k) {
                y_start_stop[k][0] = k * tLenY - k;
                y_start_stop[k][1] = y_start_stop[k][0] + tLenY - 1;
            }
            k = this.n_y_sub - 1;
            y_start_stop[k][0] = y_start_stop[k - 1][1];
            y_start_stop[k][1] = lenY - 1;
        }
        int[][] x_start_stop = null;
        this.n_x_sub = lenX / limitX;
        if (this.n_x_sub == 0 || lenX % limitX == 0) {
            this.n_x_sub = 1;
            x_start_stop = new int[this.n_x_sub][2];
            x_start_stop[0][0] = 0;
            x_start_stop[0][1] = lenX - 1;
        } else {
            int k;
            ++this.n_x_sub;
            int tLenX = limitX;
            int rem = lenX % limitX;
            if (rem < limitX / 4) {
                tLenX = lenX / this.n_x_sub;
            }
            x_start_stop = new int[this.n_x_sub][2];
            for (k = 0; k < this.n_x_sub - 1; ++k) {
                x_start_stop[k][0] = k * tLenX - k;
                x_start_stop[k][1] = x_start_stop[k][0] + tLenX - 1;
            }
            k = this.n_x_sub - 1;
            x_start_stop[k][0] = x_start_stop[k - 1][1];
            x_start_stop[k][1] = lenX - 1;
        }
        this.tiles = new Tile[this.n_y_sub][this.n_x_sub];
        for (int j = 0; j < this.n_y_sub; ++j) {
            for (int i = 0; i < this.n_x_sub; ++i) {
                this.tiles[j][i] = new Tile(y_start_stop[j][0], y_start_stop[j][1], x_start_stop[i][0], x_start_stop[i][1]);
                this.tileList.add(this.tiles[j][i]);
            }
        }
    }

    Iterator iterator() {
        return this.tileList.iterator();
    }
}

