/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class InverseCoordinateSystem
extends CoordinateSystem {
    private CoordinateSystem inverse;
    private int dimension;

    public InverseCoordinateSystem(RealTupleType reference, CoordinateSystem inv) throws VisADException {
        super(reference, inv.getReference().getDefaultUnits());
        this.inverse = inv;
        this.dimension = reference.getDimension();
        Unit[] inv_units = inv.getCoordinateSystemUnits();
        Unit[] ref_units = reference.getDefaultUnits();
        if (inv_units.length != this.dimension) {
            throw new CoordinateSystemException("InverseCoordinateSystem: dimensions don't match");
        }
        for (int i = 0; i < inv_units.length; ++i) {
            if ((inv_units[i] != null || ref_units[i] == null) && (inv_units[i] == null || inv_units[i].equals(ref_units[i]))) continue;
            throw new CoordinateSystemException("InverseCoordinateSystem: Units don't match " + i + " " + inv_units[i] + " " + ref_units[i]);
        }
    }

    @Override
    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != this.dimension) {
            throw new CoordinateSystemException("InverseCoordinateSystem.toReference: tuples wrong dimension");
        }
        return this.inverse.fromReference(tuples);
    }

    @Override
    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != this.dimension) {
            throw new CoordinateSystemException("InverseCoordinateSystem.fromReference: tuples wrong dimension");
        }
        return this.inverse.toReference(tuples);
    }

    @Override
    public float[][] toReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != this.dimension) {
            throw new CoordinateSystemException("InverseCoordinateSystem.toReference: tuples wrong dimension");
        }
        return this.inverse.fromReference(tuples);
    }

    @Override
    public float[][] fromReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != this.dimension) {
            throw new CoordinateSystemException("InverseCoordinateSystem.fromReference: tuples wrong dimension");
        }
        return this.inverse.toReference(tuples);
    }

    @Override
    public boolean equals(Object cs) {
        return cs instanceof InverseCoordinateSystem && this.inverse.equals(((InverseCoordinateSystem)cs).inverse);
    }
}

