/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedDoubleSet;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Gridded1DDoubleSet
extends Gridded1DSet
implements GriddedDoubleSet {
    double[] Low;
    double[] Hi;
    double LowX;
    double HiX;
    double[][] Samples;
    private static final WeakHashMap cache = new WeakHashMap();

    public Gridded1DDoubleSet(MathType type, float[][] samples, int lengthX) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, null, null, null, true);
    }

    public Gridded1DDoubleSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, true);
    }

    public Gridded1DDoubleSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, copy);
    }

    public Gridded1DDoubleSet(MathType type, double[][] samples, int lengthX) throws VisADException {
        this(type, samples, lengthX, null, null, null, true);
    }

    public Gridded1DDoubleSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, true);
    }

    public Gridded1DDoubleSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        block6: {
            int i;
            super(type, (float[][])null, lengthX, coord_sys, units, errors, copy);
            this.Low = new double[1];
            this.Hi = new double[1];
            if (samples == null) {
                throw new SetException("Gridded1DDoubleSet: samples are null");
            }
            this.init_doubles(samples, copy);
            this.LowX = this.Low[0];
            this.HiX = this.Hi[0];
            this.LengthX = this.Lengths[0];
            if (this.Samples == null || this.Lengths[0] <= 1) break block6;
            for (i = 0; i < this.Length; ++i) {
                if (this.Samples[0][i] == this.Samples[0][i]) continue;
                throw new SetException("Gridded1DDoubleSet: samples values may not be missing");
            }
            boolean bl = this.Ascending = this.Samples[0][this.LengthX - 1] > this.Samples[0][0];
            if (this.Ascending) {
                for (i = 1; i < this.LengthX; ++i) {
                    if (!(this.Samples[0][i] < this.Samples[0][i - 1])) continue;
                    throw new SetException("Gridded1DDoubleSet: samples do not form a valid grid (" + i + ")");
                }
            } else {
                for (i = 1; i < this.LengthX; ++i) {
                    if (!(this.Samples[0][i] > this.Samples[0][i - 1])) continue;
                    throw new SetException("Gridded1DDoubleSet: samples do not form a valid grid (" + i + ")");
                }
            }
        }
    }

    public static synchronized Gridded1DDoubleSet create(MathType type, double[] samples, CoordinateSystem coordSys, Unit unit, ErrorEstimate error) throws VisADException {
        Gridded1DDoubleSet newSet = new Gridded1DDoubleSet(type, new double[][]{samples}, samples.length, coordSys, new Unit[]{unit}, new ErrorEstimate[]{error}, false);
        WeakReference ref = (WeakReference)cache.get(newSet);
        if (ref == null) {
            cache.put(newSet, new WeakReference<Gridded1DDoubleSet>(newSet));
        } else {
            Gridded1DDoubleSet oldSet = (Gridded1DDoubleSet)ref.get();
            if (oldSet == null) {
                cache.put(newSet, new WeakReference<Gridded1DDoubleSet>(newSet));
            } else {
                newSet = oldSet;
            }
        }
        return newSet;
    }

    @Override
    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    @Override
    public float[][] getSamples(boolean copy) throws VisADException {
        return Set.doubleToFloat(this.Samples);
    }

    @Override
    public float[][] indexToValue(int[] index) throws VisADException {
        return Set.doubleToFloat(this.indexToDouble(index));
    }

    @Override
    public int[] valueToIndex(float[][] value) throws VisADException {
        return this.doubleToIndex(Set.floatToDouble(value));
    }

    @Override
    public float[][] gridToValue(float[][] grid) throws VisADException {
        return Set.doubleToFloat(this.gridToDouble(Set.floatToDouble(grid)));
    }

    @Override
    public float[][] valueToGrid(float[][] value) throws VisADException {
        return Set.doubleToFloat(this.doubleToGrid(Set.floatToDouble(value)));
    }

    @Override
    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        int len = weights.length;
        double[][] w = new double[len][];
        this.doubleToInterp(Set.floatToDouble(value), indices, w);
        for (int i = 0; i < len; ++i) {
            if (w[i] == null) continue;
            weights[i] = new float[w[i].length];
            for (int j = 0; j < w[i].length; ++j) {
                weights[i][j] = (float)w[i][j];
            }
        }
    }

    @Override
    public float getLowX() {
        return (float)this.LowX;
    }

    @Override
    public float getHiX() {
        return (float)this.HiX;
    }

    @Override
    public double[][] getDoubles() throws VisADException {
        return this.getDoubles(true);
    }

    @Override
    public double[][] getDoubles(boolean copy) throws VisADException {
        return copy ? Set.copyDoubles(this.Samples) : this.Samples;
    }

    @Override
    public double[][] indexToDouble(int[] index) throws VisADException {
        int length = index.length;
        if (this.Samples == null) {
            double[][] grid = new double[this.ManifoldDimension][length];
            for (int i = 0; i < length; ++i) {
                grid[0][i] = 0 <= index[i] && index[i] < this.Length ? (double)index[i] : -1.0;
            }
            return this.gridToDouble(grid);
        }
        double[][] values = new double[1][length];
        for (int i = 0; i < length; ++i) {
            values[0][i] = 0 <= index[i] && index[i] < this.Length ? this.Samples[0][index[i]] : Double.NaN;
        }
        return values;
    }

    @Override
    public int[] doubleToIndex(double[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.doubleToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        double[][] grid = this.doubleToGrid(value);
        double[] grid0 = grid[0];
        for (int i = 0; i < length; ++i) {
            double g = grid0[i];
            index[i] = Double.isNaN(g) ? -1 : (int)(g + 0.5);
        }
        return index;
    }

    @Override
    public double[][] gridToDouble(double[][] grid) throws VisADException {
        if (grid.length < this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.gridToDouble: grid dimension " + grid.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = grid[0].length;
        double[][] value = new double[1][length];
        for (int i = 0; i < length; ++i) {
            double g = grid[0][i];
            if (g < -0.5 || g > (double)this.LengthX - 0.5) {
                value[0][i] = Double.NaN;
                continue;
            }
            if (this.Length == 1) {
                value[0][i] = this.Samples[0][0];
                continue;
            }
            int ig = g < 0.0 ? 0 : (g >= (double)(this.LengthX - 1) ? this.LengthX - 2 : (int)g);
            double A = g - (double)ig;
            value[0][i] = (1.0 - A) * this.Samples[0][ig] + A * this.Samples[0][ig + 1];
        }
        return value;
    }

    @Override
    public double[][] doubleToGrid(double[][] value) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.doubleToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        double[] vals = value[0];
        int length = vals.length;
        double[] samps = this.Samples[0];
        double[][] grid = new double[1][length];
        int ig = (this.LengthX - 1) / 2;
        for (int i = 0; i < length; ++i) {
            if (Double.isNaN(vals[i])) {
                grid[0][i] = Double.NaN;
                continue;
            }
            if (this.Length == 1) {
                grid[0][i] = 0.0;
                continue;
            }
            int lower = 0;
            int upper = this.LengthX - 1;
            while (lower < upper && !((vals[i] - samps[ig]) * (vals[i] - samps[ig + 1]) <= 0.0)) {
                if (this.Ascending ? samps[ig + 1] < vals[i] : samps[ig + 1] > vals[i]) {
                    lower = ig + 1;
                } else if (this.Ascending ? samps[ig] > vals[i] : samps[ig] < vals[i]) {
                    upper = ig;
                }
                if (lower >= upper) continue;
                ig = (lower + upper) / 2;
            }
            double solv = (double)ig + (vals[i] - samps[ig]) / (samps[ig + 1] - samps[ig]);
            if (solv > -0.5 && solv < (double)this.LengthX - 0.5) {
                grid[0][i] = solv;
                continue;
            }
            grid[0][i] = Double.NaN;
            ig = (this.LengthX - 1) / 2;
        }
        return grid;
    }

    @Override
    public void doubleToInterp(double[][] value, int[][] indices, double[][] weights) throws VisADException {
        int j;
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.doubleToInterp: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        if (indices.length != length) {
            throw new SetException("Gridded1DDoubleSet.doubleToInterp: indices length " + indices.length + " doesn't match value[0] length " + value[0].length);
        }
        if (weights.length != length) {
            throw new SetException("Gridded1DDoubleSet.doubleToInterp: weights length " + weights.length + " doesn't match value[0] length " + value[0].length);
        }
        double[][] grid = this.doubleToGrid(value);
        int[] l = new int[this.ManifoldDimension];
        double[] c = new double[this.ManifoldDimension];
        int[] off = new int[this.ManifoldDimension];
        off[0] = 1;
        for (j = 1; j < this.ManifoldDimension; ++j) {
            off[j] = off[j - 1] * this.Lengths[j - 1];
        }
        for (int i = 0; i < length; ++i) {
            double[] cs;
            int[] is;
            int base;
            int length_is = 1;
            if (Double.isNaN(grid[this.ManifoldDimension - 1][i])) {
                base = -1;
            } else {
                l[this.ManifoldDimension - 1] = (int)(grid[this.ManifoldDimension - 1][i] + 0.5);
                if (l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n = this.ManifoldDimension - 1;
                    l[n] = l[n] - 1;
                }
                c[this.ManifoldDimension - 1] = grid[this.ManifoldDimension - 1][i] - (double)l[this.ManifoldDimension - 1];
                if (!(l[this.ManifoldDimension - 1] == 0 && c[this.ManifoldDimension - 1] <= 0.0 || l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && c[this.ManifoldDimension - 1] >= 0.0)) {
                    length_is *= 2;
                }
                base = l[this.ManifoldDimension - 1];
            }
            for (j = this.ManifoldDimension - 2; j >= 0 && base >= 0; --j) {
                if (Double.isNaN(grid[j][i])) {
                    base = -1;
                    continue;
                }
                l[j] = (int)(grid[j][i] + 0.5);
                if (l[j] == this.Lengths[j]) {
                    int n = j;
                    l[n] = l[n] - 1;
                }
                c[j] = grid[j][i] - (double)l[j];
                if (!(l[j] == 0 && c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c[j] >= 0.0)) {
                    length_is *= 2;
                }
                base = l[j] + this.Lengths[j] * base;
            }
            if (base < 0) {
                is = null;
                cs = null;
            } else {
                is = new int[length_is];
                cs = new double[length_is];
                is[0] = base;
                cs[0] = 1.0;
                int lis = 1;
                for (j = 0; j < this.ManifoldDimension; ++j) {
                    double b;
                    double a;
                    int isoff;
                    if (l[j] == 0 && c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c[j] >= 0.0) continue;
                    if (c[j] >= 0.0) {
                        isoff = off[j];
                        a = 1.0 - c[j];
                        b = c[j];
                    } else {
                        isoff = -off[j];
                        a = 1.0 + c[j];
                        b = -c[j];
                    }
                    int k = 0;
                    while (k < lis) {
                        is[k + lis] = is[k] + isoff;
                        cs[k + lis] = cs[k] * b;
                        int n = k++;
                        cs[n] = cs[n] * a;
                    }
                    lis *= 2;
                }
            }
            indices[i] = is;
            weights[i] = cs;
        }
    }

    public double getDoubleLowX() {
        return this.LowX;
    }

    public double getDoubleHiX() {
        return this.HiX;
    }

    void init_doubles(double[][] samples, boolean copy) throws VisADException {
        if (samples.length != this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.init_doubles: samples dimension " + samples.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Length == 0) {
            this.Length = samples[0].length;
        } else if (this.Length != samples[0].length) {
            throw new SetException("Gridded1DDoubleSet.init_doubles: samples[0] length " + samples[0].length + " doesn't match expected length " + this.Length);
        }
        this.Samples = copy ? new double[this.DomainDimension][this.Length] : samples;
        for (int j = 0; j < this.DomainDimension; ++j) {
            if (samples[j].length != this.Length) {
                throw new SetException("Gridded1DDoubleSet.init_doubles: samples[" + j + "] length " + samples[0].length + " doesn't match expected length " + this.Length);
            }
            double[] samplesJ = samples[j];
            double[] SamplesJ = this.Samples[j];
            if (copy) {
                System.arraycopy(samplesJ, 0, SamplesJ, 0, this.Length);
            }
            this.Low[j] = Double.POSITIVE_INFINITY;
            this.Hi[j] = Double.NEGATIVE_INFINITY;
            double sum = 0.0;
            for (int i = 0; i < this.Length; ++i) {
                if (SamplesJ[i] == SamplesJ[i] && !Double.isInfinite(SamplesJ[i])) {
                    if (SamplesJ[i] < this.Low[j]) {
                        this.Low[j] = SamplesJ[i];
                    }
                    if (SamplesJ[i] > this.Hi[j]) {
                        this.Hi[j] = SamplesJ[i];
                    }
                } else {
                    SamplesJ[i] = Double.NaN;
                }
                sum += SamplesJ[i];
            }
            if (this.SetErrors[j] != null) {
                this.SetErrors[j] = new ErrorEstimate(this.SetErrors[j].getErrorValue(), sum / (double)this.Length, this.Length, this.SetErrors[j].getUnit());
            }
            ((Gridded1DSet)this).Low[j] = (float)this.Low[j];
            ((Gridded1DSet)this).Hi[j] = (float)this.Hi[j];
        }
    }

    @Override
    public void cram_missing(boolean[] range_select) {
        int n = Math.min(range_select.length, this.Samples[0].length);
        for (int i = 0; i < n; ++i) {
            if (range_select[i]) continue;
            this.Samples[0][i] = Double.NaN;
        }
    }

    @Override
    public boolean isMissing() {
        return this.Samples == null;
    }

    @Override
    public boolean equals(Object set) {
        if (!(set instanceof Gridded1DDoubleSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (this.testNotEqualsCache((Set)set)) {
            return false;
        }
        if (this.testEqualsCache((Set)set)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        try {
            int j;
            if (this.DomainDimension != ((Gridded1DDoubleSet)set).getDimension() || this.ManifoldDimension != ((Gridded1DDoubleSet)set).getManifoldDimension() || this.Length != ((Gridded1DDoubleSet)set).getLength()) {
                return false;
            }
            for (j = 0; j < this.ManifoldDimension; ++j) {
                if (this.Lengths[j] == ((Gridded1DDoubleSet)set).getLength(j)) continue;
                return false;
            }
            double[][] samples = ((Gridded1DDoubleSet)set).getDoubles(false);
            if (this.Samples != null && samples != null) {
                for (j = 0; j < this.DomainDimension; ++j) {
                    for (int i = 0; i < this.Length; ++i) {
                        if (this.Samples[j][i] == samples[j][i]) continue;
                        this.addNotEqualsCache((Set)set);
                        return false;
                    }
                }
            } else {
                double[][] this_samples = this.getDoubles(false);
                if (this_samples == null) {
                    if (samples != null) {
                        return false;
                    }
                } else {
                    if (samples == null) {
                        return false;
                    }
                    for (j = 0; j < this.DomainDimension; ++j) {
                        for (int i = 0; i < this.Length; ++i) {
                            if (this_samples[j][i] == samples[j][i]) continue;
                            this.addNotEqualsCache((Set)set);
                            return false;
                        }
                    }
                }
            }
            this.addEqualsCache((Set)set);
            return true;
        }
        catch (VisADException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        if (!this.hashCodeSet) {
            int j;
            this.hashCode = this.unitAndCSHashCode();
            this.hashCode ^= this.DomainDimension ^ this.ManifoldDimension ^ this.Length;
            for (j = 0; j < this.ManifoldDimension; ++j) {
                this.hashCode ^= this.Lengths[j];
            }
            if (this.Samples != null) {
                for (j = 0; j < this.DomainDimension; ++j) {
                    for (int i = 0; i < this.Length; ++i) {
                        this.hashCode ^= new Double(this.Samples[j][i]).hashCode();
                    }
                }
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    @Override
    public Object clone() {
        Gridded1DDoubleSet clone = (Gridded1DDoubleSet)super.clone();
        if (this.Samples != null) {
            clone.Samples = (double[][])this.Samples.clone();
            for (int i = 0; i < this.Samples.length; ++i) {
                clone.Samples[i] = (double[])this.Samples[i].clone();
            }
        }
        return clone;
    }

    @Override
    public Object cloneButType(MathType type) throws VisADException {
        return new Gridded1DDoubleSet(type, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }
}

