/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class CylindricalCoordinateSystem
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{null, CommonUnit.degree, null};

    public CylindricalCoordinateSystem(RealTupleType reference) throws VisADException {
        super(reference, coordinate_system_units);
    }

    CylindricalCoordinateSystem(RealTupleType reference, boolean b) {
        super(reference, coordinate_system_units, b);
    }

    @Override
    public double[][] toReference(double[][] tuples) throws CoordinateSystemException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("CylindricalCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[3][len];
        for (int i = 0; i < len; ++i) {
            if (tuples[0][i] < 0.0) {
                value[0][i] = Double.NaN;
                value[1][i] = Double.NaN;
                value[2][i] = Double.NaN;
                continue;
            }
            double cosaz = Math.cos(Math.PI / 180 * tuples[1][i]);
            double sinaz = Math.sin(Math.PI / 180 * tuples[1][i]);
            value[0][i] = tuples[0][i] * cosaz;
            value[1][i] = tuples[0][i] * sinaz;
            value[2][i] = tuples[2][i];
        }
        return value;
    }

    @Override
    public double[][] fromReference(double[][] tuples) throws CoordinateSystemException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("CylindricalCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[3][len];
        for (int i = 0; i < len; ++i) {
            value[0][i] = Math.sqrt(tuples[0][i] * tuples[0][i] + tuples[1][i] * tuples[1][i]);
            value[1][i] = 57.29577951308232 * Math.atan2(tuples[1][i], tuples[0][i]);
            if (value[1][i] < 0.0) {
                double[] dArray = value[1];
                int n = i;
                dArray[n] = dArray[n] + 360.0;
            }
            value[2][i] = tuples[2][i];
        }
        return value;
    }

    @Override
    public float[][] toReference(float[][] tuples) throws CoordinateSystemException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("CylindricalCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[3][len];
        for (int i = 0; i < len; ++i) {
            if ((double)tuples[0][i] < 0.0) {
                value[0][i] = Float.NaN;
                value[1][i] = Float.NaN;
                value[2][i] = Float.NaN;
                continue;
            }
            float cosaz = (float)Math.cos(Math.PI / 180 * (double)tuples[1][i]);
            float sinaz = (float)Math.sin(Math.PI / 180 * (double)tuples[1][i]);
            value[0][i] = tuples[0][i] * cosaz;
            value[1][i] = tuples[0][i] * sinaz;
            value[2][i] = tuples[2][i];
        }
        return value;
    }

    @Override
    public float[][] fromReference(float[][] tuples) throws CoordinateSystemException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("CylindricalCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[3][len];
        for (int i = 0; i < len; ++i) {
            value[0][i] = (float)Math.sqrt(tuples[0][i] * tuples[0][i] + tuples[1][i] * tuples[1][i]);
            value[1][i] = (float)(57.29577951308232 * Math.atan2(tuples[1][i], tuples[0][i]));
            if (value[1][i] < 0.0f) {
                float[] fArray = value[1];
                int n = i;
                fArray[n] = fArray[n] + 360.0f;
            }
            value[2][i] = tuples[2][i];
        }
        return value;
    }

    @Override
    public boolean equals(Object cs) {
        return cs instanceof CylindricalCoordinateSystem;
    }
}

