/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

public class AddeURL
implements Cloneable {
    public static final String ADDE_PROTOCOL = "adde";
    public static final String REQ_AGET = "aget";
    public static final String REQ_ADIR = "adir";
    public static final String REQ_LWPR = "lwpr";
    public static final String REQ_GDIR = "gdir";
    public static final String REQ_GGET = "gget";
    public static final String REQ_MDKS = "mdks";
    public static final String REQ_TXTG = "txtg";
    public static final String REQ_WTXG = "wtxg";
    public static final String REQ_OBTG = "obtg";
    public static final String REQ_IMAGEDATA = "imagedata";
    public static final String REQ_IMAGEDIR = "imagedirectory";
    public static final String REQ_DATASETINFO = "datasetinfo";
    public static final String REQ_TEXT = "text";
    public static final String REQ_WXTEXT = "wxtext";
    public static final String REQ_OBTEXT = "obtext";
    public static final String REQ_GRIDDATA = "griddata";
    public static final String REQ_GRIDDIR = "griddir";
    public static final String REQ_POINTDATA = "point";
    public static final String DEFAULT_VALUE = "X";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String ALL = "ALL";
    public static final String KEY_TRACE = "TRACE";
    public static final String KEY_DEBUG = "DEBUG";
    public static final String KEY_PORT = "PORT";
    public static final String KEY_PROJ = "PROJ";
    public static final String KEY_USER = "USER";
    public static final String KEY_COMPRESS = "COMPRESS";
    public static final String KEY_VERSION = "VERSION";
    public static final int COMPRESS = 503;
    public static final int NO_COMPRESS = 500;
    public static final int GZIP = 112;
    public static final int TRACE_ON = 0;
    public static final int TRACE_OFF = 1;
    private String host = "localhost";
    private String version = "1";
    private String user = "XXXX";
    private int project = 0;
    private int trace = 0;
    private String extraKeys = null;
    private int compress = -1;
    private int port = 112;
    private String requestType = "";
    private boolean debug = false;

    public AddeURL() {
    }

    public AddeURL(String host, String requestType) {
        this(host, requestType, null);
    }

    public AddeURL(String host, String requestType, String extraKeys) {
        this.host = host;
        this.requestType = requestType;
        this.extraKeys = extraKeys;
    }

    public String getURLString() {
        StringBuffer buf = new StringBuffer(ADDE_PROTOCOL);
        buf.append("://");
        buf.append(this.host);
        buf.append("/");
        buf.append(this.requestType);
        buf.append("?");
        buf.append(this.makeQuery());
        return buf.toString();
    }

    protected String makeQuery() {
        StringBuffer buf = new StringBuffer();
        this.appendKeyValue(buf, KEY_PORT, "" + this.getPort());
        this.appendKeyValue(buf, KEY_COMPRESS, this.getCompressionType());
        this.appendKeyValue(buf, KEY_USER, this.getUser());
        this.appendKeyValue(buf, KEY_PROJ, "" + this.getProject());
        this.appendKeyValue(buf, KEY_VERSION, this.getVersion());
        this.appendKeyValue(buf, KEY_DEBUG, Boolean.toString(this.getDebug()));
        this.appendKeyValue(buf, KEY_TRACE, "" + this.getTrace());
        if (this.getExtraKeys() != null) {
            if (!this.getExtraKeys().startsWith("&")) {
                buf.append("&");
            }
            buf.append(this.getExtraKeys());
        }
        return buf.toString();
    }

    protected void parseQuery(String query) {
        String test = this.getValue(query, KEY_PORT);
        if (test != null) {
            this.setPort(Integer.parseInt(test));
        }
        if ((test = this.getValue(query, KEY_COMPRESS)) != null) {
            this.setCompressionFromString(test);
        }
        if ((test = this.getValue(query, KEY_USER)) != null) {
            this.setUser(test);
        }
        if ((test = this.getValue(query, KEY_PROJ)) != null) {
            this.setProject(Integer.parseInt(test));
        }
        if ((test = this.getValue(query, KEY_VERSION)) != null) {
            this.setVersion(test);
        }
        if ((test = this.getValue(query, KEY_DEBUG)) != null) {
            this.setDebug(test.equals("true"));
        }
        if ((test = this.getValue(query, KEY_TRACE)) != null) {
            this.setTrace(Integer.parseInt(test));
        }
    }

    public String getValue(String query, String key) {
        String retVal = null;
        int keyIndex = query.indexOf(key);
        if (keyIndex < 0) {
            keyIndex = query.indexOf(key.toLowerCase());
        }
        if (keyIndex >= 0) {
            int equalIndex = query.indexOf("=", keyIndex);
            int ampIndex = query.indexOf("&", keyIndex);
            retVal = ampIndex >= 0 ? query.substring(equalIndex + 1, ampIndex) : query.substring(equalIndex + 1);
        }
        return retVal;
    }

    protected void appendKeyValue(StringBuffer buf, String name, String value) {
        if (buf.length() == 0 || buf.charAt(buf.length() - 1) != '?') {
            buf.append("&");
        }
        buf.append(name);
        buf.append("=");
        buf.append(value);
    }

    public boolean equals(Object o) {
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        AddeURL that = (AddeURL)o;
        if (this == that) {
            return true;
        }
        return this.getURLString().equals(that.getURLString());
    }

    public int hashCode() {
        return this.getURLString().hashCode();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getExtraKeys() {
        return this.extraKeys;
    }

    public void setExtraKeys(String extraKeys) {
        this.extraKeys = extraKeys;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getProject() {
        return this.project;
    }

    public void setProject(int project) {
        this.project = project;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getCompression() {
        return this.compress;
    }

    public void setCompression(int compress) {
        this.compress = compress;
    }

    public int getTrace() {
        return this.trace;
    }

    public void setTrace(int trace) {
        this.trace = trace;
    }

    private String getCompressionType() {
        String testStr = null;
        int valueToCheck = this.compress == -1 ? this.port : this.compress;
        switch (valueToCheck) {
            case 1: 
            case 500: {
                testStr = "none";
                break;
            }
            case 2: 
            case 503: {
                testStr = "compress";
                break;
            }
            default: {
                testStr = "gzip";
            }
        }
        return testStr;
    }

    public void setCompressionFromString(String type) {
        if (type.equals("gzip") || type.equals("112")) {
            this.setCompression(112);
        } else if (type.equals("compress") || type.equals("503")) {
            this.setCompression(503);
        } else if (type.equals("none") || type.equals("500")) {
            this.setCompression(500);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("Assertion failure", ex);
        }
        return clone;
    }
}

