/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class MERCnav
extends AREAnav {
    int iwest;
    int leftlon;
    double xrow;
    double xcol;
    double xlat1;
    double xspace;
    double xqlon;
    double xblat;
    double xblon;

    public MERCnav(int[] iparms) throws IllegalArgumentException {
        if (iparms[0] != 1296388675) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.xrow = iparms[1];
        this.xcol = iparms[2];
        this.xlat1 = McIDASUtil.integerLatLonToDouble(iparms[3]);
        this.xspace = (double)iparms[4] / 1000.0;
        this.xqlon = McIDASUtil.integerLatLonToDouble(iparms[5]);
        double r = (double)iparms[6] / 1000.0;
        this.iwest = iparms[9];
        if (this.iwest >= 0) {
            this.iwest = 1;
        }
        this.xblat = r * Math.cos(this.xlat1 * (Math.PI / 180)) / this.xspace;
        this.xblon = Math.PI / 180 * r / this.xspace;
        this.leftlon = (int)this.xqlon - 180 * this.iwest;
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xldif = this.xrow - imglinele[1][point];
            double xedif = this.xcol - imglinele[0][point];
            double xrlon = (double)this.iwest * xedif / this.xblon;
            double xlon = xrlon + this.xqlon;
            double xrlat = Math.atan(Math.exp(xldif / this.xblat));
            double xlat = (xrlat / (Math.PI / 180) - 45.0) * 2.0 + this.xlat1;
            if (xlon > 360.0 + (double)this.leftlon || xlon < (double)this.leftlon) {
                latlon[0][point] = Double.NaN;
                latlon[1][point] = Double.NaN;
                continue;
            }
            latlon[0][point] = xlat;
            if (xlon > 180.0) {
                xlon -= 360.0;
            }
            if (xlon < -180.0) {
                xlon += 360.0;
            }
            latlon[1][point] = this.iwest == 1 ? -xlon : xlon;
        }
        return latlon;
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double xrlat;
            double xlat = latlon[0][point];
            double xlon = this.iwest == 1 ? -latlon[1][point] : latlon[1][point];
            double xrlon = (double)this.iwest * (xlon - this.xqlon);
            if (xrlon > 180.0) {
                xrlon -= 360.0;
            }
            if (xrlon < -180.0) {
                xrlon += 360.0;
            }
            if (xlat >= 90.0) {
                xlat = 89.99;
            }
            if (xlat <= -90.0) {
                xlat = -89.99;
            }
            if ((xrlat = ((xlat - this.xlat1) / 2.0 + 45.0) * (Math.PI / 180)) <= 0.0) {
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            linele[1][point] = this.xrow - this.xblat * Math.log(Math.tan(xrlat));
            linele[0][point] = this.xcol - xrlon * this.xblon;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public float[][] toLatLon(float[][] linele) {
        int number = linele[0].length;
        float[][] latlon = new float[2][number];
        float[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xldif = this.xrow - (double)imglinele[1][point];
            double xedif = this.xcol - (double)imglinele[0][point];
            double xrlon = (double)this.iwest * xedif / this.xblon;
            double xlon = xrlon + this.xqlon;
            double xrlat = Math.atan(Math.exp(xldif / this.xblat));
            double xlat = (xrlat / (Math.PI / 180) - 45.0) * 2.0 + this.xlat1;
            if (xlon > 360.0 + (double)this.leftlon || xlon < (double)this.leftlon) {
                latlon[0][point] = Float.NaN;
                latlon[1][point] = Float.NaN;
                continue;
            }
            latlon[0][point] = (float)xlat;
            if (xlon > 180.0) {
                xlon -= 360.0;
            }
            if (xlon < -180.0) {
                xlon += 360.0;
            }
            latlon[1][point] = (float)(this.iwest == 1 ? -xlon : xlon);
        }
        return latlon;
    }

    @Override
    public float[][] toLinEle(float[][] latlon) {
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        for (int point = 0; point < number; ++point) {
            double xrlat;
            double xlat = latlon[0][point];
            double xlon = this.iwest == 1 ? (double)(-latlon[1][point]) : (double)latlon[1][point];
            double xrlon = (double)this.iwest * (xlon - this.xqlon);
            if (xrlon > 180.0) {
                xrlon -= 360.0;
            }
            if (xrlon < -180.0) {
                xrlon += 360.0;
            }
            if (xlat >= 90.0) {
                xlat = 89.99;
            }
            if (xlat <= -90.0) {
                xlat = -89.99;
            }
            if ((xrlat = ((xlat - this.xlat1) / 2.0 + 45.0) * (Math.PI / 180)) <= 0.0) {
                linele[1][point] = Float.NaN;
                linele[0][point] = Float.NaN;
                continue;
            }
            linele[1][point] = (float)(this.xrow - this.xblat * Math.log(Math.tan(xrlat)));
            linele[0][point] = (float)(this.xcol - xrlon * this.xblon);
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }
}

