/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;

public class ABINnav
extends AREAnav {
    private static final double dh = 42164.16;
    private static final double deg_to_rad = Math.PI / 180;
    private static final double r_eq = 6378.137;
    private static final double dreq2 = 4.068063159076899E7;
    private static final double drpo = 6356.7523;
    private static final double drpo2 = 4.0408299803555295E7;
    private static final double r_eq2 = 4.068063159076899E7;
    private static final double d = 1.7371357569148312E9;
    private static final double FP = 1.006803;
    private boolean isEastPositive = true;
    private int itype = 1;
    private double loff;
    private double coff;
    private double lfac;
    private double cfac;
    private double plon;
    private double bres;

    public ABINnav(int[] navblock) {
        if (navblock[0] != 1094863182) {
            throw new IllegalArgumentException("Invalid navigation type: " + navblock[0]);
        }
        this.loff = (double)navblock[1] / 1.0E8;
        this.coff = (double)navblock[2] / 1.0E8;
        this.lfac = (double)navblock[3] / 1.0E8;
        this.cfac = (double)navblock[4] / 1.0E8;
        this.plon = (double)navblock[5] / 10.0;
        this.bres = navblock[6];
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        double sub_lon_radians = this.plon * (Math.PI / 180);
        int length = linele[1].length;
        double[][] latLons = new double[2][length];
        double[][] imageLineElems = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < length; ++point) {
            double xlon;
            double xlat;
            double rlin = imageLineElems[1][point];
            double rele = imageLineElems[0][point];
            double xlin = 0.0;
            double xele = 0.0;
            double lamda_goes = 0.0;
            double theta_goes = 0.0;
            double lamda_geos = 0.0;
            double theta_geos = 0.0;
            double cosx = 0.0;
            double cosy = 0.0;
            double sinx = 0.0;
            double siny = 0.0;
            double c1 = 0.0;
            double c2 = 0.0;
            double sd = 0.0;
            double sdd = 0.0;
            double sn = 0.0;
            double s1 = 0.0;
            double s2 = 0.0;
            double s3 = 0.0;
            double sxy = 0.0;
            xlin = (rlin + this.bres - 1.0) / this.bres;
            xele = (rele + this.bres - 1.0) / this.bres;
            theta_goes = xlin * this.lfac + this.loff;
            lamda_goes = xele * this.cfac + this.coff;
            theta_geos = Math.asin(Math.sin(theta_goes) * Math.cos(lamda_goes));
            lamda_geos = Math.atan(Math.tan(lamda_goes) / Math.cos(theta_goes));
            cosx = Math.cos(lamda_geos);
            cosy = Math.cos(theta_geos);
            sinx = Math.sin(lamda_geos);
            c1 = 42164.16 * cosx * cosy * 42164.16 * cosx * cosy;
            siny = Math.sin(theta_geos);
            c2 = (cosy * cosy + 1.006803 * siny * siny) * 1.7371357569148312E9;
            sdd = c1 - c2;
            if (sdd < 0.0) {
                xlat = Double.NaN;
                xlon = Double.NaN;
            } else {
                sd = Math.sqrt(sdd);
                sn = (42164.16 * cosx * cosy - sd) / (cosy * cosy + 1.006803 * siny * siny);
                s1 = 42164.16 - sn * cosx * cosy;
                s2 = sn * sinx * cosy;
                s3 = -(sn * siny);
                sxy = Math.sqrt(s1 * s1 + s2 * s2);
                xlon = Math.atan(s2 / s1) + sub_lon_radians;
                xlat = Math.atan(-(1.006803 * s3 / sxy));
                xlon *= 57.29577951308232;
                xlat *= 57.29577951308232;
                if (xlon > 180.0) {
                    xlon -= 360.0;
                }
                if (xlon < -180.0) {
                    xlon += 360.0;
                }
            }
            latLons[0][point] = xlat;
            latLons[1][point] = xlon;
        }
        return latLons;
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        double d_geographic_ssl = this.plon * (Math.PI / 180);
        int length = latlon[0].length;
        double[][] lineEles = new double[2][length];
        for (int point = 0; point < length; ++point) {
            double xele;
            double xlin;
            double rlat = latlon[0][point];
            double rlon = latlon[1][point];
            if (!this.isEastPositive) {
                rlon = -rlon;
            }
            double rlin = 0.0;
            double rele = 0.0;
            double d_geographic_lat = 0.0;
            double d_geocentric_lat = 0.0;
            double d_geographic_lon = 0.0;
            double r_earth = 0.0;
            double r_1 = 0.0;
            double r_2 = 0.0;
            double r_3 = 0.0;
            double lamda = 0.0;
            double theta = 0.0;
            d_geographic_lat = rlat * (Math.PI / 180);
            d_geographic_lon = rlon * (Math.PI / 180);
            d_geocentric_lat = Math.atan(0.9933056155579577 * Math.tan(d_geographic_lat));
            r_earth = 6356.7523 / Math.sqrt(1.0 - 0.006694384442042289 * Math.cos(d_geocentric_lat) * Math.cos(d_geocentric_lat));
            r_1 = 42164.16 - r_earth * Math.cos(d_geocentric_lat) * Math.cos(d_geographic_lon - d_geographic_ssl);
            r_2 = -(r_earth * Math.cos(d_geocentric_lat) * Math.sin(d_geographic_lon - d_geographic_ssl));
            r_3 = r_earth * Math.sin(d_geocentric_lat);
            if (r_1 > 42164.16) {
                xlin = Double.NaN;
                xele = Double.NaN;
            } else {
                lamda = Math.asin(-(r_2 / Math.sqrt(r_1 * r_1 + r_2 * r_2 + r_3 * r_3)));
                theta = Math.atan(r_3 / r_1);
                rlin = (theta - this.loff) / this.lfac;
                rele = (lamda - this.coff) / this.cfac;
                xlin = rlin * this.bres - (this.bres - 1.0);
                xele = rele * this.bres - (this.bres - 1.0);
            }
            lineEles[1][point] = xlin;
            lineEles[0][point] = xele;
        }
        return this.imageCoordToAreaCoord(lineEles, lineEles);
    }
}

