/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.WrapperObjectMatrix2D;

public class SparseRCMObjectMatrix2D
extends WrapperObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseObjectMatrix1D[] elements;

    public SparseRCMObjectMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseObjectMatrix1D[rows];
        for (int i = 0; i < rows; ++i) {
            this.elements[i] = new SparseObjectMatrix1D(columns);
        }
    }

    public SparseObjectMatrix1D[] elements() {
        return this.elements;
    }

    @Override
    public Object getQuick(int row, int column) {
        return this.elements[row].getQuick(column);
    }

    @Override
    public void setQuick(int row, int column, Object value) {
        this.elements[row].setQuick(column, value);
    }

    @Override
    public void trimToSize() {
        for (int r = 0; r < this.rows; ++r) {
            this.elements[r].trimToSize();
        }
    }

    @Override
    public SparseObjectMatrix1D viewRow(int row) {
        return this.elements[row];
    }

    @Override
    protected ObjectMatrix2D getContent() {
        return this;
    }

    @Override
    public ObjectMatrix2D like(int rows, int columns) {
        return new SparseRCMObjectMatrix2D(rows, columns);
    }
}

