/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SelectedDenseLongMatrix3D;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseLongMatrix3D
extends LongMatrix3D {
    private static final long serialVersionUID = 1L;
    protected long[] elements;

    public DenseLongMatrix3D(long[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public DenseLongMatrix3D(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns);
        this.elements = new long[slices * rows * columns];
    }

    public DenseLongMatrix3D(int slices, int rows, int columns, long[] elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride, boolean isView) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    @Override
    public long aggregate(final LongLongFunction aggr, final LongFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = 0L;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(DenseLongMatrix3D.this.elements[zero + firstSlice * DenseLongMatrix3D.this.sliceStride]);
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                for (int c = d; c < DenseLongMatrix3D.this.columns; ++c) {
                                    a = aggr.apply(a, f.apply(DenseLongMatrix3D.this.elements[zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride + c * DenseLongMatrix3D.this.columnStride]));
                                }
                                d = 0;
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero]);
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        a = aggr.apply(a, f.apply(this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride]));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    @Override
    public long aggregate(final LongLongFunction aggr, final LongFunction f, final LongProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = 0L;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long elem = DenseLongMatrix3D.this.elements[zero + firstSlice * DenseLongMatrix3D.this.sliceStride];
                        long a = 0L;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                for (int c = d; c < DenseLongMatrix3D.this.columns; ++c) {
                                    elem = DenseLongMatrix3D.this.elements[zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride + c * DenseLongMatrix3D.this.columnStride];
                                    if (cond.apply(elem)) {
                                        a = aggr.apply(a, f.apply(elem));
                                    }
                                    d = 0;
                                }
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            long elem = this.elements[zero];
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        d = 0;
                    }
                }
            }
        }
        return a;
    }

    @Override
    public long aggregate(final LongLongFunction aggr, final LongFunction f, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        if (sliceList.size() == 0 || rowList.size() == 0 || columnList.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final int zero = (int)this.index(0, 0, 0);
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(DenseLongMatrix3D.this.elements[zero + sliceElements[firstIdx] * DenseLongMatrix3D.this.sliceStride + rowElements[firstIdx] * DenseLongMatrix3D.this.rowStride + columnElements[firstIdx] * DenseLongMatrix3D.this.columnStride]);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            long elem = DenseLongMatrix3D.this.elements[zero + sliceElements[i] * DenseLongMatrix3D.this.sliceStride + rowElements[i] * DenseLongMatrix3D.this.rowStride + columnElements[i] * DenseLongMatrix3D.this.columnStride];
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + sliceElements[0] * this.sliceStride + rowElements[0] * this.rowStride + columnElements[0] * this.columnStride]);
            for (int i = 1; i < size; ++i) {
                long elem = this.elements[zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride];
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    @Override
    public long aggregate(LongMatrix3D other, final LongLongFunction aggr, final LongLongFunction f) {
        if (!(other instanceof DenseLongMatrix3D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = 0L;
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final long[] elemsOther = (long[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int idx = zero + firstSlice * DenseLongMatrix3D.this.sliceStride;
                        int idxOther = zeroOther + firstSlice * sliceStrideOther;
                        long a = f.apply(DenseLongMatrix3D.this.elements[idx], elemsOther[idxOther]);
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                for (int c = d; c < DenseLongMatrix3D.this.columns; ++c) {
                                    idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride + c * DenseLongMatrix3D.this.columnStride;
                                    idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                                    a = aggr.apply(a, f.apply(DenseLongMatrix3D.this.elements[idx], elemsOther[idxOther]));
                                }
                                d = 0;
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                        a = aggr.apply(a, f.apply(this.elements[idx], elemsOther[idxOther]));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    @Override
    public LongMatrix3D assign(final LongFunction function) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                    DenseLongMatrix3D.this.elements[idx] = function.apply(DenseLongMatrix3D.this.elements[idx]);
                                    idx += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx] = function.apply(this.elements[idx]);
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final long value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                    DenseLongMatrix3D.this.elements[idx] = value;
                                    idx += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx] = value;
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final long[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstSlice * DenseLongMatrix3D.this.rows * DenseLongMatrix3D.this.columns;
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                    for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                        DenseLongMatrix3D.this.elements[idx] = values[idxOther++];
                                        idx += DenseLongMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                for (int s = 0; s < this.slices; ++s) {
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        for (int c = 0; c < this.columns; ++c) {
                            this.elements[idx] = values[idxOther++];
                            idx += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final int[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idxOther = firstSlice * DenseLongMatrix3D.this.rows * DenseLongMatrix3D.this.columns;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                    DenseLongMatrix3D.this.elements[idx] = values[idxOther++];
                                    idx += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxOther = 0;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx] = values[idxOther++];
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final long[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstSlice * DenseLongMatrix3D.this.sliceStride;
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                long[][] currentSlice = values[s];
                                if (currentSlice.length != DenseLongMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseLongMatrix3D.this.rows());
                                }
                                for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                    long[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseLongMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseLongMatrix3D.this.columns());
                                    }
                                    System.arraycopy(currentRow, 0, DenseLongMatrix3D.this.elements, i, DenseLongMatrix3D.this.columns);
                                    i += DenseLongMatrix3D.this.columns;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                for (int s = 0; s < this.slices; ++s) {
                    long[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    for (int r = 0; r < this.rows; ++r) {
                        long[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                        i += this.columns;
                    }
                }
            }
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                long[][] currentSlice = values[s];
                                if (currentSlice.length != DenseLongMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseLongMatrix3D.this.rows());
                                }
                                for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                    int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                    long[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseLongMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseLongMatrix3D.this.columns());
                                    }
                                    for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                        DenseLongMatrix3D.this.elements[idx] = currentRow[c];
                                        idx += DenseLongMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int s = 0; s < this.slices; ++s) {
                    long[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    for (int r = 0; r < this.rows; ++r) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        long[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        for (int c = 0; c < this.columns; ++c) {
                            this.elements[idx] = currentRow[c];
                            idx += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final LongProcedure cond, final LongFunction f) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                    long elem = DenseLongMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseLongMatrix3D.this.elements[idx] = f.apply(elem);
                                    }
                                    idx += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        long elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = f.apply(elem);
                        }
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(final LongProcedure cond, final long value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                    long elem = DenseLongMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseLongMatrix3D.this.elements[idx] = value;
                                    }
                                    idx += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        long elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = value;
                        }
                        idx += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(LongMatrix3D source) {
        if (!(source instanceof DenseLongMatrix3D)) {
            super.assign(source);
            return this;
        }
        DenseLongMatrix3D other = (DenseLongMatrix3D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            LongMatrix3D c = other.copy();
            if (!(c instanceof DenseLongMatrix3D)) {
                super.assign(source);
                return this;
            }
            other = (DenseLongMatrix3D)c;
        }
        DenseLongMatrix3D other_final = other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other_final.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other_final.index(0, 0, 0);
        final int sliceStrideOther = other_final.sliceStride;
        final int rowStrideOther = other_final.rowStride;
        final int columnStrideOther = other_final.columnStride;
        final long[] elemsOther = other_final.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                    DenseLongMatrix3D.this.elements[idx] = elemsOther[idxOther];
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx] = elemsOther[idxOther];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(LongMatrix3D y, final LongLongFunction function) {
        if (!(y instanceof DenseLongMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final long[] elemsOther = (long[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                    DenseLongMatrix3D.this.elements[idx] = function.apply(DenseLongMatrix3D.this.elements[idx], elemsOther[idxOther]);
                                    idx += DenseLongMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix3D assign(LongMatrix3D y, final LongLongFunction function, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (!(y instanceof DenseLongMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final long[] elemsOther = (long[])y.elements();
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int idx = zero + sliceElements[i] * DenseLongMatrix3D.this.sliceStride + rowElements[i] * DenseLongMatrix3D.this.rowStride + columnElements[i] * DenseLongMatrix3D.this.columnStride;
                            int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseLongMatrix3D.this.elements[idx] = function.apply(DenseLongMatrix3D.this.elements[idx], elemsOther[idxOther]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                int idx = zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                    if (DenseLongMatrix3D.this.elements[idx] != 0L) {
                                        ++cardinality;
                                    }
                                    idx += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        if (this.elements[idx] != 0L) {
                            ++cardinality;
                        }
                        idx += this.columnStride;
                    }
                }
            }
        }
        return cardinality;
    }

    public long[] elements() {
        return this.elements;
    }

    @Override
    public void getNegativeValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        for (int s = 0; s < this.slices; ++s) {
            for (int r = 0; r < this.rows; ++r) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                for (int c = 0; c < this.columns; ++c) {
                    long value = this.elements[idx];
                    if (value < 0L) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                }
            }
        }
    }

    @Override
    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        for (int s = 0; s < this.slices; ++s) {
            for (int r = 0; r < this.rows; ++r) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                for (int c = 0; c < this.columns; ++c) {
                    long value = this.elements[idx];
                    if (value != 0L) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                }
            }
        }
    }

    @Override
    public void getPositiveValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        for (int s = 0; s < this.slices; ++s) {
            for (int r = 0; r < this.rows; ++r) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                for (int c = 0; c < this.columns; ++c) {
                    long value = this.elements[idx];
                    if (value > 0L) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                }
            }
        }
    }

    @Override
    public long getQuick(int slice, int row, int column) {
        return this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    @Override
    public long index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public LongMatrix3D like(int slices, int rows, int columns) {
        return new DenseLongMatrix3D(slices, rows, columns);
    }

    @Override
    public LongMatrix2D like2D(int rows, int columns) {
        return new DenseLongMatrix2D(rows, columns);
    }

    @Override
    public long[] getMaxLocation() {
        final int zero = (int)this.index(0, 0, 0);
        int slice_loc = 0;
        int row_loc = 0;
        int col_loc = 0;
        long maxValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int slice_loc = firstSlice;
                        int row_loc = 0;
                        int col_loc = 0;
                        long maxValue = DenseLongMatrix3D.this.elements[zero + firstSlice * DenseLongMatrix3D.this.sliceStride];
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                for (int c = d; c < DenseLongMatrix3D.this.columns; ++c) {
                                    long elem = DenseLongMatrix3D.this.elements[zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride + c * DenseLongMatrix3D.this.columnStride];
                                    if (maxValue >= elem) continue;
                                    maxValue = elem;
                                    slice_loc = s;
                                    row_loc = r;
                                    col_loc = c;
                                }
                                d = 0;
                            }
                        }
                        return new long[]{maxValue, slice_loc, row_loc, col_loc};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (long[])futures[j].get();
                }
                maxValue = results[0][0];
                slice_loc = (int)results[0][1];
                row_loc = (int)results[0][2];
                col_loc = (int)results[0][3];
                for (j = 1; j < nthreads; ++j) {
                    if (maxValue >= results[j][0]) continue;
                    maxValue = results[j][0];
                    slice_loc = (int)results[j][1];
                    row_loc = (int)results[j][2];
                    col_loc = (int)results[j][3];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero];
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        long elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (maxValue >= elem) continue;
                        maxValue = elem;
                        slice_loc = s;
                        row_loc = r;
                        col_loc = c;
                    }
                    d = 0;
                }
            }
        }
        return new long[]{maxValue, slice_loc, row_loc, col_loc};
    }

    @Override
    public long[] getMinLocation() {
        final int zero = (int)this.index(0, 0, 0);
        int slice_loc = 0;
        int row_loc = 0;
        int col_loc = 0;
        long minValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int slice_loc = firstSlice;
                        int row_loc = 0;
                        int col_loc = 0;
                        long minValue = DenseLongMatrix3D.this.elements[zero + slice_loc * DenseLongMatrix3D.this.sliceStride];
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                for (int c = d; c < DenseLongMatrix3D.this.columns; ++c) {
                                    long elem = DenseLongMatrix3D.this.elements[zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride + c * DenseLongMatrix3D.this.columnStride];
                                    if (minValue <= elem) continue;
                                    minValue = elem;
                                    slice_loc = s;
                                    row_loc = r;
                                    col_loc = c;
                                }
                                d = 0;
                            }
                        }
                        return new long[]{minValue, slice_loc, row_loc, col_loc};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (long[])futures[j].get();
                }
                minValue = results[0][0];
                slice_loc = (int)results[0][1];
                row_loc = (int)results[0][2];
                col_loc = (int)results[0][3];
                for (j = 1; j < nthreads; ++j) {
                    if (minValue <= results[j][0]) continue;
                    minValue = results[j][0];
                    slice_loc = (int)results[j][1];
                    row_loc = (int)results[j][2];
                    col_loc = (int)results[j][3];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero];
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        long elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (minValue <= elem) continue;
                        minValue = elem;
                        slice_loc = s;
                        row_loc = r;
                        col_loc = c;
                    }
                    d = 0;
                }
            }
        }
        return new long[]{minValue, slice_loc, row_loc, col_loc};
    }

    @Override
    public void setQuick(int slice, int row, int column, long value) {
        this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public long[][][] toArray() {
        final long[][][] values = new long[this.slices][this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            long[][] currentSlice = values[s];
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                long[] currentRow = currentSlice[r];
                                for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                    currentRow[c] = DenseLongMatrix3D.this.elements[idx];
                                    idx += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                long[][] currentSlice = values[s];
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    long[] currentRow = currentSlice[r];
                    for (int c = 0; c < this.columns; ++c) {
                        currentRow[c] = this.elements[idx];
                        idx += this.columnStride;
                    }
                }
            }
        }
        return values;
    }

    @Override
    public LongMatrix1D vectorize() {
        DenseLongMatrix1D v = new DenseLongMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        for (int s = 0; s < this.slices; ++s) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
        }
        return v;
    }

    @Override
    public long zSum() {
        long sum = 0L;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long sum = 0L;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLongMatrix3D.this.rows; ++r) {
                                int idx = zero + s * DenseLongMatrix3D.this.sliceStride + r * DenseLongMatrix3D.this.rowStride;
                                for (int c = 0; c < DenseLongMatrix3D.this.columns; ++c) {
                                    sum += DenseLongMatrix3D.this.elements[idx];
                                    idx += DenseLongMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    sum += ((Long)futures[j].get()).longValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    for (int c = 0; c < this.columns; ++c) {
                        sum += this.elements[idx];
                        idx += this.columnStride;
                    }
                }
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(LongMatrix3D other) {
        if (other instanceof SelectedDenseLongMatrix3D) {
            SelectedDenseLongMatrix3D otherMatrix = (SelectedDenseLongMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseLongMatrix3D) {
            DenseLongMatrix3D otherMatrix = (DenseLongMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected LongMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new DenseLongMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride, true);
    }

    @Override
    protected LongMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseLongMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

