/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.FloatBlas;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class SmpFloatBlas
implements FloatBlas {
    @Override
    public void assign(FloatMatrix2D A, FloatFunction function) {
        A.assign(function);
    }

    @Override
    public void assign(FloatMatrix2D A, FloatMatrix2D B, FloatFloatFunction function) {
        A.assign(B, function);
    }

    @Override
    public float dasum(FloatMatrix1D x) {
        return x.aggregate(FloatFunctions.plus, FloatFunctions.abs);
    }

    @Override
    public void daxpy(float alpha, FloatMatrix1D x, FloatMatrix1D y) {
        y.assign(x, FloatFunctions.plusMultSecond(alpha));
    }

    @Override
    public void daxpy(float alpha, FloatMatrix2D A, FloatMatrix2D B) {
        B.assign(A, FloatFunctions.plusMultSecond(alpha));
    }

    @Override
    public void dcopy(FloatMatrix1D x, FloatMatrix1D y) {
        y.assign(x);
    }

    @Override
    public void dcopy(FloatMatrix2D A, FloatMatrix2D B) {
        B.assign(A);
    }

    @Override
    public float ddot(FloatMatrix1D x, FloatMatrix1D y) {
        return x.zDotProduct(y);
    }

    @Override
    public void dgemm(boolean transposeA, boolean transposeB, float alpha, FloatMatrix2D A, FloatMatrix2D B, float beta, FloatMatrix2D C) {
        A.zMult(B, C, alpha, beta, transposeA, transposeB);
    }

    @Override
    public void dgemv(boolean transposeA, float alpha, FloatMatrix2D A, FloatMatrix1D x, float beta, FloatMatrix1D y) {
        A.zMult(x, y, alpha, beta, transposeA);
    }

    @Override
    public void dger(float alpha, FloatMatrix1D x, FloatMatrix1D y, FloatMatrix2D A) {
        FloatPlusMultSecond fun = FloatPlusMultSecond.plusMult(0.0f);
        int rows = A.rows();
        for (int i = 0; i < rows; ++i) {
            fun.multiplicator = alpha * x.getQuick(i);
            A.viewRow(i).assign(y, fun);
        }
    }

    @Override
    public float dnrm2(FloatMatrix1D x) {
        return DenseFloatAlgebra.DEFAULT.norm2(x);
    }

    @Override
    public void drot(FloatMatrix1D x, FloatMatrix1D y, float c, float s) {
        x.checkSize(y);
        FloatMatrix1D tmp = x.copy();
        x.assign(FloatFunctions.mult(c));
        x.assign(y, FloatFunctions.plusMultSecond(s));
        y.assign(FloatFunctions.mult(c));
        y.assign(tmp, FloatFunctions.minusMult(s));
    }

    @Override
    public void drotg(float a, float b, float[] rotvec) {
        float z;
        float s;
        float c;
        float r;
        float scale;
        float roe = b;
        if (Math.abs(a) > Math.abs(b)) {
            roe = a;
        }
        if ((double)(scale = Math.abs(a) + Math.abs(b)) != 0.0) {
            float ra = a / scale;
            float rb = b / scale;
            r = scale * (float)Math.sqrt(ra * ra + rb * rb);
            r = this.sign(1.0f, roe) * r;
            c = a / r;
            s = b / r;
            z = 1.0f;
            if (Math.abs(a) > Math.abs(b)) {
                z = s;
            }
            if (Math.abs(b) >= Math.abs(a) && (double)c != 0.0) {
                z = 1.0f / c;
            }
        } else {
            c = 1.0f;
            s = 0.0f;
            r = 0.0f;
            z = 0.0f;
        }
        a = r;
        b = z;
        rotvec[0] = a;
        rotvec[1] = b;
        rotvec[2] = c;
        rotvec[3] = s;
    }

    @Override
    public void dscal(float alpha, FloatMatrix1D x) {
        x.assign(FloatFunctions.mult(alpha));
    }

    @Override
    public void dscal(float alpha, FloatMatrix2D A) {
        A.assign(FloatFunctions.mult(alpha));
    }

    @Override
    public void dswap(FloatMatrix1D x, FloatMatrix1D y) {
        y.swap(x);
    }

    @Override
    public void dswap(FloatMatrix2D A, FloatMatrix2D B) {
        A.checkShape(B);
        int rows = A.rows();
        for (int i = 0; i < rows; ++i) {
            A.viewRow(i).swap(B.viewRow(i));
        }
    }

    @Override
    public void dsymv(boolean isUpperTriangular, final float alpha, FloatMatrix2D A, final FloatMatrix1D x, final float beta, final FloatMatrix1D y) {
        final FloatMatrix2D A_loc = isUpperTriangular ? A.viewDice() : A;
        FloatProperty.DEFAULT.checkSquare(A_loc);
        int size = A_loc.rows();
        if ((long)size != x.size() || (long)size != y.size()) {
            throw new IllegalArgumentException(A_loc.toStringShort() + ", " + x.toStringShort() + ", " + y.toStringShort());
        }
        final FloatMatrix1D tmp = x.like();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int j;
                            float sum = 0.0f;
                            for (j = 0; j <= i; ++j) {
                                sum += A_loc.getQuick(i, j) * x.getQuick(j);
                            }
                            for (j = i + 1; j < lastIdx; ++j) {
                                sum += A_loc.getQuick(j, i) * x.getQuick(j);
                            }
                            tmp.setQuick(i, alpha * sum + beta * y.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                int j;
                float sum = 0.0f;
                for (j = 0; j <= i; ++j) {
                    sum += A_loc.getQuick(i, j) * x.getQuick(j);
                }
                for (j = i + 1; j < size; ++j) {
                    sum += A_loc.getQuick(j, i) * x.getQuick(j);
                }
                tmp.setQuick(i, alpha * sum + beta * y.getQuick(i));
            }
        }
        y.assign(tmp);
    }

    @Override
    public void dtrmv(boolean isUpperTriangular, boolean transposeA, boolean isUnitTriangular, FloatMatrix2D A, final FloatMatrix1D x) {
        boolean isUpperTriangular_loc;
        FloatMatrix2D A_loc;
        if (transposeA) {
            A_loc = A.viewDice();
            isUpperTriangular_loc = !isUpperTriangular;
        } else {
            A_loc = A;
            isUpperTriangular_loc = isUpperTriangular;
        }
        FloatProperty.DEFAULT.checkSquare(A_loc);
        int size = A_loc.rows();
        if ((long)size != x.size()) {
            throw new IllegalArgumentException(A_loc.toStringShort() + ", " + x.toStringShort());
        }
        final FloatMatrix1D b = x.like();
        final FloatMatrix1D y = x.like();
        if (isUnitTriangular) {
            y.assign(1.0f);
        } else {
            for (int i = 0; i < size; ++i) {
                y.setQuick(i, A_loc.getQuick(i, i));
            }
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int j;
                            float sum = 0.0f;
                            if (!isUpperTriangular_loc) {
                                for (j = 0; j < i; ++j) {
                                    sum += A_loc.getQuick(i, j) * x.getQuick(j);
                                }
                                sum += y.getQuick(i) * x.getQuick(i);
                            } else {
                                sum += y.getQuick(i) * x.getQuick(i);
                                for (j = i + 1; j < lastIdx; ++j) {
                                    sum += A_loc.getQuick(i, j) * x.getQuick(j);
                                }
                            }
                            b.setQuick(i, sum);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                int j;
                float sum = 0.0f;
                if (!isUpperTriangular_loc) {
                    for (j = 0; j < i; ++j) {
                        sum += A_loc.getQuick(i, j) * x.getQuick(j);
                    }
                    sum += y.getQuick(i) * x.getQuick(i);
                } else {
                    sum += y.getQuick(i) * x.getQuick(i);
                    for (j = i + 1; j < size; ++j) {
                        sum += A_loc.getQuick(i, j) * x.getQuick(j);
                    }
                }
                b.setQuick(i, sum);
            }
        }
        x.assign(b);
    }

    @Override
    public int idamax(FloatMatrix1D x) {
        FloatMatrix1D x_abs = x.copy();
        x_abs.assign(FloatFunctions.abs);
        float[] maxAndLoc = x_abs.getMaxLocation();
        return (int)maxAndLoc[1];
    }

    private float sign(float a, float b) {
        if ((double)b < 0.0) {
            return -Math.abs(a);
        }
        return Math.abs(a);
    }
}

