/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.GenericPermuting;
import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.Norm;
import cern.colt.matrix.tbit.QuickBitVector;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.SmpFloatBlas;
import cern.colt.matrix.tfloat.algo.decomposition.DenseFloatCholeskyDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.DenseFloatEigenvalueDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.DenseFloatLUDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.DenseFloatQRDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.DenseFloatSingularValueDecomposition;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tint.IntFunctions;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseFloatAlgebra
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final DenseFloatAlgebra DEFAULT = new DenseFloatAlgebra();
    public static final DenseFloatAlgebra ZERO;
    protected FloatProperty property;

    public DenseFloatAlgebra() {
        this(FloatProperty.DEFAULT.tolerance());
    }

    public DenseFloatAlgebra(float tolerance) {
        this.setProperty(new FloatProperty(tolerance));
    }

    public DenseFloatCholeskyDecomposition chol(FloatMatrix2D matrix) {
        return new DenseFloatCholeskyDecomposition(matrix);
    }

    @Override
    public Object clone() {
        return new DenseFloatAlgebra(this.property.tolerance());
    }

    public float cond(FloatMatrix2D A) {
        return this.svd(A).cond();
    }

    public float det(FloatMatrix2D A) {
        return this.lu(A).det();
    }

    public DenseFloatEigenvalueDecomposition eig(FloatMatrix2D matrix) {
        return new DenseFloatEigenvalueDecomposition(matrix);
    }

    public static float hypot(float a, float b) {
        float r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * (float)Math.sqrt(1.0f + r * r);
        } else if (b != 0.0f) {
            r = a / b;
            r = Math.abs(b) * (float)Math.sqrt(1.0f + r * r);
        } else {
            r = 0.0f;
        }
        return r;
    }

    public static FloatFloatFunction hypotFunction() {
        return new FloatFloatFunction(){

            @Override
            public final float apply(float a, float b) {
                return DenseFloatAlgebra.hypot(a, b);
            }
        };
    }

    public FloatMatrix2D inverse(FloatMatrix2D A) {
        if (this.property.isSquare(A) && this.property.isDiagonal(A)) {
            FloatMatrix2D inv = A.copy();
            boolean isNonSingular = true;
            int i = inv.rows();
            while (--i >= 0) {
                float v = inv.getQuick(i, i);
                isNonSingular &= v != 0.0f;
                inv.setQuick(i, i, 1.0f / v);
            }
            if (!isNonSingular) {
                throw new IllegalArgumentException("A is singular.");
            }
            return inv;
        }
        return this.solve(A, FloatFactory2D.dense.identity(A.rows()));
    }

    public DenseFloatLUDecomposition lu(FloatMatrix2D matrix) {
        return new DenseFloatLUDecomposition(matrix);
    }

    public FloatMatrix1D kron(final FloatMatrix1D x, final FloatMatrix1D y) {
        int size_x = (int)x.size();
        final int size_y = (int)y.size();
        final DenseFloatMatrix1D C = new DenseFloatMatrix1D(size_x * size_y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size_x >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, size_x);
            Future[] futures = new Future[nthreads];
            int k = size_x / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size_x : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            C.viewPart(i * size_y, size_y).assign(y, FloatFunctions.multSecond(x.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
        } else {
            for (int i = 0; i < size_x; ++i) {
                C.viewPart(i * size_y, size_y).assign(y, FloatFunctions.multSecond(x.getQuick(i)));
            }
        }
        return C;
    }

    public FloatMatrix2D kron(final FloatMatrix2D X, final FloatMatrix2D Y) {
        int rows_x = X.rows();
        final int columns_x = X.columns();
        final int rows_y = Y.rows();
        final int columns_y = Y.columns();
        if (X.getClass().getName().indexOf("Dense", 0) != -1 && Y.getClass().getName().indexOf("Dense", 0) != -1) {
            final DenseFloatMatrix2D C = new DenseFloatMatrix2D(rows_x * rows_y, columns_x * columns_y);
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && X.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
                nthreads = Math.min(nthreads, rows_x);
                Future[] futures = new Future[nthreads];
                int k = rows_x / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? rows_x : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < columns_x; ++c) {
                                    C.viewPart(r * rows_y, c * columns_y, rows_y, columns_y).assign(Y, FloatFunctions.multSecond(X.getQuick(r, c)));
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                ConcurrencyUtils.resetThreadsBeginN();
            } else {
                for (int r = 0; r < rows_x; ++r) {
                    for (int c = 0; c < columns_x; ++c) {
                        C.viewPart(r * rows_y, c * columns_y, rows_y, columns_y).assign(Y, FloatFunctions.multSecond(X.getQuick(r, c)));
                    }
                }
            }
            return C;
        }
        IntArrayList iaList = new IntArrayList();
        IntArrayList jaList = new IntArrayList();
        FloatArrayList saList = new FloatArrayList();
        IntArrayList ibList = new IntArrayList();
        IntArrayList jbList = new IntArrayList();
        FloatArrayList sbList = new FloatArrayList();
        X.getNonZeros(iaList, jaList, saList);
        Y.getNonZeros(ibList, jbList, sbList);
        iaList.trimToSize();
        jaList.trimToSize();
        saList.trimToSize();
        ibList.trimToSize();
        jbList.trimToSize();
        sbList.trimToSize();
        DenseIntMatrix1D ia = new DenseIntMatrix1D(iaList.elements());
        DenseIntMatrix1D ja = new DenseIntMatrix1D(jaList.elements());
        DenseFloatMatrix1D sa = new DenseFloatMatrix1D(saList.elements());
        DenseIntMatrix1D ib = new DenseIntMatrix1D(ibList.elements());
        DenseIntMatrix1D jb = new DenseIntMatrix1D(jbList.elements());
        DenseFloatMatrix1D sb = new DenseFloatMatrix1D(sbList.elements());
        ((IntMatrix1D)ia).assign(IntFunctions.mult(rows_y));
        DenseIntMatrix2D ik = new DenseIntMatrix2D(sbList.size(), (int)ia.size());
        for (int i = 0; i < sbList.size(); ++i) {
            ik.viewRow(i).assign(ia).assign(IntFunctions.plus(((IntMatrix1D)ib).getQuick(i)));
        }
        ((IntMatrix1D)ja).assign(IntFunctions.mult(columns_y));
        DenseIntMatrix2D jk = new DenseIntMatrix2D(sbList.size(), (int)ja.size());
        for (int i = 0; i < sbList.size(); ++i) {
            jk.viewRow(i).assign(ja).assign(IntFunctions.plus(((IntMatrix1D)jb).getQuick(i)));
        }
        FloatMatrix2D sk = this.multOuter(sa, sb, null);
        if (X instanceof SparseCCFloatMatrix2D || Y instanceof SparseCCFloatMatrix2D) {
            return new SparseCCFloatMatrix2D(rows_x * rows_y, columns_x * columns_y, (int[])((IntMatrix2D)ik).vectorize().elements(), (int[])((IntMatrix2D)jk).vectorize().elements(), (float[])sk.viewDice().vectorize().elements(), false, false, false);
        }
        return new SparseRCFloatMatrix2D(rows_x * rows_y, columns_x * columns_y, (int[])((IntMatrix2D)ik).vectorize().elements(), (int[])((IntMatrix2D)jk).vectorize().elements(), (float[])sk.viewDice().vectorize().elements(), false, false, false);
    }

    public float mult(FloatMatrix1D x, FloatMatrix1D y) {
        return x.zDotProduct(y);
    }

    public FloatMatrix1D mult(FloatMatrix2D A, FloatMatrix1D y) {
        return A.zMult(y, null);
    }

    public FloatMatrix2D mult(FloatMatrix2D A, FloatMatrix2D B) {
        return A.zMult(B, null);
    }

    public FloatMatrix2D multOuter(final FloatMatrix1D x, final FloatMatrix1D y, FloatMatrix2D A) {
        int j;
        int k;
        Future[] futures;
        int rows = (int)x.size();
        int columns = (int)y.size();
        final FloatMatrix2D AA = A == null ? x.like2D(rows, columns) : A;
        if (AA.rows() != rows || AA.columns() != columns) {
            throw new IllegalArgumentException();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && rows >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, rows);
            futures = new Future[nthreads];
            k = rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            AA.viewRow(r).assign(y);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
        } else {
            int r = rows;
            while (--r >= 0) {
                AA.viewRow(r).assign(y);
            }
        }
        if (nthreads > 1 && columns >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, columns);
            futures = new Future[nthreads];
            k = columns / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            AA.viewColumn(c).assign(x, FloatFunctions.mult);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
        } else {
            int c = columns;
            while (--c >= 0) {
                AA.viewColumn(c).assign(x, FloatFunctions.mult);
            }
        }
        return AA;
    }

    public float norm1(FloatMatrix1D x) {
        if (x.size() == 0L) {
            return 0.0f;
        }
        return x.aggregate(FloatFunctions.plus, FloatFunctions.abs);
    }

    public float norm1(FloatMatrix2D A) {
        float max = 0.0f;
        int column = A.columns();
        while (--column >= 0) {
            max = Math.max(max, this.norm1(A.viewColumn(column)));
        }
        return max;
    }

    public float norm2(FloatMatrix1D x) {
        return (float)Math.sqrt(x.zDotProduct(x));
    }

    public float vectorNorm2(final FloatMatrix2D X) {
        if (X.isView() || !(X instanceof DenseFloatMatrix2D)) {
            int rows = X.rows();
            final int columns = X.columns();
            float sum = 0.0f;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int j;
                nthreads = Math.min(nthreads, rows);
                Future[] futures = new Future[nthreads];
                int k = rows / nthreads;
                for (j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                        @Override
                        public Float call() throws Exception {
                            float sum = 0.0f;
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < columns; ++c) {
                                    float elem = X.getQuick(r, c);
                                    sum += elem * elem;
                                }
                            }
                            return Float.valueOf(sum);
                        }
                    });
                }
                try {
                    for (j = 0; j < nthreads; ++j) {
                        Float result = (Float)futures[j].get();
                        sum += result.floatValue();
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < columns; ++c) {
                        float elem = X.getQuick(r, c);
                        sum += elem * elem;
                    }
                }
            }
            return (float)Math.sqrt(sum);
        }
        final float[] elems = ((DenseFloatMatrix2D)X).elements();
        float sum = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && elems.length >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, elems.length);
            Future[] futures = new Future[nthreads];
            int k = elems.length / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? elems.length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float sum = 0.0f;
                        for (int l = firstIdx; l < lastIdx; ++l) {
                            sum += elems[l] * elems[l];
                        }
                        return Float.valueOf(sum);
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    Float result = (Float)futures[j].get();
                    sum += result.floatValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int l = 0; l < elems.length; ++l) {
                sum += elems[l] * elems[l];
            }
        }
        return (float)Math.sqrt(sum);
    }

    public float vectorNorm2(final FloatMatrix3D X) {
        if (X.isView() || !(X instanceof DenseFloatMatrix3D)) {
            int slices = X.slices();
            final int rows = X.rows();
            final int columns = X.columns();
            float sum = 0.0f;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int j;
                nthreads = Math.min(nthreads, slices);
                Future[] futures = new Future[nthreads];
                int k = slices / nthreads;
                for (j = 0; j < nthreads; ++j) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                        @Override
                        public Float call() throws Exception {
                            float sum = 0.0f;
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < rows; ++r) {
                                    for (int c = 0; c < columns; ++c) {
                                        float elem = X.getQuick(s, r, c);
                                        sum += elem * elem;
                                    }
                                }
                            }
                            return Float.valueOf(sum);
                        }
                    });
                }
                try {
                    for (j = 0; j < nthreads; ++j) {
                        Float result = (Float)futures[j].get();
                        sum += result.floatValue();
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                for (int s = 0; s < slices; ++s) {
                    for (int r = 0; r < rows; ++r) {
                        for (int c = 0; c < columns; ++c) {
                            float elem = X.getQuick(s, r, c);
                            sum += elem * elem;
                        }
                    }
                }
            }
            return (float)Math.sqrt(sum);
        }
        final float[] elems = ((DenseFloatMatrix3D)X).elements();
        float sum = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && elems.length >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, elems.length);
            Future[] futures = new Future[nthreads];
            int k = elems.length / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? elems.length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float sum = 0.0f;
                        for (int l = firstIdx; l < lastIdx; ++l) {
                            sum += elems[l] * elems[l];
                        }
                        return Float.valueOf(sum);
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    Float result = (Float)futures[j].get();
                    sum += result.floatValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int l = 0; l < elems.length; ++l) {
                sum += elems[l] * elems[l];
            }
        }
        return (float)Math.sqrt(sum);
    }

    public float norm(FloatMatrix2D A, Norm type) {
        switch (type) {
            case Frobenius: {
                return DEFAULT.normF(A);
            }
            case Infinity: {
                return DEFAULT.normInfinity(A);
            }
            case One: {
                return DEFAULT.norm1(A);
            }
            case Two: {
                return DEFAULT.norm2(A);
            }
        }
        return 0.0f;
    }

    public float norm(FloatMatrix1D x, Norm type) {
        switch (type) {
            case Frobenius: {
                return DEFAULT.normF(x);
            }
            case Infinity: {
                return DEFAULT.normInfinity(x);
            }
            case One: {
                return DEFAULT.norm1(x);
            }
            case Two: {
                return DEFAULT.norm2(x);
            }
        }
        return 0.0f;
    }

    public float norm2(FloatMatrix2D A) {
        return this.svd(A).norm2();
    }

    public float normF(FloatMatrix2D A) {
        if (A.size() == 0L) {
            return 0.0f;
        }
        return A.aggregate(DenseFloatAlgebra.hypotFunction(), FloatFunctions.identity);
    }

    public float normF(FloatMatrix1D A) {
        if (A.size() == 0L) {
            return 0.0f;
        }
        return A.aggregate(DenseFloatAlgebra.hypotFunction(), FloatFunctions.identity);
    }

    public float normInfinity(FloatMatrix1D x) {
        if (x.size() == 0L) {
            return 0.0f;
        }
        return x.aggregate(FloatFunctions.max, FloatFunctions.abs);
    }

    public float normInfinity(FloatMatrix2D A) {
        float max = 0.0f;
        int row = A.rows();
        while (--row >= 0) {
            max = Math.max(max, this.norm1(A.viewRow(row)));
        }
        return max;
    }

    public FloatMatrix1D permute(FloatMatrix1D A, int[] indexes, float[] work) {
        int size = (int)A.size();
        if (indexes.length != size) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        if (work == null || size > work.length) {
            work = A.toArray();
        } else {
            A.toArray(work);
        }
        int i = size;
        while (--i >= 0) {
            A.setQuick(i, work[indexes[i]]);
        }
        return A;
    }

    public FloatMatrix2D permute(FloatMatrix2D A, int[] rowIndexes, int[] columnIndexes) {
        return A.viewSelection(rowIndexes, columnIndexes);
    }

    public FloatMatrix2D permuteColumns(FloatMatrix2D A, int[] indexes, int[] work) {
        return this.permuteRows(A.viewDice(), indexes, work);
    }

    public FloatMatrix2D permuteRows(final FloatMatrix2D A, int[] indexes, int[] work) {
        int size = A.rows();
        if (indexes.length != size) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        int columns = A.columns();
        if (columns < size / 10) {
            float[] floatWork = new float[size];
            int j = A.columns();
            while (--j >= 0) {
                this.permute(A.viewColumn(j), indexes, floatWork);
            }
            return A;
        }
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                A.viewRow(a).swap(A.viewRow(b));
            }
        };
        GenericPermuting.permute(indexes, swapper, work, null);
        return A;
    }

    public FloatMatrix2D pow(FloatMatrix2D A, int p) {
        int i;
        SmpFloatBlas blas = new SmpFloatBlas();
        FloatProperty.DEFAULT.checkSquare(A);
        if (p < 0) {
            A = this.inverse(A);
            p = -p;
        }
        if (p == 0) {
            return FloatFactory2D.dense.identity(A.rows());
        }
        FloatMatrix2D T = A.like();
        if (p == 1) {
            return T.assign(A);
        }
        if (p == 2) {
            blas.dgemm(false, false, 1.0f, A, A, 0.0f, T);
            return T;
        }
        int k = QuickBitVector.mostSignificantBit(p);
        for (i = 0; i <= k && (p & 1 << i) == 0; ++i) {
            blas.dgemm(false, false, 1.0f, A, A, 0.0f, T);
            FloatMatrix2D swap = A;
            A = T;
            T = swap;
        }
        FloatMatrix2D B = A.copy();
        ++i;
        while (i <= k) {
            blas.dgemm(false, false, 1.0f, A, A, 0.0f, T);
            FloatMatrix2D swap = A;
            A = T;
            T = swap;
            if ((p & 1 << i) != 0) {
                blas.dgemm(false, false, 1.0f, B, A, 0.0f, T);
                swap = B;
                B = T;
                T = swap;
            }
            ++i;
        }
        return B;
    }

    public FloatProperty property() {
        return this.property;
    }

    public DenseFloatQRDecomposition qr(FloatMatrix2D matrix) {
        return new DenseFloatQRDecomposition(matrix);
    }

    public int rank(FloatMatrix2D A) {
        return this.svd(A).rank();
    }

    public void setProperty(FloatProperty property) {
        if (this == DEFAULT && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = property;
    }

    public FloatMatrix1D backwardSolve(FloatMatrix2D U, FloatMatrix1D b) {
        int rows = U.rows();
        FloatMatrix1D x = b.like();
        x.setQuick(rows - 1, b.getQuick(rows - 1) / U.getQuick(rows - 1, rows - 1));
        for (int r = rows - 2; r >= 0; --r) {
            float sum = U.viewRow(r).zDotProduct(x);
            x.setQuick(r, (b.getQuick(r) - sum) / U.getQuick(r, r));
        }
        return x;
    }

    public FloatMatrix1D forwardSolve(FloatMatrix2D L, FloatMatrix1D b) {
        int rows = L.rows();
        FloatMatrix1D x = b.like();
        x.setQuick(0, b.getQuick(0) / L.getQuick(0, 0));
        for (int r = 1; r < rows; ++r) {
            float sum = L.viewRow(r).zDotProduct(x);
            x.setQuick(r, (b.getQuick(r) - sum) / L.getQuick(r, r));
        }
        return x;
    }

    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b) {
        if (A.rows() == A.columns()) {
            return this.lu(A).solve(b);
        }
        FloatMatrix1D x = b.copy();
        this.qr(A).solve(x);
        return x.viewPart(0, A.columns()).copy();
    }

    public FloatMatrix2D solve(FloatMatrix2D A, FloatMatrix2D B) {
        if (A.rows() == A.columns()) {
            return this.lu(A).solve(B);
        }
        FloatMatrix2D X = B.copy();
        this.qr(A).solve(X);
        return X.viewPart(0, 0, A.columns(), B.columns()).copy();
    }

    public FloatMatrix2D solveTranspose(FloatMatrix2D A, FloatMatrix2D B) {
        return this.solve(this.transpose(A), this.transpose(B));
    }

    public FloatMatrix2D subMatrix(FloatMatrix2D A, int[] rowIndexes, int columnFrom, int columnTo) {
        int width = columnTo - columnFrom + 1;
        int rows = A.rows();
        A = A.viewPart(0, columnFrom, rows, width);
        FloatMatrix2D sub = A.like(rowIndexes.length, width);
        int r = rowIndexes.length;
        while (--r >= 0) {
            int row = rowIndexes[r];
            if (row < 0 || row >= rows) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            sub.viewRow(r).assign(A.viewRow(row));
        }
        return sub;
    }

    public FloatMatrix2D subMatrix(FloatMatrix2D A, int rowFrom, int rowTo, int[] columnIndexes) {
        if (rowTo - rowFrom >= A.rows()) {
            throw new IndexOutOfBoundsException("Too many rows");
        }
        int height = rowTo - rowFrom + 1;
        int columns = A.columns();
        A = A.viewPart(rowFrom, 0, height, columns);
        FloatMatrix2D sub = A.like(height, columnIndexes.length);
        int c = columnIndexes.length;
        while (--c >= 0) {
            int column = columnIndexes[c];
            if (column < 0 || column >= columns) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            sub.viewColumn(c).assign(A.viewColumn(column));
        }
        return sub;
    }

    public FloatMatrix2D subMatrix(FloatMatrix2D A, int fromRow, int toRow, int fromColumn, int toColumn) {
        return A.viewPart(fromRow, fromColumn, toRow - fromRow + 1, toColumn - fromColumn + 1);
    }

    public DenseFloatSingularValueDecomposition svd(FloatMatrix2D matrix) {
        return new DenseFloatSingularValueDecomposition(matrix, true, true);
    }

    public String toString(FloatMatrix2D matrix) {
        final ObjectArrayList names = new ObjectArrayList();
        final ObjectArrayList values = new ObjectArrayList();
        String unknown = "Illegal operation or error: ";
        names.add("cond");
        try {
            values.add(String.valueOf(this.cond(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("det");
        try {
            values.add(String.valueOf(this.det(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("norm1");
        try {
            values.add(String.valueOf(this.norm1(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("norm2");
        try {
            values.add(String.valueOf(this.norm2(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("normF");
        try {
            values.add(String.valueOf(this.normF(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("normInfinity");
        try {
            values.add(String.valueOf(this.normInfinity(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("rank");
        try {
            values.add(String.valueOf(this.rank(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("trace");
        try {
            values.add(String.valueOf(this.trace(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return FloatProperty.get(names, a).compareTo(FloatProperty.get(names, b));
            }
        };
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                Object tmp = names.get(a);
                names.set(a, names.get(b));
                names.set(b, tmp);
                tmp = values.get(a);
                values.set(a, values.get(b));
                values.set(b, tmp);
            }
        };
        GenericSorting.quickSort(0, names.size(), comp, swapper);
        int maxLength = 0;
        for (int i = 0; i < names.size(); ++i) {
            int length = ((String)names.get(i)).length();
            maxLength = Math.max(length, maxLength);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            buf.append(name);
            buf.append(FloatProperty.blanks(maxLength - name.length()));
            buf.append(" : ");
            buf.append(values.get(i));
            if (i >= names.size() - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    public String toVerboseString(FloatMatrix2D matrix) {
        String constructionException = "Illegal operation or error upon construction of ";
        StringBuffer buf = new StringBuffer();
        buf.append("A = ");
        buf.append(matrix);
        buf.append("\n\n" + this.toString(matrix));
        buf.append("\n\n" + FloatProperty.DEFAULT.toString(matrix));
        DenseFloatLUDecomposition lu = null;
        try {
            lu = new DenseFloatLUDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " LUDecomposition: " + exc.getMessage());
        }
        if (lu != null) {
            buf.append("\n\n" + lu.toString());
        }
        DenseFloatQRDecomposition qr = null;
        try {
            qr = new DenseFloatQRDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " QRDecomposition: " + exc.getMessage());
        }
        if (qr != null) {
            buf.append("\n\n" + qr.toString());
        }
        DenseFloatCholeskyDecomposition chol = null;
        try {
            chol = new DenseFloatCholeskyDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " CholeskyDecomposition: " + exc.getMessage());
        }
        if (chol != null) {
            buf.append("\n\n" + chol.toString());
        }
        DenseFloatEigenvalueDecomposition eig = null;
        try {
            eig = new DenseFloatEigenvalueDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " EigenvalueDecomposition: " + exc.getMessage());
        }
        if (eig != null) {
            buf.append("\n\n" + eig.toString());
        }
        DenseFloatSingularValueDecomposition svd = null;
        try {
            svd = new DenseFloatSingularValueDecomposition(matrix, true, true);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n" + constructionException + " SingularValueDecomposition: " + exc.getMessage());
        }
        if (svd != null) {
            buf.append("\n\n" + svd.toString());
        }
        return buf.toString();
    }

    public float trace(FloatMatrix2D A) {
        float sum = 0.0f;
        int i = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            sum += A.getQuick(i, i);
        }
        return sum;
    }

    public FloatMatrix2D transpose(FloatMatrix2D A) {
        return A.viewDice();
    }

    public FloatMatrix2D trapezoidalLower(FloatMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int r = rows;
        while (--r >= 0) {
            int c = columns;
            while (--c >= 0) {
                if (r >= c) continue;
                A.setQuick(r, c, 0.0f);
            }
        }
        return A;
    }

    public FloatMatrix2D xmultOuter(FloatMatrix1D x, FloatMatrix1D y) {
        FloatMatrix2D A = x.like2D((int)x.size(), (int)y.size());
        this.multOuter(x, y, A);
        return A;
    }

    public FloatMatrix2D xpowSlow(FloatMatrix2D A, int k) {
        FloatMatrix2D result = A.copy();
        for (int i = 0; i < k - 1; ++i) {
            result = this.mult(result, A);
        }
        return result;
    }

    static {
        DenseFloatAlgebra.DEFAULT.property = FloatProperty.DEFAULT;
        ZERO = new DenseFloatAlgebra();
        DenseFloatAlgebra.ZERO.property = FloatProperty.ZERO;
    }
}

