/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.function.tfloat.Float9Function;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1DProcedure;
import cern.colt.matrix.tfloat.algo.FloatFormatter;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.FloatSorting;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.utils.ConcurrencyUtils;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class FloatMatrix2D
extends AbstractMatrix2D {
    private static final long serialVersionUID = 1L;

    protected FloatMatrix2D() {
    }

    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(FloatMatrix2D.this.getQuick(firstRow, 0));
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < FloatMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(FloatMatrix2D.this.getQuick(r, c)));
                            }
                            d = 0;
                        }
                        return Float.valueOf(a);
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0));
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c)));
                }
                d = 0;
            }
        }
        return a;
    }

    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, final FloatProcedure cond) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float elem = FloatMatrix2D.this.getQuick(firstRow, 0);
                        float a = 0.0f;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < FloatMatrix2D.this.columns; ++c) {
                                elem = FloatMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return Float.valueOf(a);
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            float elem = this.getQuick(0, 0);
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(FloatMatrix2D.this.getQuick(rowElements[firstIdx], columnElements[firstIdx]));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            float elem = FloatMatrix2D.this.getQuick(rowElements[i], columnElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return Float.valueOf(a);
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(rowElements[0], columnElements[0]));
            for (int i = 1; i < size; ++i) {
                float elem = this.getQuick(rowElements[i], columnElements[i]);
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public float aggregate(final FloatMatrix2D other, final FloatFloatFunction aggr, final FloatFloatFunction f) {
        this.checkShape(other);
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(FloatMatrix2D.this.getQuick(firstRow, 0), other.getQuick(firstRow, 0));
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < FloatMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(FloatMatrix2D.this.getQuick(r, c), other.getQuick(r, c)));
                            }
                            d = 0;
                        }
                        return Float.valueOf(a);
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0), other.getQuick(0, 0));
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c), other.getQuick(r, c)));
                }
                d = 0;
            }
        }
        return a;
    }

    public FloatMatrix2D assign(final FloatFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                FloatMatrix2D.this.setQuick(r, c, f.apply(FloatMatrix2D.this.getQuick(r, c)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, f.apply(this.getQuick(r, c)));
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatProcedure cond, final FloatFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                float elem = FloatMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                FloatMatrix2D.this.setQuick(r, c, f.apply(elem));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    float elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    this.setQuick(r, c, f.apply(elem));
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatProcedure cond, final float value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                float elem = FloatMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                FloatMatrix2D.this.setQuick(r, c, value);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    float elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    this.setQuick(r, c, value);
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                FloatMatrix2D.this.setQuick(r, c, value);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, value);
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float[] values) {
        if (values.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstRow * FloatMatrix2D.this.columns;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                FloatMatrix2D.this.setQuick(r, c, values[idx++]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, values[idx++]);
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            float[] currentRow = values[r];
                            if (currentRow.length != FloatMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + FloatMatrix2D.this.columns());
                            }
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                FloatMatrix2D.this.setQuick(r, c, currentRow[c]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                float[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                }
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, currentRow[c]);
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final FloatMatrix2D source = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                FloatMatrix2D.this.setQuick(r, c, source.getQuick(r, c));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, source.getQuick(r, c));
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatMatrix2D y, final FloatFloatFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                FloatMatrix2D.this.setQuick(r, c, function.apply(FloatMatrix2D.this.getQuick(r, c), y.getQuick(r, c)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, function.apply(this.getQuick(r, c), y.getQuick(r, c)));
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatMatrix2D y, final FloatFloatFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            FloatMatrix2D.this.setQuick(rowElements[i], columnElements[i], function.apply(FloatMatrix2D.this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(rowElements[i], columnElements[i], function.apply(this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                if (FloatMatrix2D.this.getQuick(r, c) == 0.0f) continue;
                                ++cardinality;
                            }
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    if (this.getQuick(r, c) == 0.0f) continue;
                    ++cardinality;
                }
            }
        }
        return cardinality;
    }

    public FloatMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(float value) {
        return FloatProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FloatMatrix2D)) {
            return false;
        }
        return FloatProperty.DEFAULT.equals(this, (FloatMatrix2D)obj);
    }

    public FloatMatrix2D forEachNonZero(final IntIntFloatFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                float a;
                                float value = FloatMatrix2D.this.getQuick(r, c);
                                if (value == 0.0f || (a = function.apply(r, c, value)) == value) continue;
                                FloatMatrix2D.this.setQuick(r, c, a);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    float a;
                    float value = this.getQuick(r, c);
                    if (value == 0.0f || (a = function.apply(r, c, value)) == value) continue;
                    this.setQuick(r, c, a);
                }
            }
        }
        return this;
    }

    public float get(int row, int column) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        return this.getQuick(row, column);
    }

    public float[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        float maxValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        float maxValue = FloatMatrix2D.this.getQuick(rowLocation, 0);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < FloatMatrix2D.this.columns; ++c) {
                                float elem = FloatMatrix2D.this.getQuick(r, c);
                                if (!(maxValue < elem)) continue;
                                maxValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new float[]{maxValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (float[])futures[j].get();
                }
                maxValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (!(maxValue < results[j][0])) continue;
                    maxValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(0, 0);
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    float elem = this.getQuick(r, c);
                    if (!(maxValue < elem)) continue;
                    maxValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new float[]{maxValue, rowLocation, columnLocation};
    }

    public float[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        float minValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        float minValue = FloatMatrix2D.this.getQuick(rowLocation, 0);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < FloatMatrix2D.this.columns; ++c) {
                                float elem = FloatMatrix2D.this.getQuick(r, c);
                                if (!(minValue > elem)) continue;
                                minValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new float[]{minValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (float[])futures[j].get();
                }
                minValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (!(minValue > results[j][0])) continue;
                    minValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(0, 0);
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    float elem = this.getQuick(r, c);
                    if (!(minValue > elem)) continue;
                    minValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new float[]{minValue, rowLocation, columnLocation};
    }

    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                float value = this.getQuick(r, c);
                if (!(value < 0.0f)) continue;
                rowList.add(r);
                columnList.add(c);
                valueList.add(value);
            }
        }
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                float value = this.getQuick(r, c);
                if (value == 0.0f) continue;
                rowList.add(r);
                columnList.add(c);
                valueList.add(value);
            }
        }
    }

    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                float value = this.getQuick(r, c);
                if (!(value > 0.0f)) continue;
                rowList.add(r);
                columnList.add(c);
                valueList.add(value);
            }
        }
    }

    public abstract float getQuick(int var1, int var2);

    public FloatMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract FloatMatrix2D like(int var1, int var2);

    public abstract FloatMatrix1D like1D(int var1);

    public void normalize() {
        float min = this.getMinLocation()[0];
        if (min < 0.0f) {
            this.assign(FloatFunctions.minus(min));
        }
        if (this.getMaxLocation()[0] == 0.0f) {
            this.assign(1.0f / (float)this.size());
        } else {
            float sumScaleFactor = this.zSum();
            sumScaleFactor = 1.0f / sumScaleFactor;
            this.assign(FloatFunctions.mult(sumScaleFactor));
        }
    }

    public void set(int row, int column, float value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, value);
    }

    public abstract void setQuick(int var1, int var2, float var3);

    public float[][] toArray() {
        final float[][] values = new float[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            float[] currentRow = values[r];
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                currentRow[c] = FloatMatrix2D.this.getQuick(r, c);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                float[] currentRow = values[r];
                for (int c = 0; c < this.columns; ++c) {
                    currentRow[c] = this.getQuick(r, c);
                }
            }
        }
        return values;
    }

    public String toString() {
        return new FloatFormatter().toString(this);
    }

    public abstract FloatMatrix1D vectorize();

    public FloatMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = (int)this.index(0, column);
        int viewStride = this.rowStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public FloatMatrix2D viewColumnFlip() {
        return (FloatMatrix2D)this.view().vColumnFlip();
    }

    public FloatMatrix2D viewDice() {
        return (FloatMatrix2D)this.view().vDice();
    }

    public FloatMatrix2D viewPart(int row, int column, int height, int width) {
        return (FloatMatrix2D)this.view().vPart(row, column, height, width);
    }

    public FloatMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = (int)this.index(row, 0);
        int viewStride = this.columnStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public FloatMatrix2D viewRowFlip() {
        return (FloatMatrix2D)this.view().vRowFlip();
    }

    public FloatMatrix2D viewSelection(FloatMatrix1DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!condition.apply(this.viewRow(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null);
    }

    public FloatMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        int i2;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            for (i2 = 0; i2 < this.rows; ++i2) {
                rowIndexes[i2] = i2;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            for (i2 = 0; i2 < this.columns; ++i2) {
                columnIndexes[i2] = i2;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        for (i = 0; i < rowIndexes.length; ++i) {
            rowOffsets[i] = this._rowOffset(this._rowRank(rowIndexes[i]));
        }
        for (i = 0; i < columnIndexes.length; ++i) {
            columnOffsets[i] = this._columnOffset(this._columnRank(columnIndexes[i]));
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public FloatMatrix2D viewSelection(Set<int[]> indexes) {
        int i;
        int n = indexes.size();
        int[] rowIndexes = new int[n];
        int[] columnIndexes = new int[n];
        int idx = 0;
        for (int[] is : indexes) {
            rowIndexes[idx] = is[0];
            columnIndexes[idx] = is[1];
            ++idx;
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        for (i = 0; i < rowIndexes.length; ++i) {
            rowOffsets[i] = this._rowOffset(this._rowRank(rowIndexes[i]));
        }
        for (i = 0; i < columnIndexes.length; ++i) {
            columnOffsets[i] = this._columnOffset(this._columnRank(columnIndexes[i]));
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public FloatMatrix2D viewSorted(int column) {
        return FloatSorting.mergeSort.sort(this, column);
    }

    public FloatMatrix2D viewStrides(int rowStride, int columnStride) {
        return (FloatMatrix2D)this.view().vStrides(rowStride, columnStride);
    }

    public void zAssign8Neighbors(FloatMatrix2D B, Float9Function function) {
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        int r = this.rows - 1;
        int c = this.columns - 1;
        for (int i = 1; i < r; ++i) {
            float a00 = this.getQuick(i - 1, 0);
            float a01 = this.getQuick(i - 1, 1);
            float a10 = this.getQuick(i, 0);
            float a11 = this.getQuick(i, 1);
            float a20 = this.getQuick(i + 1, 0);
            float a21 = this.getQuick(i + 1, 1);
            for (int j = 1; j < c; ++j) {
                float a02 = this.getQuick(i - 1, j + 1);
                float a12 = this.getQuick(i, j + 1);
                float a22 = this.getQuick(i + 1, j + 1);
                B.setQuick(i, j, function.apply(a00, a01, a02, a10, a11, a12, a20, a21, a22));
                a00 = a01;
                a10 = a11;
                a20 = a21;
                a01 = a02;
                a11 = a12;
                a21 = a22;
            }
        }
    }

    public FloatMatrix1D zMult(FloatMatrix1D y, FloatMatrix1D z) {
        return this.zMult(y, z, 1.0f, 0.0f, false);
    }

    public FloatMatrix1D zMult(final FloatMatrix1D y, FloatMatrix1D z, final float alpha, final float beta, boolean transposeA) {
        if (transposeA) {
            return this.viewDice().zMult(y, z, alpha, beta, false);
        }
        final FloatMatrix1D zz = z == null ? y.like(this.rows) : z;
        if ((long)this.columns != y.size() || (long)this.rows > zz.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + zz.toStringShort());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            float s = 0.0f;
                            for (int c = 0; c < FloatMatrix2D.this.columns; ++c) {
                                s += FloatMatrix2D.this.getQuick(r, c) * y.getQuick(c);
                            }
                            zz.setQuick(r, alpha * s + beta * zz.getQuick(r));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                float s = 0.0f;
                for (int c = 0; c < this.columns; ++c) {
                    s += this.getQuick(r, c) * y.getQuick(c);
                }
                zz.setQuick(r, alpha * s + beta * zz.getQuick(r));
            }
        }
        return zz;
    }

    public FloatMatrix2D zMult(FloatMatrix2D B, FloatMatrix2D C) {
        return this.zMult(B, C, 1.0f, 0.0f, false, false);
    }

    public FloatMatrix2D zMult(final FloatMatrix2D B, FloatMatrix2D C, final float alpha, final float beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        final int m = this.rows;
        final int n = this.columns;
        int p = B.columns;
        final FloatMatrix2D CC = C == null ? this.like(m, p) : C;
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (CC.rows != m || CC.columns != p) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + CC.toStringShort());
        }
        if (this == CC || B == CC) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, p);
            Future[] futures = new Future[nthreads];
            int k = p / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? p : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int a = firstIdx; a < lastIdx; ++a) {
                            for (int b = 0; b < m; ++b) {
                                float s = 0.0f;
                                for (int c = 0; c < n; ++c) {
                                    s += FloatMatrix2D.this.getQuick(b, c) * B.getQuick(c, a);
                                }
                                CC.setQuick(b, a, alpha * s + beta * CC.getQuick(b, a));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int a = 0; a < p; ++a) {
                for (int b = 0; b < m; ++b) {
                    float s = 0.0f;
                    for (int c = 0; c < n; ++c) {
                        s += this.getQuick(b, c) * B.getQuick(c, a);
                    }
                    CC.setQuick(b, a, alpha * s + beta * CC.getQuick(b, a));
                }
            }
        }
        return CC;
    }

    public float zSum() {
        if (this.size() == 0L) {
            return 0.0f;
        }
        return this.aggregate(FloatFunctions.plus, FloatFunctions.identity);
    }

    protected FloatMatrix2D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FloatMatrix2D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(FloatMatrix2D other) {
        return false;
    }

    protected abstract FloatMatrix1D like1D(int var1, int var2, int var3);

    protected FloatMatrix2D view() {
        return (FloatMatrix2D)this.clone();
    }

    protected abstract FloatMatrix2D viewSelectionLike(int[] var1, int[] var2);
}

