/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;

public class SparseCCMDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseDoubleMatrix1D[] elements;

    public SparseCCMDoubleMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseDoubleMatrix1D[columns];
        for (int i = 0; i < columns; ++i) {
            this.elements[i] = new SparseDoubleMatrix1D(rows);
        }
    }

    public SparseDoubleMatrix1D[] elements() {
        return this.elements;
    }

    @Override
    public double getQuick(int row, int column) {
        return this.elements[column].getQuick(row);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        this.elements[column].setQuick(row, value);
    }

    @Override
    public void trimToSize() {
        for (int c = 0; c < this.columns; ++c) {
            this.elements[c].trimToSize();
        }
    }

    @Override
    public SparseDoubleMatrix1D viewColumn(int column) {
        return this.elements[column];
    }

    @Override
    protected DoubleMatrix2D getContent() {
        return this;
    }

    @Override
    public DoubleMatrix2D like(int rows, int columns) {
        return new SparseCCMDoubleMatrix2D(rows, columns);
    }
}

