/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleSingularValueDecomposition;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.HyBRDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.HyBRInnerSolver;
import cern.colt.matrix.tdouble.algo.solver.HyBRRegularizationMethod;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoubleIdentity;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.stat.tdouble.DoubleDescriptive;
import optimization.DoubleFmin;
import optimization.DoubleFmin_methods;

public class DoubleHyBR
extends AbstractDoubleIterativeSolver {
    private HyBRInnerSolver innerSolver;
    private HyBRRegularizationMethod regMethod;
    private double regPar;
    private double omega;
    private boolean reorth;
    private int begReg;
    private double flatTol;
    private boolean computeRnrm;
    private static final DenseDoubleAlgebra alg = DenseDoubleAlgebra.DEFAULT;
    private static final double FMIN_TOL = 1.0E-4;

    public DoubleHyBR() {
        this(HyBRInnerSolver.TIKHONOV, HyBRRegularizationMethod.ADAPTWGCV, 0.0, 0.0, false, 2, 1.0E-6, false);
    }

    public DoubleHyBR(HyBRInnerSolver innerSolver, HyBRRegularizationMethod regularizationMethod, double regularizationParameter, double omega, boolean reorthogonalize, int beginRegularization, double flatTolerance, boolean computeRnrm) {
        this.innerSolver = innerSolver;
        this.regMethod = regularizationMethod;
        if (regularizationParameter < 0.0 || regularizationParameter > 1.0) {
            throw new IllegalArgumentException("regularizationParameter must be a number between 0 and 1.");
        }
        this.regPar = regularizationParameter;
        if (omega < 0.0) {
            throw new IllegalArgumentException("omega must be a nonnegative number.");
        }
        this.omega = omega;
        this.reorth = reorthogonalize;
        if (beginRegularization < 2) {
            throw new IllegalArgumentException("beginRegularization must be greater or equal 2");
        }
        this.begReg = beginRegularization;
        if (flatTolerance < 0.0) {
            throw new IllegalArgumentException("flatTolerance must be a nonnegative number.");
        }
        this.flatTol = flatTolerance;
        this.computeRnrm = computeRnrm;
        this.iter = new HyBRDoubleIterationMonitor();
    }

    @Override
    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        DoubleLBD lbd;
        DoubleMatrix1D work;
        if (!(this.iter instanceof HyBRDoubleIterationMonitor)) {
            this.iter = new HyBRDoubleIterationMonitor();
        }
        this.checkSizes(A, b, x);
        int rows = A.rows();
        int columns = A.columns();
        boolean bump = false;
        boolean warning = false;
        double rnrm = -1.0;
        int iterationsSave = 0;
        double alpha = 0.0;
        double alphaSave = 0.0;
        double beta = 0.0;
        HyBRInnerSolver inSolver = HyBRInnerSolver.NONE;
        DoubleMatrix1D f = null;
        DenseDoubleMatrix1D xSave = null;
        DoubleArrayList omegaList = new DoubleArrayList(new double[this.begReg - 2]);
        DoubleArrayList GCV = new DoubleArrayList(new double[this.begReg - 2]);
        DoubleMatrix2D U = new DenseDoubleMatrix2D(1, (int)b.size());
        DoubleMatrix2D C = null;
        DoubleMatrix2D V = null;
        if (this.computeRnrm) {
            work = b.copy();
            A.zMult(x, work, -1.0, 1.0, false);
            rnrm = alg.norm2(work);
        }
        if (this.M instanceof DoubleIdentity) {
            beta = alg.norm2(b);
            U.viewRow(0).assign(b, DoubleFunctions.multSecond(1.0 / beta));
            lbd = new DoubleSimpleLBD(A, U, this.reorth);
        } else {
            work = new DenseDoubleMatrix1D((int)b.size());
            work = this.M.apply(b, work);
            beta = alg.norm2(work);
            U.viewRow(0).assign(work, DoubleFunctions.multSecond(1.0 / beta));
            lbd = new DoublePLBD(this.M, A, U, this.reorth);
        }
        this.iter.setFirst();
        while (!this.iter.converged(rnrm, x)) {
            lbd.apply();
            U = lbd.getU();
            C = lbd.getC();
            V = lbd.getV();
            DenseDoubleMatrix1D v = new DenseDoubleMatrix1D(C.columns() + 1);
            ((DoubleMatrix1D)v).setQuick(0, beta);
            int i = this.iter.iterations();
            if (i >= 1) {
                if (i >= this.begReg - 1) {
                    inSolver = this.innerSolver;
                }
                switch (inSolver) {
                    case TIKHONOV: {
                        DenseDoubleSingularValueDecomposition svd = alg.svd(C);
                        DoubleMatrix2D Ub = svd.getU();
                        double[] sv = svd.getSingularValues();
                        DoubleMatrix2D Vb = svd.getV();
                        if (this.regMethod == HyBRRegularizationMethod.ADAPTWGCV) {
                            work = new DenseDoubleMatrix1D(Ub.rows());
                            Ub.zMult(v, work, 1.0, 0.0, true);
                            omegaList.add(Math.min(1.0, this.findOmega(work, sv)));
                            this.omega = DoubleDescriptive.mean(omegaList);
                        }
                        f = new DenseDoubleMatrix1D(Vb.rows());
                        alpha = this.tikhonovSolver(Ub, sv, Vb, v, f);
                        GCV.add(this.GCVstopfun(alpha, Ub.viewRow(0), sv, beta, rows, columns));
                        ((HyBRDoubleIterationMonitor)this.iter).setRegularizationParameter(alpha);
                        if (i <= 1) break;
                        if (Math.abs(GCV.getQuick(i - 1) - GCV.getQuick(i - 2)) / GCV.get(this.begReg - 2) < this.flatTol) {
                            V.zMult(f, x);
                            ((HyBRDoubleIterationMonitor)this.iter).setStoppingCondition(HyBRDoubleIterationMonitor.HyBRStoppingCondition.FLAT_GCV_CURVE);
                            if (this.computeRnrm) {
                                work = b.copy();
                                A.zMult(x, work, -1.0, 1.0, false);
                                ((HyBRDoubleIterationMonitor)this.iter).residual = alg.norm2(work);
                            }
                            return x;
                        }
                        if (warning && GCV.size() > iterationsSave + 3) {
                            for (int j = iterationsSave; j < GCV.size(); ++j) {
                                if (!(GCV.getQuick(iterationsSave - 1) > GCV.get(j))) continue;
                                bump = true;
                            }
                            if (!bump) {
                                x.assign(xSave);
                                ((HyBRDoubleIterationMonitor)this.iter).setStoppingCondition(HyBRDoubleIterationMonitor.HyBRStoppingCondition.MIN_OF_GCV_CURVE_WITHIN_WINDOW_OF_4_ITERATIONS);
                                ((HyBRDoubleIterationMonitor)this.iter).iter = iterationsSave;
                                if (this.computeRnrm) {
                                    work = b.copy();
                                    A.zMult(x, work, -1.0, 1.0, false);
                                    ((HyBRDoubleIterationMonitor)this.iter).residual = alg.norm2(work);
                                }
                                ((HyBRDoubleIterationMonitor)this.iter).setRegularizationParameter(alphaSave);
                                return x;
                            }
                            bump = false;
                            warning = false;
                            iterationsSave = this.iter.getMaxIterations();
                            break;
                        }
                        if (warning || !(GCV.get(i - 2) < GCV.get(i - 1))) break;
                        warning = true;
                        xSave = new DenseDoubleMatrix1D(V.rows());
                        alphaSave = alpha;
                        V.zMult(f, xSave);
                        iterationsSave = i;
                        break;
                    }
                    case NONE: {
                        f = alg.solve(C, v);
                    }
                }
                V.zMult(f, x);
                if (this.computeRnrm) {
                    work = b.copy();
                    A.zMult(x, work, -1.0, 1.0, false);
                    rnrm = alg.norm2(work);
                }
            }
            this.iter.next();
        }
        return x;
    }

    @Override
    protected void checkSizes(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) {
        if (b.size() != (long)A.rows()) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        if (x.size() != (long)A.columns()) {
            throw new IllegalArgumentException("x.size() != A.columns()");
        }
    }

    private double findOmega(DoubleMatrix1D bhat, double[] s) {
        int m = (int)bhat.size();
        int n = s.length;
        double alpha = s[n - 1];
        double t0 = bhat.viewPart(n, m - n).aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        DenseDoubleMatrix1D s2 = new DenseDoubleMatrix1D(s);
        ((DoubleMatrix1D)s2).assign(DoubleFunctions.square);
        double alpha2 = alpha * alpha;
        DoubleMatrix1D tt = s2.copy();
        tt.assign(DoubleFunctions.plus(alpha2));
        tt.assign(DoubleFunctions.inv);
        double t1 = ((DoubleMatrix1D)s2).aggregate(tt, DoubleFunctions.plus, DoubleFunctions.mult);
        s2 = new DenseDoubleMatrix1D(s);
        ((DoubleMatrix1D)s2).assign(DoubleFunctions.mult(alpha));
        ((DoubleMatrix1D)s2).assign(bhat.viewPart(0, n), DoubleFunctions.mult);
        ((DoubleMatrix1D)s2).assign(DoubleFunctions.square);
        DoubleMatrix1D work = tt.copy();
        work.assign(DoubleFunctions.pow(3.0));
        work.assign(DoubleFunctions.abs);
        double t3 = work.aggregate(s2, DoubleFunctions.plus, DoubleFunctions.mult);
        work = new DenseDoubleMatrix1D(s);
        work.assign(tt, DoubleFunctions.mult);
        double t4 = work.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        work = tt.copy();
        work.assign(bhat.viewPart(0, n), DoubleFunctions.mult);
        work.assign(DoubleFunctions.mult(alpha2));
        double t5 = work.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        s2 = new DenseDoubleMatrix1D(s);
        ((DoubleMatrix1D)s2).assign(bhat.viewPart(0, n), DoubleFunctions.mult);
        ((DoubleMatrix1D)s2).assign(DoubleFunctions.square);
        tt.assign(DoubleFunctions.pow(3.0));
        tt.assign(DoubleFunctions.abs);
        double v2 = tt.aggregate(s2, DoubleFunctions.plus, DoubleFunctions.mult);
        return (double)m * alpha2 * v2 / (t1 * t3 + t4 * (t5 + t0));
    }

    private double tikhonovSolver(DoubleMatrix2D U, double[] s, DoubleMatrix2D V, DoubleMatrix1D b, DoubleMatrix1D x) {
        DoubleMatrix1D bhat = new DenseDoubleMatrix1D(U.rows());
        U.zMult(b, bhat, 1.0, 0.0, true);
        double alpha = 0.0;
        switch (this.regMethod) {
            case GCV: {
                TikFmin2D fmin = new TikFmin2D(bhat, s, 1.0);
                alpha = DoubleFmin.fmin((double)0.0, (double)s[0], (DoubleFmin_methods)fmin, (double)1.0E-4);
                break;
            }
            case WGCV: {
                TikFmin2D fmin = new TikFmin2D(bhat, s, this.omega);
                alpha = DoubleFmin.fmin((double)0.0, (double)s[0], (DoubleFmin_methods)fmin, (double)1.0E-4);
                break;
            }
            case ADAPTWGCV: {
                TikFmin2D fmin = new TikFmin2D(bhat, s, this.omega);
                alpha = DoubleFmin.fmin((double)0.0, (double)s[0], (DoubleFmin_methods)fmin, (double)1.0E-4);
                break;
            }
            case NONE: {
                alpha = this.regPar;
            }
        }
        DenseDoubleMatrix1D d = new DenseDoubleMatrix1D(s);
        ((DoubleMatrix1D)d).assign(DoubleFunctions.square);
        ((DoubleMatrix1D)d).assign(DoubleFunctions.plus(alpha * alpha));
        bhat = bhat.viewPart(0, s.length);
        DenseDoubleMatrix1D S = new DenseDoubleMatrix1D(s);
        bhat.assign(S, DoubleFunctions.mult);
        bhat.assign(d, DoubleFunctions.div);
        V.zMult(bhat, x);
        return alpha;
    }

    private double GCVstopfun(double alpha, DoubleMatrix1D u, double[] s, double beta, int rows, int columns) {
        int k = s.length;
        double beta2 = beta * beta;
        DenseDoubleMatrix1D s2 = new DenseDoubleMatrix1D(s);
        ((DoubleMatrix1D)s2).assign(DoubleFunctions.square);
        double alpha2 = alpha * alpha;
        DoubleMatrix1D t1 = s2.copy();
        t1.assign(DoubleFunctions.plus(alpha2));
        t1.assign(DoubleFunctions.inv);
        DoubleMatrix1D t2 = t1.copy();
        t2.assign(u.viewPart(0, k), DoubleFunctions.mult);
        t2.assign(DoubleFunctions.mult(alpha2));
        double num = beta2 * (t2.aggregate(DoubleFunctions.plus, DoubleFunctions.square) + Math.pow(Math.abs(u.getQuick(k)), 2.0)) / (double)columns;
        double den = ((double)rows - t1.aggregate(s2, DoubleFunctions.plus, DoubleFunctions.mult)) / (double)columns;
        den *= den;
        return num / den;
    }

    private class DoublePLBD
    implements DoubleLBD {
        private final DenseDoubleAlgebra alg = DenseDoubleAlgebra.DEFAULT;
        private final DoubleFactory2D factory = DoubleFactory2D.dense;
        private final DoubleMatrix2D alphaBeta = new DenseDoubleMatrix2D(2, 1);
        private final DoublePreconditioner M;
        private final DoubleMatrix2D A;
        private DoubleMatrix2D C;
        private DoubleMatrix2D U;
        private DoubleMatrix2D V;
        private boolean reorth;
        private int counter = 1;

        public DoublePLBD(DoublePreconditioner M, DoubleMatrix2D A, DoubleMatrix2D U, boolean reorth) {
            this.M = M;
            this.A = A;
            this.reorth = reorth;
            this.U = U;
            this.V = null;
            this.C = null;
        }

        @Override
        public void apply() {
            if (this.reorth) {
                int k = this.U.rows();
                DoubleMatrix1D u = null;
                DoubleMatrix1D v = null;
                DoubleMatrix1D row = null;
                if (k == 1) {
                    row = this.U.viewRow(k - 1).copy();
                    row = this.M.transApply(row, row);
                    v = this.A.zMult(row, v, 1.0, 0.0, true);
                } else {
                    row = this.U.viewRow(k - 1).copy();
                    row = this.M.transApply(row, row);
                    v = this.A.zMult(row, v, 1.0, 0.0, true);
                    row = this.V.viewColumn(k - 2);
                    v.assign(row, DoubleFunctions.plusMultSecond(-this.C.getQuick(k - 1, k - 2)));
                    for (int j = 0; j < k - 1; ++j) {
                        row = this.V.viewColumn(j);
                        v.assign(row, DoubleFunctions.plusMultSecond(-row.zDotProduct(v)));
                    }
                }
                double alpha = this.alg.norm2(v);
                v.assign(DoubleFunctions.div(alpha));
                row = this.A.zMult(v, row);
                u = this.M.apply(row, u);
                row = this.U.viewRow(k - 1);
                u.assign(row, DoubleFunctions.plusMultSecond(-alpha));
                for (int j = 0; j < k; ++j) {
                    row = this.U.viewRow(j);
                    u.assign(row, DoubleFunctions.plusMultSecond(-row.zDotProduct(u)));
                }
                double beta = this.alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(DoubleFunctions.div(beta));
                this.U = this.factory.appendRow(this.U, u);
                if (this.V == null) {
                    this.V = new DenseColumnDoubleMatrix2D((int)v.size(), 1);
                    this.V.assign((double[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseDoubleMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
            } else {
                DoubleMatrix1D u = null;
                DoubleMatrix1D v = null;
                DoubleMatrix1D row = null;
                if (this.counter == 1) {
                    row = this.U.viewRow(0).copy();
                    row = this.M.transApply(row, row);
                    v = this.A.zMult(row, v, 1.0, 0.0, true);
                } else {
                    row = this.U.viewRow(0).copy();
                    row = this.M.transApply(row, row);
                    v = this.A.zMult(row, v, 1.0, 0.0, true);
                    row = this.V.viewColumn(this.counter - 2);
                    v.assign(row, DoubleFunctions.plusMultSecond(-this.C.getQuick(this.counter - 1, this.counter - 2)));
                }
                double alpha = this.alg.norm2(v);
                v.assign(DoubleFunctions.div(alpha));
                row = this.A.zMult(v, row);
                u = this.M.apply(row, u);
                row = this.U.viewRow(0);
                u.assign(row, DoubleFunctions.plusMultSecond(-alpha));
                double beta = this.alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(DoubleFunctions.div(beta));
                this.U.viewRow(0).assign(u);
                if (this.V == null) {
                    this.V = new DenseColumnDoubleMatrix2D((int)v.size(), 1);
                    this.V.assign((double[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseDoubleMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
                ++this.counter;
            }
        }

        @Override
        public DoubleMatrix2D getC() {
            return this.C;
        }

        @Override
        public DoubleMatrix2D getU() {
            return this.U;
        }

        @Override
        public DoubleMatrix2D getV() {
            return this.V;
        }
    }

    private class DoubleSimpleLBD
    implements DoubleLBD {
        private final DenseDoubleAlgebra alg = DenseDoubleAlgebra.DEFAULT;
        private final DoubleFactory2D factory = DoubleFactory2D.dense;
        private final DoubleMatrix2D alphaBeta = new DenseDoubleMatrix2D(2, 1);
        private final DoubleMatrix2D A;
        private DoubleMatrix2D C;
        private DoubleMatrix2D U;
        private DoubleMatrix2D V;
        private boolean reorth;
        private int counter = 1;

        public DoubleSimpleLBD(DoubleMatrix2D A, DoubleMatrix2D U, boolean reorth) {
            this.A = A;
            this.reorth = reorth;
            this.U = U;
            this.V = null;
            this.C = null;
        }

        @Override
        public void apply() {
            if (this.reorth) {
                int k = this.U.rows();
                DoubleMatrix1D u = null;
                DoubleMatrix1D v = null;
                DoubleMatrix1D column = null;
                if (k == 1) {
                    v = this.A.zMult(this.U.viewRow(k - 1), v, 1.0, 0.0, true);
                } else {
                    v = this.A.zMult(this.U.viewRow(k - 1), v, 1.0, 0.0, true);
                    column = this.V.viewColumn(k - 2);
                    v.assign(column, DoubleFunctions.plusMultSecond(-this.C.getQuick(k - 1, k - 2)));
                    for (int j = 0; j < k - 1; ++j) {
                        column = this.V.viewColumn(j);
                        v.assign(column, DoubleFunctions.plusMultSecond(-column.zDotProduct(v)));
                    }
                }
                double alpha = this.alg.norm2(v);
                v.assign(DoubleFunctions.div(alpha));
                u = this.A.zMult(v, u);
                column = this.U.viewRow(k - 1);
                u.assign(column, DoubleFunctions.plusMultSecond(-alpha));
                for (int j = 0; j < k; ++j) {
                    column = this.U.viewRow(j);
                    u.assign(column, DoubleFunctions.plusMultSecond(-column.zDotProduct(u)));
                }
                double beta = this.alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(DoubleFunctions.div(beta));
                this.U = this.factory.appendRow(this.U, u);
                if (this.V == null) {
                    this.V = new DenseColumnDoubleMatrix2D((int)v.size(), 1);
                    this.V.assign((double[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseDoubleMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
            } else {
                DoubleMatrix1D u = null;
                DoubleMatrix1D v = null;
                DoubleMatrix1D column = null;
                if (this.counter == 1) {
                    v = this.A.zMult(this.U.viewRow(0), v, 1.0, 0.0, true);
                } else {
                    v = this.A.zMult(this.U.viewRow(0), v, 1.0, 0.0, true);
                    column = this.V.viewColumn(this.counter - 2);
                    v.assign(column, DoubleFunctions.plusMultSecond(-this.C.getQuick(this.counter - 1, this.counter - 2)));
                }
                double alpha = this.alg.norm2(v);
                v.assign(DoubleFunctions.div(alpha));
                u = this.A.zMult(v, u);
                column = this.U.viewRow(0);
                u.assign(column, DoubleFunctions.plusMultSecond(-alpha));
                double beta = this.alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(DoubleFunctions.div(beta));
                this.U.viewRow(0).assign(u);
                if (this.V == null) {
                    this.V = new DenseColumnDoubleMatrix2D((int)v.size(), 1);
                    this.V.assign((double[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseDoubleMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
                ++this.counter;
            }
        }

        @Override
        public DoubleMatrix2D getC() {
            return this.C;
        }

        @Override
        public DoubleMatrix2D getU() {
            return this.U;
        }

        @Override
        public DoubleMatrix2D getV() {
            return this.V;
        }
    }

    private static interface DoubleLBD {
        public void apply();

        public DoubleMatrix2D getC();

        public DoubleMatrix2D getU();

        public DoubleMatrix2D getV();
    }

    private static class TikFmin2D
    implements DoubleFmin_methods {
        DoubleMatrix1D bhat;
        double[] s;
        double omega;

        public TikFmin2D(DoubleMatrix1D bhat, double[] s, double omega) {
            this.bhat = bhat;
            this.s = s;
            this.omega = omega;
        }

        public double f_to_minimize(double alpha) {
            int m = (int)this.bhat.size();
            int n = this.s.length;
            double t0 = this.bhat.viewPart(n, m - n).aggregate(DoubleFunctions.plus, DoubleFunctions.square);
            DenseDoubleMatrix1D s2 = new DenseDoubleMatrix1D(this.s);
            ((DoubleMatrix1D)s2).assign(DoubleFunctions.square);
            double alpha2 = alpha * alpha;
            DoubleMatrix1D work = s2.copy();
            work.assign(DoubleFunctions.plus(alpha2));
            work.assign(DoubleFunctions.inv);
            DoubleMatrix1D t1 = work.copy();
            t1.assign(DoubleFunctions.mult(alpha2));
            DoubleMatrix1D t2 = t1.copy();
            t2.assign(this.bhat.viewPart(0, n), DoubleFunctions.mult);
            DoubleMatrix1D t3 = work.copy();
            t3.assign(s2, DoubleFunctions.mult);
            t3.assign(DoubleFunctions.mult(1.0 - this.omega));
            double denom = t3.aggregate(t1, DoubleFunctions.plus, DoubleFunctions.plus) + (double)m - (double)n;
            return (double)n * (t2.aggregate(DoubleFunctions.plus, DoubleFunctions.square) + t0) / (denom * denom);
        }
    }
}

