/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import cern.jet.math.tdcomplex.DComplexPlusMultSecond;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalDComplexMatrix2D(double[][] values, int dindex) {
        this(values.length, values.length == 0 ? 0 : values[0].length, dindex);
        this.assign(values);
    }

    public DiagonalDComplexMatrix2D(int rows, int columns, int dindex) {
        int diff;
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        if (dindex < -rows + 1 || dindex > columns - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = dindex;
        this.dlength = dindex == 0 ? Math.min(rows, columns) : (dindex > 0 ? (rows >= columns ? columns - dindex : (dindex <= (diff = columns - rows) ? rows : rows - (dindex - diff))) : (rows >= columns ? (-dindex <= (diff = rows - columns) ? columns : columns + dindex + diff) : rows + dindex));
        this.elements = new double[2 * this.dlength];
    }

    @Override
    public DComplexMatrix2D assign(DComplexDComplexFunction function) {
        if (function instanceof DComplexMult) {
            double[] alpha = ((DComplexMult)function).multiplicator;
            if (alpha[0] == 1.0 && alpha[1] == 0.0) {
                return this;
            }
            if (alpha[0] == 0.0 && alpha[1] == 0.0) {
                return this.assign(alpha);
            }
            if (alpha[0] != alpha[0] || alpha[1] != alpha[1]) {
                return this.assign(alpha);
            }
            double[] elem = new double[2];
            for (int j = 0; j < this.dlength; ++j) {
                elem[0] = this.elements[2 * j];
                elem[1] = this.elements[2 * j + 1];
                elem = DComplex.mult(elem, alpha);
                this.elements[2 * j] = elem[0];
                this.elements[2 * j + 1] = elem[1];
            }
        } else {
            double[] elem = new double[2];
            for (int j = 0; j < this.dlength; ++j) {
                elem[0] = this.elements[2 * j];
                elem[1] = this.elements[2 * j + 1];
                elem = function.apply(elem);
                this.elements[2 * j] = elem[0];
                this.elements[2 * j + 1] = elem[1];
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(double re, double im) {
        for (int j = 0; j < this.dlength; ++j) {
            this.elements[2 * j] = re;
            this.elements[2 * j + 1] = im;
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double[] values) {
        if (values.length != 2 * this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " 2*dlength=" + 2 * this.dlength);
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            int k = this.dlength / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.dlength : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DiagonalDComplexMatrix2D.this.elements[2 * i] = values[2 * i];
                            DiagonalDComplexMatrix2D.this.elements[2 * i + 1] = values[2 * i + 1];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                this.elements[2 * i] = values[2 * i];
                this.elements[2 * i + 1] = values[2 * i + 1];
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final float[] values) {
        if (values.length != 2 * this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " 2*dlength=" + 2 * this.dlength);
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            int k = this.dlength / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.dlength : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DiagonalDComplexMatrix2D.this.elements[2 * i] = values[2 * i];
                            DiagonalDComplexMatrix2D.this.elements[2 * i + 1] = values[2 * i + 1];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                this.elements[2 * i] = values[2 * i];
                this.elements[2 * i + 1] = values[2 * i + 1];
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(double[][] values) {
        int c;
        int r;
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            r = 0;
            c = this.dindex;
        } else {
            r = -this.dindex;
            c = 0;
        }
        for (int i = 0; i < this.dlength; ++i) {
            if (values[i].length != 2 * this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + values[r].length + "2 * columns()=" + 2 * this.columns());
            }
            this.elements[2 * i] = values[r][2 * c];
            this.elements[2 * i + 1] = values[r][2 * c + 1];
            ++c;
            ++r;
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof DiagonalDComplexMatrix2D) {
            DiagonalDComplexMatrix2D other = (DiagonalDComplexMatrix2D)source;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("source is DiagonalDComplexMatrix2D with different diagonal stored.");
            }
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D y, final DComplexDComplexDComplexFunction function) {
        this.checkShape(y);
        if (y instanceof DiagonalDComplexMatrix2D) {
            double[] alpha;
            DiagonalDComplexMatrix2D other = (DiagonalDComplexMatrix2D)y;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("y is DiagonalDComplexMatrix2D with different diagonal stored.");
            }
            if (function instanceof DComplexPlusMultSecond && (alpha = ((DComplexPlusMultSecond)function).multiplicator)[0] == 0.0 && alpha[1] == 0.0) {
                return this;
            }
            final double[] otherElements = other.elements;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.dlength);
                Future[] futures = new Future[nthreads];
                int k = this.dlength / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? this.dlength : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (function instanceof DComplexPlusMultSecond) {
                                double[] alpha = ((DComplexPlusMultSecond)function).multiplicator;
                                if (alpha[0] == 1.0 && alpha[1] == 0.0) {
                                    for (int j = firstIdx; j < lastIdx; ++j) {
                                        int n = 2 * j;
                                        DiagonalDComplexMatrix2D.this.elements[n] = DiagonalDComplexMatrix2D.this.elements[n] + otherElements[2 * j];
                                        int n2 = 2 * j + 1;
                                        DiagonalDComplexMatrix2D.this.elements[n2] = DiagonalDComplexMatrix2D.this.elements[n2] + otherElements[2 * j + 1];
                                    }
                                } else {
                                    double[] elem = new double[2];
                                    for (int j = firstIdx; j < lastIdx; ++j) {
                                        elem[0] = otherElements[2 * j];
                                        elem[1] = otherElements[2 * j + 1];
                                        elem = DComplex.mult(alpha, elem);
                                        int n = 2 * j;
                                        DiagonalDComplexMatrix2D.this.elements[n] = DiagonalDComplexMatrix2D.this.elements[n] + elem[0];
                                        int n3 = 2 * j + 1;
                                        DiagonalDComplexMatrix2D.this.elements[n3] = DiagonalDComplexMatrix2D.this.elements[n3] + elem[1];
                                    }
                                }
                            } else if (function == DComplexFunctions.mult) {
                                double[] elem = new double[2];
                                double[] otherElem = new double[2];
                                for (int j = firstIdx; j < lastIdx; ++j) {
                                    otherElem[0] = otherElements[2 * j];
                                    otherElem[1] = otherElements[2 * j + 1];
                                    elem[0] = DiagonalDComplexMatrix2D.this.elements[2 * j];
                                    elem[1] = DiagonalDComplexMatrix2D.this.elements[2 * j + 1];
                                    elem = DComplex.mult(elem, otherElem);
                                    DiagonalDComplexMatrix2D.this.elements[2 * j] = elem[0];
                                    DiagonalDComplexMatrix2D.this.elements[2 * j + 1] = elem[1];
                                }
                            } else if (function == DComplexFunctions.div) {
                                double[] elem = new double[2];
                                double[] otherElem = new double[2];
                                for (int j = firstIdx; j < lastIdx; ++j) {
                                    otherElem[0] = otherElements[2 * j];
                                    otherElem[1] = otherElements[2 * j + 1];
                                    elem[0] = DiagonalDComplexMatrix2D.this.elements[2 * j];
                                    elem[1] = DiagonalDComplexMatrix2D.this.elements[2 * j + 1];
                                    elem = DComplex.div(elem, otherElem);
                                    DiagonalDComplexMatrix2D.this.elements[2 * j] = elem[0];
                                    DiagonalDComplexMatrix2D.this.elements[2 * j + 1] = elem[1];
                                }
                            } else {
                                double[] elem = new double[2];
                                double[] otherElem = new double[2];
                                for (int j = firstIdx; j < lastIdx; ++j) {
                                    otherElem[0] = otherElements[2 * j];
                                    otherElem[1] = otherElements[2 * j + 1];
                                    elem[0] = DiagonalDComplexMatrix2D.this.elements[2 * j];
                                    elem[1] = DiagonalDComplexMatrix2D.this.elements[2 * j + 1];
                                    elem = function.apply(elem, otherElem);
                                    DiagonalDComplexMatrix2D.this.elements[2 * j] = elem[0];
                                    DiagonalDComplexMatrix2D.this.elements[2 * j + 1] = elem[1];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else if (function instanceof DComplexPlusMultSecond) {
                double[] alpha2 = ((DComplexPlusMultSecond)function).multiplicator;
                if (alpha2[0] == 1.0 && alpha2[1] == 0.0) {
                    for (int j = 0; j < this.dlength; ++j) {
                        int n = 2 * j;
                        this.elements[n] = this.elements[n] + otherElements[2 * j];
                        int n2 = 2 * j + 1;
                        this.elements[n2] = this.elements[n2] + otherElements[2 * j + 1];
                    }
                } else {
                    double[] elem = new double[2];
                    for (int j = 0; j < this.dlength; ++j) {
                        elem[0] = otherElements[2 * j];
                        elem[1] = otherElements[2 * j + 1];
                        elem = DComplex.mult(alpha2, elem);
                        int n = 2 * j;
                        this.elements[n] = this.elements[n] + elem[0];
                        int n3 = 2 * j + 1;
                        this.elements[n3] = this.elements[n3] + elem[1];
                    }
                }
            } else if (function == DComplexFunctions.mult) {
                double[] elem = new double[2];
                double[] otherElem = new double[2];
                for (int j = 0; j < this.dlength; ++j) {
                    otherElem[0] = otherElements[2 * j];
                    otherElem[1] = otherElements[2 * j + 1];
                    elem[0] = this.elements[2 * j];
                    elem[1] = this.elements[2 * j + 1];
                    elem = DComplex.mult(elem, otherElem);
                    this.elements[2 * j] = elem[0];
                    this.elements[2 * j + 1] = elem[1];
                }
            } else if (function == DComplexFunctions.div) {
                double[] elem = new double[2];
                double[] otherElem = new double[2];
                for (int j = 0; j < this.dlength; ++j) {
                    otherElem[0] = otherElements[2 * j];
                    otherElem[1] = otherElements[2 * j + 1];
                    elem[0] = this.elements[2 * j];
                    elem[1] = this.elements[2 * j + 1];
                    elem = DComplex.div(elem, otherElem);
                    this.elements[2 * j] = elem[0];
                    this.elements[2 * j + 1] = elem[1];
                }
            } else {
                double[] elem = new double[2];
                double[] otherElem = new double[2];
                for (int j = 0; j < this.dlength; ++j) {
                    otherElem[0] = otherElements[2 * j];
                    otherElem[1] = otherElements[2 * j + 1];
                    elem[0] = this.elements[2 * j];
                    elem[1] = this.elements[2 * j + 1];
                    elem = function.apply(elem, otherElem);
                    this.elements[2 * j] = elem[0];
                    this.elements[2 * j + 1] = elem[1];
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.dlength / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.dlength : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            if (DiagonalDComplexMatrix2D.this.elements[2 * i] == 0.0 && DiagonalDComplexMatrix2D.this.elements[2 * i + 1] == 0.0) continue;
                            ++cardinality;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                if (this.elements[2 * i] == 0.0 && this.elements[2 * i + 1] == 0.0) continue;
                ++cardinality;
            }
        }
        return cardinality;
    }

    public double[] elements() {
        return this.elements;
    }

    @Override
    public boolean equals(double[] value) {
        double epsilon = DComplexProperty.DEFAULT.tolerance();
        double[] x = new double[2];
        double[] diff = new double[2];
        for (int i = 0; i < this.dlength; ++i) {
            x[0] = this.elements[2 * i];
            x[1] = this.elements[2 * i + 1];
            diff[0] = Math.abs(value[0] - x[0]);
            diff[1] = Math.abs(value[1] - x[1]);
            if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                diff[0] = 0.0;
                diff[1] = 0.0;
            }
            if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DiagonalDComplexMatrix2D) {
            DiagonalDComplexMatrix2D other = (DiagonalDComplexMatrix2D)obj;
            double epsilon = DComplexProperty.DEFAULT.tolerance();
            if (this == obj) {
                return true;
            }
            if (this == null || obj == null) {
                return false;
            }
            int rows = this.rows();
            int columns = this.columns();
            if (columns != other.columns() || rows != other.rows()) {
                return false;
            }
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                return false;
            }
            double[] otherElements = other.elements;
            double[] x = new double[2];
            double[] value = new double[2];
            double[] diff = new double[2];
            for (int i = 0; i < this.dlength; ++i) {
                x[0] = this.elements[2 * i];
                x[1] = this.elements[2 * i + 1];
                value[0] = otherElements[2 * i];
                value[1] = otherElements[2 * i + 1];
                diff[0] = Math.abs(value[0] - x[0]);
                diff[1] = Math.abs(value[1] - x[1]);
                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                    diff[0] = 0.0;
                    diff[1] = 0.0;
                }
                if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public DComplexMatrix2D forEachNonZero(IntIntDComplexFunction function) {
        double[] value = new double[2];
        for (int i = 0; i < this.dlength; ++i) {
            value[0] = this.elements[2 * i];
            value[1] = this.elements[2 * i + 1];
            if (value[0] == 0.0 && value[1] == 0.0) continue;
            value = function.apply(i, i, value);
            this.elements[2 * i] = value[0];
            this.elements[2 * i + 1] = value[1];
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    @Override
    public double[] getQuick(int row, int column) {
        if (this.dindex >= 0) {
            if (column < this.dindex) {
                return new double[2];
            }
            if (row < this.dlength && row + this.dindex == column) {
                return new double[]{this.elements[2 * row], this.elements[2 * row + 1]};
            }
            return new double[2];
        }
        if (row < -this.dindex) {
            return new double[2];
        }
        if (column < this.dlength && row + this.dindex == column) {
            return new double[]{this.elements[2 * column], this.elements[2 * column + 1]};
        }
        return new double[2];
    }

    @Override
    public DComplexMatrix2D like(int rows, int columns) {
        return new SparseDComplexMatrix2D(rows, columns);
    }

    @Override
    public DComplexMatrix1D like1D(int size) {
        return new SparseDComplexMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, double[] value) {
        if (this.dindex >= 0) {
            if (column >= this.dindex && row < this.dlength && row + this.dindex == column) {
                this.elements[2 * row] = value[0];
                this.elements[2 * row + 1] = value[1];
            }
        } else if (row >= -this.dindex && column < this.dlength && row + this.dindex == column) {
            this.elements[2 * column] = value[0];
            this.elements[2 * column + 1] = value[1];
        }
    }

    @Override
    public void setQuick(int row, int column, double re, double im) {
        if (this.dindex >= 0) {
            if (column >= this.dindex && row < this.dlength && row + this.dindex == column) {
                this.elements[2 * row] = re;
                this.elements[2 * row + 1] = im;
            }
        } else if (row >= -this.dindex && column < this.dlength && row + this.dindex == column) {
            this.elements[2 * column] = re;
            this.elements[2 * column + 1] = im;
        }
    }

    @Override
    public DComplexMatrix1D zMult(DComplexMatrix1D y, DComplexMatrix1D z, double[] alpha, double[] beta, boolean transposeA) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        boolean bl = ignore = z == null;
        if (z == null) {
            z = new DenseDComplexMatrix1D(rowsA);
        }
        if (!(this.isNoView && y instanceof DenseDComplexMatrix1D && z instanceof DenseDComplexMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!(ignore || beta[0] == 1.0 && beta[1] == 0.0)) {
            z.assign(DComplexFunctions.mult(beta));
        }
        DenseDComplexMatrix1D zz = (DenseDComplexMatrix1D)z;
        double[] elementsZ = zz.elements;
        int strideZ = zz.stride();
        int zeroZ = (int)z.index(0);
        DenseDComplexMatrix1D yy = (DenseDComplexMatrix1D)y;
        double[] elementsY = yy.elements;
        int strideY = yy.stride();
        int zeroY = (int)y.index(0);
        if (elementsY == null || elementsZ == null) {
            throw new InternalError();
        }
        double[] elemA = new double[2];
        double[] elemY = new double[2];
        if (!transposeA) {
            if (this.dindex >= 0) {
                for (int i = 0; i < this.dlength; ++i) {
                    elemA[0] = this.elements[2 * i];
                    elemA[1] = this.elements[2 * i + 1];
                    elemY[0] = elementsY[2 * this.dindex + zeroY + strideY * i];
                    elemY[1] = elementsY[2 * this.dindex + zeroY + strideY * i + 1];
                    elemA = DComplex.mult(elemA, elemY);
                    elemA = DComplex.mult(alpha, elemA);
                    int n = zeroZ + strideZ * i;
                    elementsZ[n] = elementsZ[n] + elemA[0];
                    int n2 = zeroZ + strideZ * i + 1;
                    elementsZ[n2] = elementsZ[n2] + elemA[1];
                }
            } else {
                for (int i = 0; i < this.dlength; ++i) {
                    elemA[0] = this.elements[2 * i];
                    elemA[1] = this.elements[2 * i + 1];
                    elemY[0] = elementsY[zeroY + strideY * i];
                    elemY[1] = elementsY[zeroY + strideY * i + 1];
                    elemA = DComplex.mult(elemA, elemY);
                    elemA = DComplex.mult(alpha, elemA);
                    int n = -2 * this.dindex + zeroZ + strideZ * i;
                    elementsZ[n] = elementsZ[n] + elemA[0];
                    int n3 = -2 * this.dindex + zeroZ + strideZ * i + 1;
                    elementsZ[n3] = elementsZ[n3] + elemA[1];
                }
            }
        } else if (this.dindex >= 0) {
            for (int i = 0; i < this.dlength; ++i) {
                elemA[0] = this.elements[2 * i];
                elemA[1] = -this.elements[2 * i + 1];
                elemY[0] = elementsY[zeroY + strideY * i];
                elemY[1] = elementsY[zeroY + strideY * i + 1];
                elemA = DComplex.mult(elemA, elemY);
                elemA = DComplex.mult(alpha, elemA);
                int n = 2 * this.dindex + zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + elemA[0];
                int n4 = 2 * this.dindex + zeroZ + strideZ * i + 1;
                elementsZ[n4] = elementsZ[n4] + elemA[1];
            }
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                elemA[0] = this.elements[2 * i];
                elemA[1] = -this.elements[2 * i + 1];
                elemY[0] = elementsY[-2 * this.dindex + zeroY + strideY * i];
                elemY[1] = elementsY[-2 * this.dindex + zeroY + strideY * i + 1];
                elemA = DComplex.mult(elemA, elemY);
                elemA = DComplex.mult(alpha, elemA);
                int n = zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + elemA[0];
                int n5 = zeroZ + strideZ * i + 1;
                elementsZ[n5] = elementsZ[n5] + elemA[1];
            }
        }
        return z;
    }

    @Override
    protected DComplexMatrix2D getContent() {
        return this;
    }
}

