/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list.tshort;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.tshort.ShortProcedure;
import cern.colt.list.tshort.AbstractShortList;
import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DRand;
import java.util.Date;

public class ShortArrayList
extends AbstractShortList {
    private static final long serialVersionUID = 1L;
    protected short[] elements;

    public ShortArrayList() {
        this(10);
    }

    public ShortArrayList(short[] elements) {
        this.elements(elements);
    }

    public ShortArrayList(int initialCapacity) {
        this(new short[initialCapacity]);
        this.setSizeRaw(0);
    }

    @Override
    public void add(short element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void beforeInsert(int index, short element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public int binarySearchFromTo(short key, int from, int to) {
        return Sorting.binarySearchFromTo(this.elements, key, from, to);
    }

    @Override
    public Object clone() {
        ShortArrayList clone = new ShortArrayList((short[])this.elements.clone());
        clone.setSizeRaw(this.size);
        return clone;
    }

    public ShortArrayList copy() {
        return (ShortArrayList)this.clone();
    }

    protected void countSortFromTo(int from, int to, short min, short max) {
        if (this.size == 0) {
            return;
        }
        ShortArrayList.checkRangeFromTo(from, to, this.size);
        int width = max - min + 1;
        int[] counts = new int[width];
        short[] theElements = this.elements;
        int i = from;
        while (i <= to) {
            int n = theElements[i++] - min;
            counts[n] = counts[n] + 1;
        }
        int fromIndex = from;
        short val = min;
        int i2 = 0;
        while (i2 < width) {
            int c = counts[i2];
            if (c > 0) {
                if (c == 1) {
                    theElements[fromIndex++] = val;
                } else {
                    int toIndex = fromIndex + c - 1;
                    this.fillFromToWith(fromIndex, toIndex, val);
                    fromIndex = toIndex + 1;
                }
            }
            ++i2;
            val = (short)(val + 1);
        }
    }

    @Override
    public short[] elements() {
        return this.elements;
    }

    @Override
    public AbstractShortList elements(short[] elements) {
        this.elements = elements;
        this.size = elements.length;
        return this;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    @Override
    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof ShortArrayList)) {
            return super.equals(otherObj);
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        ShortArrayList other = (ShortArrayList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        short[] theElements = this.elements();
        short[] otherElements = other.elements();
        int i = this.size();
        while (--i >= 0) {
            if (theElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEach(ShortProcedure procedure) {
        short[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public short get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    @Override
    public short getQuick(int index) {
        return this.elements[index];
    }

    @Override
    public int indexOfFromTo(short element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        ShortArrayList.checkRangeFromTo(from, to, this.size);
        short[] theElements = this.elements;
        for (int i = from; i <= to; ++i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfFromTo(short element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        ShortArrayList.checkRangeFromTo(from, to, this.size);
        short[] theElements = this.elements;
        for (int i = to; i >= from; --i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AbstractShortList partFromTo(int from, int to) {
        if (this.size == 0) {
            return new ShortArrayList(0);
        }
        ShortArrayList.checkRangeFromTo(from, to, this.size);
        short[] part = new short[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new ShortArrayList(part);
    }

    @Override
    public boolean removeAll(AbstractShortList other) {
        double M;
        if (!(other instanceof ShortArrayList)) {
            return super.removeAll(other);
        }
        if (other.size() == 0) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        short[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * DoubleArithmetic.log2(N) < M * N) {
            ShortArrayList sortedList = (ShortArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void replaceFromToWithFrom(int from, int to, AbstractShortList other, int otherFrom) {
        if (!(other instanceof ShortArrayList)) {
            super.replaceFromToWithFrom(from, to, other, otherFrom);
            return;
        }
        int length = to - from + 1;
        if (length > 0) {
            ShortArrayList.checkRangeFromTo(from, to, this.size());
            ShortArrayList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            System.arraycopy(((ShortArrayList)other).elements, otherFrom, this.elements, from, length);
        }
    }

    @Override
    public boolean retainAll(AbstractShortList other) {
        double M;
        if (!(other instanceof ShortArrayList)) {
            return super.retainAll(other);
        }
        int limit = other.size() - 1;
        int j = 0;
        short[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * DoubleArithmetic.log2(N) < M * N) {
            ShortArrayList sortedList = (ShortArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        short[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            short tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    @Override
    public void set(int index, short element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    @Override
    public void setQuick(int index, short element) {
        this.elements[index] = element;
    }

    @Override
    public void shuffleFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        ShortArrayList.checkRangeFromTo(from, to, this.size);
        DoubleUniform gen = new DoubleUniform(new DRand(new Date()));
        short[] theElements = this.elements;
        for (int i = from; i < to; ++i) {
            int random = gen.nextIntFromTo(i, to);
            short tmpElement = theElements[random];
            theElements[random] = theElements[i];
            theElements[i] = tmpElement;
        }
    }

    @Override
    public void sortFromTo(int from, int to) {
        int widthThreshold = 10000;
        if (this.size == 0) {
            return;
        }
        ShortArrayList.checkRangeFromTo(from, to, this.size);
        short min = this.elements[from];
        short max = this.elements[from];
        short[] theElements = this.elements;
        int i = from + 1;
        while (i <= to) {
            short elem;
            if ((elem = theElements[i++]) > max) {
                max = elem;
                continue;
            }
            if (elem >= min) continue;
            min = elem;
        }
        double N = (double)to - (double)from + 1.0;
        double quickSortEstimate = N * Math.log(N) / 0.6931471805599453;
        double width = (double)max - (double)min + 1.0;
        double countSortEstimate = Math.max(width, N);
        if (width < 10000.0 && countSortEstimate < quickSortEstimate) {
            this.countSortFromTo(from, to, min, max);
        } else {
            this.quickSortFromTo(from, to);
        }
    }

    @Override
    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

