/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client.eval.api;

import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.eval.BooleanVariable;
import org.matheclipse.parser.client.eval.api.IASTVisitor;
import org.matheclipse.parser.client.operator.ASTNodeFactory;

public class ObjectEvaluator<DATA, DATA_VARIABLE, USER_DATA_TYPE> {
    protected ASTNode fNode;
    protected IASTVisitor<DATA, DATA_VARIABLE, USER_DATA_TYPE> fVisitor;
    protected final boolean fRelaxedSyntax;

    public ObjectEvaluator(IASTVisitor<DATA, DATA_VARIABLE, USER_DATA_TYPE> visitor, boolean relaxedSyntax) {
        this.fVisitor = visitor;
        this.fRelaxedSyntax = relaxedSyntax;
    }

    public DATA evaluateNode(ASTNode node) {
        return this.evaluateNode(node, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DATA evaluateNode(ASTNode node, USER_DATA_TYPE data) {
        try {
            this.fVisitor.setUp(data);
            Object DATA = this.fVisitor.evaluateNode(node);
            return DATA;
        }
        finally {
            this.fVisitor.tearDown();
        }
    }

    public void defineVariable(String variableName, DATA_VARIABLE value) {
        this.fVisitor.defineVariable(variableName, value);
    }

    public DATA_VARIABLE getVariable(String variableName) {
        return this.fVisitor.getVariable(variableName);
    }

    public void defineVariable(String variableName, BooleanVariable value) {
        this.fVisitor.defineVariable(variableName, value);
    }

    public void clearVariables() {
        this.fVisitor.clearVariables();
    }

    public ASTNode optimizeFunction(FunctionNode functionNode) {
        return this.fVisitor.optimizeFunction(functionNode);
    }

    public DATA evaluate(String expression) {
        Parser p = this.fRelaxedSyntax ? new Parser(ASTNodeFactory.RELAXED_STYLE_FACTORY, true) : new Parser(ASTNodeFactory.MMA_STYLE_FACTORY, false);
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.fVisitor.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.evaluateNode(this.fNode);
    }

    public DATA evaluate() {
        if (this.fNode == null) {
            throw new SyntaxError(0, 0, 0, " ", "No parser input defined", 1);
        }
        return this.evaluateNode(this.fNode);
    }
}

