/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.visit.AbstractVisitor;

public class VisitorReplacePart
extends AbstractVisitor<IExpr> {
    final IExpr fReplaceExpr;
    int[] fPositions;

    public VisitorReplacePart(IAST rule) {
        IExpr fromPositions = (IExpr)rule.get(1);
        this.fReplaceExpr = (IExpr)rule.get(2);
        if (fromPositions.isList()) {
            IAST list = (IAST)fromPositions;
            this.fPositions = new int[list.size() - 1];
            for (int j = 1; j < list.size(); ++j) {
                this.fPositions[j - 1] = Validate.checkIntType(list, j);
            }
        } else {
            this.fPositions = new int[1];
            this.fPositions[0] = Validate.checkIntType(rule, 1);
        }
    }

    private IExpr visitIndex(IAST ast, int index) {
        int position = this.fPositions[index];
        if (position >= ast.size()) {
            return ast;
        }
        IAST result = ast.clone();
        if (index == this.fPositions.length - 1) {
            result.set(position, this.fReplaceExpr);
        } else {
            IExpr arg = (IExpr)result.get(position);
            if (arg.isAST()) {
                result.set(position, this.visitIndex((IAST)arg, index + 1));
            }
        }
        return result;
    }

    @Override
    public IExpr visit(IAST ast) {
        return this.visitIndex(ast, 0);
    }
}

