/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.stat.descriptive.summary;

import java.io.Serializable;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.stat.descriptive.AbstractSymbolicStorelessUnivariateStatistic;

public class SymbolicProduct
extends AbstractSymbolicStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -2480199540073305051L;
    private long n = 0L;
    private IExpr value = F.C1;

    @Override
    public void increment(IExpr d) {
        this.value = F.eval(F.Times(this.value, d));
        ++this.n;
    }

    @Override
    public IExpr getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = F.C1;
        this.n = 0L;
    }

    @Override
    public IExpr evaluate(IAST values, int begin, int length) {
        if (this.test(values, begin, length, true)) {
            IAST product = F.Times();
            for (int i = begin; i < begin + length; ++i) {
                product.add(values.get(i));
            }
            return product;
        }
        return null;
    }

    public IExpr evaluate(IAST values, IAST weights, int begin, int length) {
        if (this.test(values, weights, begin, length, true)) {
            IAST product = F.Times();
            for (int i = begin; i < begin + length; ++i) {
                product.add(F.Power((IExpr)values.get(i), (IExpr)weights.get(i)));
            }
            if (product.size() > 1) {
                return F.eval(product);
            }
        }
        return null;
    }

    public IExpr evaluate(IAST values, IAST weights) {
        return this.evaluate(values, weights, 1, values.size() - 1);
    }
}

