/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.stat.descriptive;

import java.io.Serializable;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.stat.descriptive.AbstractSymbolicStorelessUnivariateStatistic;
import org.matheclipse.core.stat.descriptive.summary.SymbolicProduct;
import org.matheclipse.core.stat.descriptive.summary.SymbolicSumOfLogs;

public class SymbolicGeometricMean
extends AbstractSymbolicStorelessUnivariateStatistic
implements Serializable {
    private AbstractSymbolicStorelessUnivariateStatistic product;

    public SymbolicGeometricMean() {
        this.product = new SymbolicProduct();
    }

    public SymbolicGeometricMean(SymbolicSumOfLogs sumOfLogs) {
        this.product = sumOfLogs;
    }

    @Override
    public void increment(IExpr d) {
        this.product.increment(d);
    }

    @Override
    public IExpr getResult() {
        if (this.product.getN() > 0L) {
            return F.eval(F.Exp(F.Divide(this.product.getResult(), F.integer(this.product.getN()))));
        }
        return null;
    }

    @Override
    public void clear() {
        this.product.clear();
    }

    @Override
    public IExpr evaluate(IAST values, int begin, int length) {
        return F.eval(F.Power(this.product.evaluate(values, begin, length), F.fraction(1L, length)));
    }

    @Override
    public long getN() {
        return this.product.getN();
    }

    public void setSumLogImpl(AbstractSymbolicStorelessUnivariateStatistic sumLogImpl) {
        this.checkEmpty();
        this.product = sumLogImpl;
    }

    public AbstractSymbolicStorelessUnivariateStatistic getSumLogImpl() {
        return this.product;
    }

    private void checkEmpty() {
        if (this.getN() > 0L) {
            throw new MathIllegalStateException((Localizable)LocalizedFormats.VALUES_ADDED_BEFORE_CONFIGURING_STATISTIC, new Object[]{this.getN()});
        }
    }
}

