/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;

public class StringDrop
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        if (ast.arg1() instanceof IStringX && ast.arg2().isInteger()) {
            String s = ast.arg1().toString();
            int n = Validate.checkIntType(ast, 2, Integer.MIN_VALUE);
            if (n >= 0) {
                return F.stringx(s.substring(n, s.length()));
            }
            return F.stringx(s.substring(0, s.length() + n));
        }
        return null;
    }
}

