/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.List;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;

public class SquareFreeQ
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        if (ast.arg1().isRational()) {
            return null;
        }
        ExprVariables eVar = new ExprVariables(ast.arg1());
        if (eVar.isSize(0)) {
            if (ast.arg1().isAtom()) {
                return F.False;
            }
            eVar.add(F.$s("x"));
        }
        if (!eVar.isSize(1)) {
            throw new WrongArgumentType(ast, ast.arg1(), 1, "SquareFreeQ only implemented for univariate polynomials");
        }
        try {
            IExpr expr = F.evalExpandAll(ast.arg1());
            ASTRange r = new ASTRange(eVar.getVarList(), 1);
            List<IExpr> varList = r.toList();
            if (ast.size() == 3) {
                return F.bool(SquareFreeQ.isSquarefreeWithOption(ast, expr, varList));
            }
            return F.bool(SquareFreeQ.isSquarefree(expr, varList));
        }
        catch (JASConversionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isSquarefree(IExpr expr, List<IExpr> varList) throws JASConversionException {
        JASConvert jas = new JASConvert((List<? extends IExpr>)varList, BigRational.ZERO);
        GenPolynomial poly = jas.expr2JAS(expr);
        FactorAbstract factorAbstract = FactorFactory.getImplementation((BigRational)BigRational.ONE);
        return factorAbstract.isSquarefree(poly);
    }

    public static boolean isSquarefreeWithOption(IAST lst, IExpr expr, List<IExpr> varList) throws JASConversionException {
        Options options = new Options(lst.topHead(), lst, 2);
        IExpr option = options.getOption("Modulus");
        if (option != null && option.isSignedNumber()) {
            ModIntegerRing modIntegerRing = JASConvert.option2ModIntegerRing((ISignedNumber)option);
            JASConvert jas = new JASConvert((List<? extends IExpr>)varList, modIntegerRing);
            GenPolynomial poly = jas.expr2JAS(expr);
            FactorAbstract factorAbstract = FactorFactory.getImplementation((ModIntegerRing)modIntegerRing);
            return factorAbstract.isSquarefree(poly);
        }
        return false;
    }
}

