/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Function;
import org.matheclipse.core.builtin.function.NumericQ;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Round
extends AbstractFunctionEvaluator
implements INumeric {
    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        return Math.round(stack[top]);
    }

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        try {
            IAST[] result;
            IExpr arg1 = ast.arg1();
            if (arg1.isSignedNumber()) {
                return ((ISignedNumber)arg1).round();
            }
            if (NumericQ.CONST.apply(arg1) && (result = F.evaln(arg1)).isSignedNumber()) {
                return ((ISignedNumber)result).round();
            }
            if (arg1.isPlus() && (result = ((IAST)arg1).split(new RoundPlusFunction()))[0].size() > 1) {
                if (result[1].size() > 1) {
                    result[0].add(F.Round(result[1]));
                }
                return result[0];
            }
            if (AbstractFunctionEvaluator.isNegativeExpression(arg1)) {
                return F.Times((IExpr)F.CN1, (IExpr)F.Round(F.Times((IExpr)F.CN1, arg1)));
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(25728);
        super.setUp(symbol);
    }

    private final class RoundPlusFunction
    implements Function<IExpr, IExpr> {
        private RoundPlusFunction() {
        }

        public IExpr apply(IExpr expr) {
            if (expr.isInteger()) {
                return expr;
            }
            return null;
        }
    }
}

