/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Rational
extends AbstractFunctionEvaluator {
    public static final Rational CONST = new Rational();

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        try {
            ISignedNumber numerator;
            IExpr arg0 = ast.arg1();
            IExpr arg1 = ast.arg2();
            if (!(arg0.isInteger() && arg1.isInteger() || arg0 instanceof INum && arg1 instanceof INum)) {
                EvalEngine engine = EvalEngine.get();
                arg0 = engine.evaluate(arg0);
                arg1 = engine.evaluate(arg1);
            }
            if (arg0.isInteger() && arg1.isInteger()) {
                numerator = (IInteger)arg0;
                IInteger denominator = (IInteger)arg1;
                if (denominator.isZero()) {
                    EvalEngine ee = EvalEngine.get();
                    if (numerator.isZero()) {
                        if (!ee.isQuietMode()) {
                            ee.getOutPrintStream().println("Division by zero expression: " + numerator.toString() + "/" + denominator.toString());
                        }
                        return F.Indeterminate;
                    }
                    if (!ee.isQuietMode()) {
                        ee.getOutPrintStream().println("Division by zero expression: " + numerator.toString() + "/" + denominator.toString());
                    }
                    return F.CComplexInfinity;
                }
                if (numerator.isZero()) {
                    return F.C0;
                }
                return F.fraction((IInteger)numerator, denominator);
            }
            if (arg0 instanceof INum && arg1 instanceof INum) {
                numerator = (INum)arg0;
                INum denominator = (INum)arg1;
                if (denominator.isZero()) {
                    EvalEngine ee = EvalEngine.get();
                    if (numerator.isZero()) {
                        if (!ee.isQuietMode()) {
                            ee.getOutPrintStream().println("Division by zero expression: " + numerator.toString() + "/" + denominator.toString());
                        }
                        return F.Indeterminate;
                    }
                    if (!ee.isQuietMode()) {
                        ee.getOutPrintStream().println("Division by zero expression: " + numerator.toString() + "/" + denominator.toString());
                    }
                    return F.CComplexInfinity;
                }
                if (numerator.isZero()) {
                    return F.C0;
                }
                return F.num(numerator.doubleValue() / denominator.doubleValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

