/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Predicate;
import java.math.BigInteger;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class PrimeQ
extends AbstractFunctionEvaluator
implements Predicate<IExpr> {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        if (!ast.arg1().isInteger()) {
            return F.False;
        }
        return F.bool(this.apply(ast.arg1()));
    }

    public boolean apply(IExpr obj) {
        try {
            BigInteger value = ((IInteger)obj).getBigNumerator();
            return value.isProbablePrime(32);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }
}

