/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;

public class Package
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 4);
        if (!(ast.arg1() instanceof IStringX && ((IExpr)ast.get(2)).isList() && ((IExpr)ast.get(3)).isList())) {
            throw new WrongNumberOfArguments(ast, 1, ast.size() - 1);
        }
        if (Config.SERVER_MODE) {
            throw new RuleCreationError(null);
        }
        IAST symbols = (IAST)ast.get(2);
        IAST list = (IAST)ast.get(3);
        Package.evalPackage(symbols, list);
        return F.Null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evalPackage(IAST publicSymbols, IAST list) {
        int i;
        HashMap<ISymbol, ISymbol> convertedSymbolMap = new HashMap<ISymbol, ISymbol>();
        HashSet<ISymbol> publicSymbolSet = new HashSet<ISymbol>();
        for (i = 1; i < publicSymbols.size(); ++i) {
            IExpr expr = (IExpr)publicSymbols.get(i);
            if (!expr.isSymbol()) continue;
            publicSymbolSet.add((ISymbol)expr);
            ISymbol toSymbol = F.predefinedSymbol(((ISymbol)expr).toString());
            convertedSymbolMap.put((ISymbol)expr, toSymbol);
        }
        for (i = 1; i < list.size(); ++i) {
            if (!((IExpr)list.get(i)).isAST()) continue;
            Package.determineRuleHead((IAST)list.get(i), publicSymbolSet, convertedSymbolMap);
        }
        IAST resultList = F.List();
        for (int i2 = 1; i2 < list.size(); ++i2) {
            resultList.add(Package.convertSymbolsInExpr((IExpr)list.get(i2), convertedSymbolMap));
        }
        EvalEngine engine = EvalEngine.get();
        try {
            engine.setPackageMode(true);
            for (int i3 = 1; i3 < resultList.size(); ++i3) {
                EvalEngine.eval((IExpr)resultList.get(i3));
            }
        }
        finally {
            engine.setPackageMode(false);
        }
    }

    private static void determineRuleHead(IAST rule, HashSet<ISymbol> unprotectedSymbolSet, HashMap<ISymbol, ISymbol> convertedSymbolMap) {
        if (rule.size() > 1 && (rule.head().equals(F.Set) || rule.head().equals(F.SetDelayed) || rule.head().equals(F.UpSet) || rule.head().equals(F.UpSetDelayed))) {
            ISymbol toSymbol;
            ISymbol lhsHead = null;
            if (rule.arg1().isAST()) {
                lhsHead = ((IAST)rule.arg1()).topHead();
            } else if (rule.arg1().isSymbol()) {
                lhsHead = (ISymbol)rule.arg1();
            }
            if (lhsHead != null && !unprotectedSymbolSet.contains(lhsHead) && (toSymbol = convertedSymbolMap.get(lhsHead)) == null) {
                toSymbol = F.predefinedSymbol("@" + EvalEngine.getNextCounter() + lhsHead.toString());
                convertedSymbolMap.put(lhsHead, toSymbol);
            }
        }
    }

    private static IExpr convertSymbolsInExpr(IExpr expr, HashMap<ISymbol, ISymbol> convertedSymbols) {
        ISymbol toSymbol;
        IExpr result = expr;
        if (expr.isAST()) {
            result = Package.convertSymbolsInList((IAST)expr, convertedSymbols);
        } else if (expr.isSymbol() && (toSymbol = convertedSymbols.get((ISymbol)expr)) != null) {
            result = toSymbol;
        }
        return result;
    }

    private static IAST convertSymbolsInList(IAST ast, HashMap<ISymbol, ISymbol> convertedSymbols) {
        IAST result = ast.clone();
        for (int i = 0; i < result.size(); ++i) {
            ISymbol toSymbol;
            IExpr expr = (IExpr)result.get(i);
            if (expr.isAST()) {
                result.set(i, Package.convertSymbolsInList((IAST)expr, convertedSymbols));
                continue;
            }
            if (!expr.isSymbol() || (toSymbol = convertedSymbols.get((ISymbol)expr)) == null) continue;
            result.set(i, toSymbol);
        }
        return result;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPackage(EvalEngine engine, Reader is) {
        String record = null;
        BufferedReader r = new BufferedReader(is);
        try {
            StringBuilder builder = new StringBuilder(2048);
            while ((record = r.readLine()) != null) {
                builder.append(record);
                builder.append('\n');
            }
            IExpr parsedExpression = engine.parse(builder.toString());
            if (parsedExpression != null && parsedExpression.isAST()) {
                IAST ast = (IAST)parsedExpression;
                if (!(ast.size() == 4 && ast.arg1() instanceof IStringX && ast.arg2().isList() && ast.arg3().isList())) {
                    throw new WrongNumberOfArguments(ast, 3, ast.size() - 1);
                }
                IAST symbols = (IAST)ast.arg2();
                IAST list = (IAST)ast.arg3();
                Package.evalPackage(symbols, list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                r.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

