/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.linear.BlockFieldMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.exception.NonNegativeIntegerExpected;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ExprField;
import org.matheclipse.core.expression.ExprFieldElement;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class MatrixPower
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        try {
            FieldMatrix matrix = Convert.list2Matrix((IAST)ast.arg1());
            int p = Validate.checkIntType(ast, 2, Integer.MIN_VALUE);
            if (p < 0) {
                return null;
            }
            if (p == 1) {
                ((IAST)ast.arg1()).addEvalFlags(32);
                return ast.arg1();
            }
            if (p == 0) {
                BlockFieldMatrix resultMatrix = new BlockFieldMatrix((Field)ExprField.CONST, matrix.getRowDimension(), matrix.getColumnDimension());
                int min = matrix.getRowDimension();
                if (min > matrix.getColumnDimension()) {
                    min = matrix.getColumnDimension();
                }
                for (int i = 0; i < min; ++i) {
                    resultMatrix.setEntry(i, i, (FieldElement)ExprField.CONST.getOne());
                }
                return Convert.matrix2List((FieldMatrix<ExprFieldElement>)resultMatrix);
            }
            FieldMatrix resultMatrix = matrix;
            for (int i = 1; i < p; ++i) {
                resultMatrix = resultMatrix.multiply(matrix);
            }
            return Convert.matrix2List(resultMatrix);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
            throw new NonNegativeIntegerExpected(ast, 2);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return null;
    }
}

