/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.HashMap;
import java.util.Map;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Function
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.head().isAST()) {
            IAST function = (IAST)ast.head();
            if (function.size() == 2) {
                return Function.replaceSlots(function.arg1(), ast);
            }
            if (function.size() == 3) {
                IAST symbolSlots = null;
                symbolSlots = function.arg1().isList() ? (IAST)function.arg1() : F.List(function.arg1());
                if (symbolSlots.size() > ast.size()) {
                    throw new WrongNumberOfArguments(ast, symbolSlots.size() - 1, ast.size() - 1);
                }
                IExpr result = ((IExpr)function.get(2)).replaceAll(Functors.rules(this.getRulesMap(symbolSlots, ast)));
                return result == null ? function.arg2() : result;
            }
        }
        return null;
    }

    private Map<IExpr, IExpr> getRulesMap(IAST symbolSlots, IAST ast) {
        HashMap<IExpr, IExpr> rulesMap = new HashMap<IExpr, IExpr>();
        int size = symbolSlots.size();
        for (int i = 1; i < size; ++i) {
            rulesMap.put((IExpr)symbolSlots.get(i), (IExpr)ast.get(i));
        }
        return rulesMap;
    }

    public static IExpr replaceSlots(IExpr expr, IAST list) {
        IExpr result = expr.replaceSlots(list);
        return result == null ? expr : result;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

