/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import cc.redberry.core.math.frobenius.FrobeniusSolver;
import org.matheclipse.core.convert.Lists;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class FrobeniusSolve
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        if (ast.arg1().isList()) {
            IAST list = ast.getAST(1);
            try {
                int[][] equations = new int[1][list.size()];
                for (int i = 1; i < list.size(); ++i) {
                    equations[0][i - 1] = ((ISignedNumber)list.get(i)).toInt();
                }
                equations[0][list.size() - 1] = ((ISignedNumber)ast.get(2)).toInt();
                int numberOfSolutions = -1;
                if (ast.size() == 4) {
                    numberOfSolutions = ((ISignedNumber)ast.get(3)).toInt();
                }
                FrobeniusSolver solver = new FrobeniusSolver(equations);
                IAST result = F.List();
                if (numberOfSolutions < 0) {
                    int[] solution;
                    while ((solution = solver.take()) != null) {
                        result.add(Lists.asList(solution));
                    }
                } else {
                    int[] solution;
                    while ((solution = solver.take()) != null && --numberOfSolutions >= 0) {
                        result.add(Lists.asList(solution));
                    }
                }
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

