/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.BisectionSolver;
import org.apache.commons.math3.analysis.solvers.BrentSolver;
import org.apache.commons.math3.analysis.solvers.IllinoisSolver;
import org.apache.commons.math3.analysis.solvers.MullerSolver;
import org.apache.commons.math3.analysis.solvers.PegasusSolver;
import org.apache.commons.math3.analysis.solvers.RegulaFalsiSolver;
import org.apache.commons.math3.analysis.solvers.RiddersSolver;
import org.apache.commons.math3.analysis.solvers.SecantSolver;
import org.matheclipse.commons.math.analysis.solvers.NewtonSolver;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class FindRoot
extends AbstractFunctionEvaluator {
    public static final ISymbol Newton = F.initFinalSymbol(Config.PARSER_USE_LOWERCASE_SYMBOLS ? "newton" : "Newton");

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3);
        ISymbol method = Newton;
        int maxIterations = 100;
        if (ast.size() >= 4) {
            IExpr optionMethod;
            Options options = new Options(ast.topHead(), ast, 3);
            IExpr optionMaxIterations = options.getOption("MaxIterations");
            if (optionMaxIterations != null && optionMaxIterations.isSignedNumber()) {
                maxIterations = ((ISignedNumber)optionMaxIterations).toInt();
            }
            if ((optionMethod = options.getOption("Method")) != null && optionMethod.isSymbol()) {
                method = (ISymbol)optionMethod;
            } else if (((IExpr)ast.get(3)).isSymbol()) {
                method = (ISymbol)ast.arg3();
            }
        }
        if (ast.arg2().isList()) {
            IAST list = (IAST)ast.arg2();
            IExpr function = ast.arg1();
            if (list.size() >= 3 && list.arg1().isSymbol() && list.arg2().isSignedNumber()) {
                if (function.isAST(F.Equal, 3)) {
                    function = F.Plus(((IAST)function).arg1(), (IExpr)F.Times((IExpr)F.CN1, ((IAST)function).arg2()));
                }
                return F.List((IExpr)F.Rule(list.arg1(), Num.valueOf(this.findRoot(method, maxIterations, list, function))));
            }
        }
        return null;
    }

    private double findRoot(ISymbol method, int maxIterations, IAST list, IExpr function) {
        ISymbol xVar = (ISymbol)list.arg1();
        ISignedNumber min = (ISignedNumber)list.arg2();
        ISignedNumber max = null;
        if (list.size() > 3 && list.get(3) instanceof ISignedNumber) {
            max = (ISignedNumber)list.get(3);
        }
        EvalEngine engine = EvalEngine.get();
        function = F.eval(function);
        UnaryNumerical f = new UnaryNumerical(function, xVar, engine);
        BisectionSolver solver = null;
        if (method.isSymbolName("Bisection")) {
            solver = new BisectionSolver();
        } else if (method.isSymbolName("Brent")) {
            solver = new BrentSolver();
        } else if (method.isSymbolName("Muller")) {
            solver = new MullerSolver();
        } else if (method.isSymbolName("Ridders")) {
            solver = new RiddersSolver();
        } else if (method.isSymbolName("Secant")) {
            solver = new SecantSolver();
        } else if (method.isSymbolName("RegulaFalsi")) {
            solver = new RegulaFalsiSolver();
        } else if (method.isSymbolName("Illinois")) {
            solver = new IllinoisSolver();
        } else if (method.isSymbolName("Pegasus")) {
            solver = new PegasusSolver();
        } else {
            UnaryNumerical fNewton = new UnaryNumerical(function, xVar, engine);
            NewtonSolver solver2 = new NewtonSolver();
            if (max == null) {
                return solver2.solve(maxIterations, fNewton, min.doubleValue());
            }
            return solver2.solve(maxIterations, fNewton, min.doubleValue(), max.doubleValue());
        }
        if (max == null) {
            return solver.solve(maxIterations, (UnivariateFunction)f, min.doubleValue());
        }
        return solver.solve(maxIterations, (UnivariateFunction)f, min.doubleValue(), max.doubleValue());
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(32);
    }
}

