/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorComplex;
import edu.jas.ufd.FactorFactory;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.convert.JASModInteger;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Factor
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        ExprVariables eVar = new ExprVariables(ast.arg1());
        try {
            IExpr expr = F.evalExpandAll(ast.arg1());
            ASTRange r = new ASTRange(eVar.getVarList(), 1);
            List<IExpr> varList = r.toList();
            if (ast.size() == 3) {
                return Factor.factorWithOption(ast, expr, varList, false);
            }
            return Factor.factor(expr, varList, false);
        }
        catch (JASConversionException jASConversionException) {
            return null;
        }
    }

    public static IExpr factor(IExpr expr, List<IExpr> varList, boolean factorSquareFree) throws JASConversionException {
        JASConvert jas = new JASConvert((List<? extends IExpr>)varList, BigRational.ZERO);
        GenPolynomial polyRat = jas.expr2JAS(expr);
        Object[] objects = jas.factorTerms(polyRat);
        java.math.BigInteger gcd = (java.math.BigInteger)objects[0];
        java.math.BigInteger lcm = (java.math.BigInteger)objects[1];
        GenPolynomial poly = (GenPolynomial)objects[2];
        FactorAbstract factorAbstract = FactorFactory.getImplementation((BigInteger)BigInteger.ONE);
        SortedMap map = factorSquareFree ? factorAbstract.squarefreeFactors(poly) : factorAbstract.factors(poly);
        IAST result = F.Times();
        if (!gcd.equals(java.math.BigInteger.ONE) || !lcm.equals(java.math.BigInteger.ONE)) {
            result.add(F.fraction(gcd, lcm));
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((GenPolynomial)entry.getKey()).isONE() && ((Long)entry.getValue()).equals(1L)) continue;
            result.add(F.Power(jas.integerPoly2Expr((GenPolynomial<BigInteger>)((GenPolynomial)entry.getKey())), F.integer((Long)entry.getValue())));
        }
        return result;
    }

    public static IExpr factorList(IExpr expr, List<IExpr> varList, boolean factorSquareFree) throws JASConversionException {
        JASConvert jas = new JASConvert((List<? extends IExpr>)varList, BigRational.ZERO);
        GenPolynomial polyRat = jas.expr2JAS(expr);
        Object[] objects = jas.factorTerms(polyRat);
        java.math.BigInteger gcd = (java.math.BigInteger)objects[0];
        java.math.BigInteger lcm = (java.math.BigInteger)objects[1];
        GenPolynomial poly = (GenPolynomial)objects[2];
        FactorAbstract factorAbstract = FactorFactory.getImplementation((BigInteger)BigInteger.ONE);
        SortedMap map = factorSquareFree ? factorAbstract.squarefreeFactors(poly) : factorAbstract.factors(poly);
        IAST result = F.List();
        if (!gcd.equals(java.math.BigInteger.ONE) || !lcm.equals(java.math.BigInteger.ONE)) {
            result.add(F.List((IExpr)F.fraction(gcd, lcm), (IExpr)F.C1));
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((GenPolynomial)entry.getKey()).isONE() && ((Long)entry.getValue()).equals(1L)) continue;
            result.add(F.List(jas.integerPoly2Expr((GenPolynomial<BigInteger>)((GenPolynomial)entry.getKey())), (IExpr)F.integer((Long)entry.getValue())));
        }
        return result;
    }

    public static IExpr factorWithOption(IAST ast, IExpr expr, List<IExpr> varList, boolean factorSquareFree) throws JASConversionException {
        Options options = new Options(ast.topHead(), ast, 2);
        IExpr option = options.getOption("Modulus");
        if (option != null && option.isSignedNumber()) {
            return Factor.factorModulus(expr, varList, factorSquareFree, option);
        }
        option = options.getOption("GaussianIntegers");
        if (option != null && option.isTrue()) {
            return Factor.factorComplex(expr, varList, F.Times, false);
        }
        option = options.getOption("Extension");
        if (option != null && option.equals(F.CI)) {
            return Factor.factorComplex(expr, varList, F.Times, false);
        }
        return null;
    }

    public static IAST factorComplex(IExpr expr, List<IExpr> varList, ISymbol head, boolean noGCDLCM) throws JASConversionException {
        JASConvert jas = new JASConvert((List<? extends IExpr>)varList, BigRational.ZERO);
        TermOrder to = new TermOrder(2);
        GenPolynomial polyRat = jas.expr2JAS(expr);
        String[] vars = new String[varList.size()];
        for (int i = 0; i < varList.size(); ++i) {
            vars[i] = varList.get(i).toString();
        }
        Object[] objects = JASConvert.rationalFromRationalCoefficientsFactor((GenPolynomialRing<BigRational>)new GenPolynomialRing((RingFactory)BigRational.ZERO, varList.size(), to, vars), polyRat);
        java.math.BigInteger gcd = (java.math.BigInteger)objects[0];
        java.math.BigInteger lcm = (java.math.BigInteger)objects[1];
        GenPolynomial poly = (GenPolynomial)objects[2];
        BigRational rfac = new BigRational(1L);
        ComplexRing cfac = new ComplexRing((RingFactory)BigRational.ZERO);
        GenPolynomialRing cpfac = new GenPolynomialRing((RingFactory)cfac, 1, to);
        GenPolynomial a = PolyUtil.complexFromAny((GenPolynomialRing)cpfac, (GenPolynomial)poly);
        FactorComplex factorAbstract = new FactorComplex(cfac);
        SortedMap map = factorAbstract.factors(a);
        IAST result = F.ast(head);
        if (!(noGCDLCM || gcd.equals(java.math.BigInteger.ONE) && lcm.equals(java.math.BigInteger.ONE))) {
            result.add(F.fraction(gcd, lcm));
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((GenPolynomial)entry.getKey()).isONE() && ((Long)entry.getValue()).equals(1L)) continue;
            GenPolynomial temp = (GenPolynomial)entry.getKey();
            result.add(F.Power(jas.complexPoly2Expr((GenPolynomial<Complex<BigRational>>)((GenPolynomial)entry.getKey())), F.integer((Long)entry.getValue())));
        }
        return result;
    }

    private static IAST factorModulus(IExpr expr, List<IExpr> varList, boolean factorSquareFree, IExpr option) throws JASConversionException {
        try {
            ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
            JASModInteger jas = new JASModInteger(varList, modIntegerRing);
            GenPolynomial<ModLong> poly = jas.expr2JAS(expr);
            return Factor.factorModulus(jas, modIntegerRing, poly, factorSquareFree);
        }
        catch (ArithmeticException ae) {
            return null;
        }
    }

    public static IAST factorModulus(JASModInteger jas, ModLongRing modIntegerRing, GenPolynomial<ModLong> poly, boolean factorSquareFree) {
        FactorAbstract factorAbstract = FactorFactory.getImplementation((ModLongRing)modIntegerRing);
        SortedMap map = factorSquareFree ? factorAbstract.squarefreeFactors(poly) : factorAbstract.factors(poly);
        IAST result = F.Times();
        for (Map.Entry entry : map.entrySet()) {
            GenPolynomial singleFactor = (GenPolynomial)entry.getKey();
            Long val = (Long)entry.getValue();
            result.add(F.Power((IExpr)jas.modLongPoly2Expr((GenPolynomial<ModLong>)singleFactor), F.integer(val)));
        }
        return result;
    }
}

