/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.reflection.system.Expand;

public class ExpandAll
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        IExpr temp;
        Validate.checkRange(ast, 2, 3);
        IExpr patt = null;
        if (ast.size() > 2) {
            patt = ast.arg2();
        }
        if ((temp = ExpandAll.expandAll(ast.arg1(), patt)) != null) {
            return temp;
        }
        return ast.arg1();
    }

    public static IExpr expandAll(IExpr expr, IExpr patt) {
        if (!expr.isAST()) {
            return null;
        }
        IAST ast = (IAST)expr;
        if (patt != null && ast.isFree(patt, true)) {
            return null;
        }
        int j = ast.size();
        IExpr temp = null;
        for (int i = 1; i < ast.size(); ++i) {
            if (!((IExpr)ast.get(i)).isAST()) continue;
            j = i;
            break;
        }
        if (j >= ast.size()) {
            return null;
        }
        IAST result = ast.clone();
        for (int i = j; i < ast.size(); ++i) {
            if (!((IExpr)ast.get(i)).isAST() || (temp = ExpandAll.expandAll((IExpr)ast.get(i), patt)) == null) continue;
            result.set(i, temp);
        }
        temp = Expand.expand(result, patt);
        if (temp != null) {
            return temp;
        }
        return result;
    }
}

