/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.generic.combinatoric.KPermutationsIterable;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.reflection.system.Apart;
import org.matheclipse.core.reflection.system.Multinomial;

public class Expand
extends AbstractFunctionEvaluator {
    public static IExpr expand(IAST ast, IExpr patt) {
        Expander expander = new Expander(patt);
        return expander.expand(ast);
    }

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        if (ast.arg1().isAST()) {
            IExpr temp;
            IExpr patt = null;
            if (ast.size() > 2) {
                patt = ast.arg2();
            }
            if ((temp = Expand.expand((IAST)ast.arg1(), patt)) != null) {
                return temp;
            }
        }
        return ast.arg1();
    }

    static class NumberPartititon {
        IAST expandedResult;
        int m;
        int n;
        int[] parts;
        IAST precalculatedPowerASTs;

        public NumberPartititon(IAST plusAST, int n, IAST expandedResult) {
            this.expandedResult = expandedResult;
            this.n = n;
            this.m = plusAST.size() - 1;
            this.parts = new int[this.m];
            this.precalculatedPowerASTs = F.List();
            for (IExpr expr : plusAST) {
                this.precalculatedPowerASTs.add(F.Power(expr, F.Null));
            }
        }

        private void addFactor(int[] j) {
            KPermutationsIterable perm = new KPermutationsIterable(j, this.m, this.m);
            IInteger multinomial = F.integer(Multinomial.multinomial(j, this.n));
            IAST times = F.Times();
            for (int[] indices : perm) {
                IAST timesAST = times.clone();
                if (!multinomial.isOne()) {
                    timesAST.add(multinomial);
                }
                for (int k = 0; k < this.m; ++k) {
                    if (indices[k] == 0) continue;
                    IAST temp = this.precalculatedPowerASTs.getAST(k + 1).clone();
                    if (indices[k] == 1) {
                        timesAST.add(temp.arg1());
                        continue;
                    }
                    temp.set(2, F.integer(indices[k]));
                    timesAST.add(temp);
                }
                this.expandedResult.add(timesAST);
            }
        }

        public void partition() {
            this.partition(this.n, this.n, 0);
        }

        private void partition(int n, int max, int currentIndex) {
            int min;
            if (n == 0) {
                this.addFactor(this.parts);
                return;
            }
            if (currentIndex >= this.m) {
                return;
            }
            int old = this.parts[currentIndex];
            for (int i = min = Math.min(max, n); i >= 1; --i) {
                this.parts[currentIndex] = i;
                this.partition(n - i, i, currentIndex + 1);
            }
            this.parts[currentIndex] = old;
        }
    }

    private static class Expander {
        IExpr pattern;

        public Expander(IExpr pattern) {
            this.pattern = pattern;
        }

        public boolean isPatternFree(IExpr expression) {
            return this.pattern != null && expression.isFree(this.pattern, false);
        }

        public IExpr expand(IAST ast) {
            if (this.isPatternFree(ast)) {
                return null;
            }
            if (ast.isPower()) {
                return this.expandPowerNull(ast);
            }
            if (ast.isTimes()) {
                IExpr denom;
                IExpr[] temp = Apart.getFractionalPartsTimes(ast, false);
                if (temp[0].equals(F.C1)) {
                    IExpr denom2;
                    if (temp[1].isTimes()) {
                        return F.Power(this.expandTimes((IAST)temp[1]), F.CN1);
                    }
                    if ((temp[1].isPower() || temp[1].isPlus()) && (denom2 = this.expand((IAST)temp[1])) != null) {
                        return F.Power(denom2, F.CN1);
                    }
                    return null;
                }
                if (temp[1].equals(F.C1)) {
                    return this.expandTimes(ast);
                }
                if (temp[0].isTimes()) {
                    temp[0] = this.expandTimes((IAST)temp[0]);
                }
                if (temp[1].isTimes()) {
                    temp[1] = this.expandTimes((IAST)temp[1]);
                } else if ((temp[1].isPower() || temp[1].isPlus()) && (denom = this.expand((IAST)temp[1])) != null) {
                    temp[1] = denom;
                }
                return F.Times(temp[0], (IExpr)F.Power(temp[1], F.CN1));
            }
            if (ast.isPlus()) {
                return ast.map(Functors.replace1st(F.Expand(F.Null)));
            }
            return null;
        }

        public IExpr expandPowerNull(IAST powerAST) {
            try {
                int exp = Validate.checkPowerExponent(powerAST);
                if (powerAST.arg1().isPlus()) {
                    if (exp < 0) {
                        return F.Power(this.expandPower((IAST)powerAST.arg1(), exp *= -1), F.CN1);
                    }
                    return this.expandPower((IAST)powerAST.arg1(), exp);
                }
            }
            catch (WrongArgumentType e) {
                return null;
            }
            return null;
        }

        private IExpr expandPower(IAST plusAST, int n) {
            if (n == 1) {
                return plusAST;
            }
            if (n == 0) {
                return F.C1;
            }
            IAST expandedResult = F.Plus();
            NumberPartititon part = new NumberPartititon(plusAST, n, expandedResult);
            part.partition();
            return expandedResult;
        }

        private IExpr expandTimes(IAST timesAST) {
            IExpr temp;
            IExpr result = timesAST.arg1();
            if (result.isPower() && (temp = this.expandPowerNull((IAST)result)) != null) {
                result = temp;
            }
            for (int i = 2; i < timesAST.size(); ++i) {
                temp = (IExpr)timesAST.get(i);
                if (temp.isPower() && (temp = this.expandPowerNull((IAST)temp)) == null) {
                    temp = (IExpr)timesAST.get(i);
                }
                result = this.expandTimesBinary(result, temp);
            }
            return result;
        }

        private IExpr expandTimesBinary(IExpr expr0, IExpr expr1) {
            if (expr0.isPlus()) {
                if (!expr1.isPlus()) {
                    return F.eval(this.expandTimesPlus(expr1, (IAST)expr0));
                }
                IAST ast1 = this.assurePlus(expr1);
                return F.eval(this.expandTimesPlus((IAST)expr0, ast1));
            }
            if (expr1.isPlus()) {
                if (!expr0.isPlus()) {
                    return F.eval(this.expandTimesPlus(expr0, (IAST)expr1));
                }
                IAST ast0 = this.assurePlus(expr0);
                return F.eval(this.expandTimesPlus(ast0, (IAST)expr1));
            }
            return F.eval(F.Times(expr0, expr1));
        }

        private IAST expandTimesPlus(IAST plusAST0, IAST plusAST1) {
            IAST pList = F.Plus();
            for (int i = 1; i < plusAST0.size(); ++i) {
                plusAST1.args().map(pList, Functors.replace2nd(F.Times((IExpr)plusAST0.get(i), (IExpr)F.Null)));
            }
            return pList;
        }

        private IAST expandTimesPlus(IExpr expr1, IAST plusAST) {
            IAST pList = F.Plus();
            for (int i = 1; i < plusAST.size(); ++i) {
                pList.add(F.Times(expr1, (IExpr)plusAST.get(i)));
            }
            return pList;
        }

        private IAST assurePlus(IExpr expr) {
            if (expr.isPlus()) {
                return (IAST)expr;
            }
            return F.Plus(expr);
        }
    }
}

